/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public abstract class RegisteredRpcConnection<F extends Serializable, G extends RpcGateway, S extends RegistrationResponse.Success> {
    private static final AtomicReferenceFieldUpdater<RegisteredRpcConnection, RetryingRegistration> REGISTRATION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RegisteredRpcConnection.class, RetryingRegistration.class, "pendingRegistration");
    protected final Logger log;
    private final F fencingToken;
    private final String targetAddress;
    private final Executor executor;
    private volatile RetryingRegistration<F, G, S> pendingRegistration;
    private volatile G targetGateway;
    private volatile boolean closed;

    public RegisteredRpcConnection(Logger log, String targetAddress, F fencingToken, Executor executor) {
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.targetAddress = (String)Preconditions.checkNotNull((Object)targetAddress);
        this.fencingToken = (Serializable)Preconditions.checkNotNull(fencingToken);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public void start() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"The RPC connection is already closed");
        Preconditions.checkState((!this.isConnected() && this.pendingRegistration == null ? 1 : 0) != 0, (Object)"The RPC connection is already started");
        RetryingRegistration<F, G, S> newRegistration = this.createNewRegistration();
        if (REGISTRATION_UPDATER.compareAndSet(this, null, newRegistration)) {
            newRegistration.startRegistration();
        } else {
            newRegistration.cancel();
        }
    }

    public boolean tryReconnect() {
        RetryingRegistration<F, G, S> newRegistration;
        Preconditions.checkState((boolean)this.isConnected(), (Object)"Cannot reconnect to an unknown destination.");
        if (this.closed) {
            return false;
        }
        RetryingRegistration<F, G, S> currentPendingRegistration = this.pendingRegistration;
        if (currentPendingRegistration != null) {
            currentPendingRegistration.cancel();
        }
        if (!REGISTRATION_UPDATER.compareAndSet(this, currentPendingRegistration, newRegistration = this.createNewRegistration())) {
            newRegistration.cancel();
            return false;
        }
        newRegistration.startRegistration();
        if (this.closed) {
            newRegistration.cancel();
            return false;
        }
        return true;
    }

    protected abstract RetryingRegistration<F, G, S> generateRegistration();

    protected abstract void onRegistrationSuccess(S var1);

    protected abstract void onRegistrationFailure(Throwable var1);

    public void close() {
        this.closed = true;
        if (this.pendingRegistration != null) {
            this.pendingRegistration.cancel();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public F getTargetLeaderId() {
        return this.fencingToken;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public G getTargetGateway() {
        return this.targetGateway;
    }

    public boolean isConnected() {
        return this.targetGateway != null;
    }

    public String toString() {
        String connectionInfo = "(ADDRESS: " + this.targetAddress + " FENCINGTOKEN: " + this.fencingToken + ")";
        connectionInfo = this.isConnected() ? "RPC connection to " + this.targetGateway.getClass().getSimpleName() + " " + connectionInfo : "RPC connection to " + connectionInfo;
        connectionInfo = this.isClosed() ? connectionInfo + " is closed" : (this.isConnected() ? connectionInfo + " is established" : connectionInfo + " is connecting");
        return connectionInfo;
    }

    private RetryingRegistration<F, G, S> createNewRegistration() {
        RetryingRegistration newRegistration = (RetryingRegistration)Preconditions.checkNotNull(this.generateRegistration());
        CompletableFuture future = newRegistration.getFuture();
        future.whenCompleteAsync((result, failure) -> {
            if (failure != null) {
                if (failure instanceof CancellationException) {
                    this.log.debug("Retrying registration towards {} was cancelled.", (Object)this.targetAddress);
                } else {
                    this.onRegistrationFailure((Throwable)failure);
                }
            } else {
                this.targetGateway = (RpcGateway)result.f0;
                this.onRegistrationSuccess((RegistrationResponse.Success)result.f1);
            }
        }, this.executor);
        return newRegistration;
    }
}

