/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.util.Preconditions;

public class DefaultExecutionGraphCache
implements ExecutionGraphCache {
    private final Time timeout;
    private final Time timeToLive;
    private final ConcurrentHashMap<JobID, ExecutionGraphEntry> cachedExecutionGraphs;
    private volatile boolean running = true;

    public DefaultExecutionGraphCache(Time timeout, Time timeToLive) {
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.timeToLive = (Time)Preconditions.checkNotNull((Object)timeToLive);
        this.cachedExecutionGraphs = new ConcurrentHashMap(4);
    }

    @Override
    public void close() {
        this.running = false;
        this.cachedExecutionGraphs.clear();
    }

    @Override
    public int size() {
        return this.cachedExecutionGraphs.size();
    }

    @Override
    public CompletableFuture<AccessExecutionGraph> getExecutionGraph(JobID jobId, RestfulGateway restfulGateway) {
        return this.getExecutionGraphInternal(jobId, restfulGateway).thenApply(Function.identity());
    }

    private CompletableFuture<ArchivedExecutionGraph> getExecutionGraphInternal(JobID jobId, RestfulGateway restfulGateway) {
        ExecutionGraphEntry newEntry;
        boolean successfulUpdate;
        Preconditions.checkState((boolean)this.running, (Object)"ExecutionGraphCache is no longer running");
        do {
            CompletableFuture<ArchivedExecutionGraph> executionGraphFuture;
            ExecutionGraphEntry oldEntry = this.cachedExecutionGraphs.get(jobId);
            long currentTime = System.currentTimeMillis();
            if (oldEntry != null && currentTime < oldEntry.getTTL() && !(executionGraphFuture = oldEntry.getExecutionGraphFuture()).isCompletedExceptionally()) {
                return executionGraphFuture;
            }
            newEntry = new ExecutionGraphEntry(currentTime + this.timeToLive.toMilliseconds());
            if (oldEntry == null) {
                successfulUpdate = this.cachedExecutionGraphs.putIfAbsent(jobId, newEntry) == null;
                continue;
            }
            successfulUpdate = this.cachedExecutionGraphs.replace(jobId, oldEntry, newEntry);
            oldEntry.getExecutionGraphFuture().cancel(false);
        } while (!successfulUpdate);
        CompletableFuture<ArchivedExecutionGraph> executionGraphFuture = restfulGateway.requestJob(jobId, this.timeout);
        executionGraphFuture.whenComplete((executionGraph, throwable) -> {
            if (throwable != null) {
                newEntry.getExecutionGraphFuture().completeExceptionally((Throwable)throwable);
                this.cachedExecutionGraphs.remove(jobId, newEntry);
            } else {
                newEntry.getExecutionGraphFuture().complete((ArchivedExecutionGraph)executionGraph);
            }
        });
        if (!this.running) {
            this.cachedExecutionGraphs.remove(jobId, newEntry);
        }
        return newEntry.getExecutionGraphFuture();
    }

    @Override
    public void cleanup() {
        long currentTime = System.currentTimeMillis();
        this.cachedExecutionGraphs.values().removeIf(entry -> currentTime >= entry.getTTL());
    }

    private static final class ExecutionGraphEntry {
        private final long ttl;
        private final CompletableFuture<ArchivedExecutionGraph> executionGraphFuture;

        ExecutionGraphEntry(long ttl) {
            this.ttl = ttl;
            this.executionGraphFuture = new CompletableFuture();
        }

        public long getTTL() {
            return this.ttl;
        }

        public CompletableFuture<ArchivedExecutionGraph> getExecutionGraphFuture() {
            return this.executionGraphFuture;
        }
    }
}

