/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.ExecutionVertexSchedulingRequirements;
import org.apache.flink.runtime.scheduler.PreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

abstract class AbstractExecutionSlotAllocator
implements ExecutionSlotAllocator {
    private final Map<ExecutionVertexID, SlotExecutionVertexAssignment> pendingSlotAssignments;
    private final PreferredLocationsRetriever preferredLocationsRetriever;

    AbstractExecutionSlotAllocator(PreferredLocationsRetriever preferredLocationsRetriever) {
        this.preferredLocationsRetriever = (PreferredLocationsRetriever)Preconditions.checkNotNull((Object)preferredLocationsRetriever);
        this.pendingSlotAssignments = new HashMap<ExecutionVertexID, SlotExecutionVertexAssignment>();
    }

    @Override
    public void cancel(ExecutionVertexID executionVertexId) {
        SlotExecutionVertexAssignment slotExecutionVertexAssignment = this.pendingSlotAssignments.get(executionVertexId);
        if (slotExecutionVertexAssignment != null) {
            slotExecutionVertexAssignment.getLogicalSlotFuture().cancel(false);
        }
    }

    void validateSchedulingRequirements(Collection<ExecutionVertexSchedulingRequirements> schedulingRequirements) {
        schedulingRequirements.stream().map(ExecutionVertexSchedulingRequirements::getExecutionVertexId).forEach(id -> Preconditions.checkState((!this.pendingSlotAssignments.containsKey(id) ? 1 : 0) != 0, (String)"BUG: vertex %s tries to allocate a slot when its previous slot request is still pending", (Object[])new Object[]{id}));
    }

    SlotExecutionVertexAssignment createAndRegisterSlotExecutionVertexAssignment(ExecutionVertexID executionVertexId, CompletableFuture<LogicalSlot> logicalSlotFuture, Consumer<Throwable> slotRequestFailureHandler) {
        SlotExecutionVertexAssignment slotExecutionVertexAssignment = new SlotExecutionVertexAssignment(executionVertexId, logicalSlotFuture);
        this.pendingSlotAssignments.put(executionVertexId, slotExecutionVertexAssignment);
        logicalSlotFuture.whenComplete((ignored, throwable) -> {
            this.pendingSlotAssignments.remove(executionVertexId);
            if (throwable != null) {
                slotRequestFailureHandler.accept((Throwable)throwable);
            }
        });
        return slotExecutionVertexAssignment;
    }

    CompletableFuture<SlotProfile> getSlotProfileFuture(ExecutionVertexSchedulingRequirements schedulingRequirements, ResourceProfile physicalSlotResourceProfile, Set<ExecutionVertexID> producersToIgnore, Set<AllocationID> allPreviousAllocationIds) {
        CompletableFuture<Collection<TaskManagerLocation>> preferredLocationsFuture = this.preferredLocationsRetriever.getPreferredLocations(schedulingRequirements.getExecutionVertexId(), producersToIgnore);
        return preferredLocationsFuture.thenApply(preferredLocations -> SlotProfile.priorAllocation(schedulingRequirements.getTaskResourceProfile(), physicalSlotResourceProfile, preferredLocations, Collections.singletonList(schedulingRequirements.getPreviousAllocationId()), allPreviousAllocationIds));
    }

    @VisibleForTesting
    static Set<AllocationID> computeAllPriorAllocationIds(Collection<ExecutionVertexSchedulingRequirements> executionVertexSchedulingRequirements) {
        return executionVertexSchedulingRequirements.stream().map(ExecutionVertexSchedulingRequirements::getPreviousAllocationId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Map<ExecutionVertexID, SlotExecutionVertexAssignment> getPendingSlotAssignments() {
        return Collections.unmodifiableMap(this.pendingSlotAssignments);
    }
}

