/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.failover.flip1.PipelinedRegionComputeUtil;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionTopology
implements SchedulingTopology {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutionTopology.class);
    private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById;
    private final List<DefaultExecutionVertex> executionVerticesList;
    private final Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById;
    private final Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex;
    private final List<DefaultSchedulingPipelinedRegion> pipelinedRegions;

    private DefaultExecutionTopology(Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById, List<DefaultExecutionVertex> executionVerticesList, Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById, Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex, List<DefaultSchedulingPipelinedRegion> pipelinedRegions) {
        this.executionVerticesById = (Map)Preconditions.checkNotNull(executionVerticesById);
        this.executionVerticesList = (List)Preconditions.checkNotNull(executionVerticesList);
        this.resultPartitionsById = (Map)Preconditions.checkNotNull(resultPartitionsById);
        this.pipelinedRegionsByVertex = (Map)Preconditions.checkNotNull(pipelinedRegionsByVertex);
        this.pipelinedRegions = (List)Preconditions.checkNotNull(pipelinedRegions);
    }

    @Override
    public Iterable<DefaultExecutionVertex> getVertices() {
        return Collections.unmodifiableList(this.executionVerticesList);
    }

    @Override
    public DefaultExecutionVertex getVertex(ExecutionVertexID executionVertexId) {
        DefaultExecutionVertex executionVertex = this.executionVerticesById.get(executionVertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException("can not find vertex: " + executionVertexId);
        }
        return executionVertex;
    }

    @Override
    public DefaultResultPartition getResultPartition(IntermediateResultPartitionID intermediateResultPartitionId) {
        DefaultResultPartition resultPartition = this.resultPartitionsById.get(intermediateResultPartitionId);
        if (resultPartition == null) {
            throw new IllegalArgumentException("can not find partition: " + intermediateResultPartitionId);
        }
        return resultPartition;
    }

    @Override
    public Iterable<DefaultSchedulingPipelinedRegion> getAllPipelinedRegions() {
        Preconditions.checkNotNull(this.pipelinedRegions);
        return Collections.unmodifiableCollection(this.pipelinedRegions);
    }

    @Override
    public DefaultSchedulingPipelinedRegion getPipelinedRegionOfVertex(ExecutionVertexID vertexId) {
        Preconditions.checkNotNull(this.pipelinedRegionsByVertex);
        DefaultSchedulingPipelinedRegion pipelinedRegion = this.pipelinedRegionsByVertex.get(vertexId);
        if (pipelinedRegion == null) {
            throw new IllegalArgumentException("Unknown execution vertex " + vertexId);
        }
        return pipelinedRegion;
    }

    public static DefaultExecutionTopology fromExecutionGraph(ExecutionGraph executionGraph) {
        Preconditions.checkNotNull((Object)executionGraph, (String)"execution graph can not be null");
        ExecutionGraphIndex executionGraphIndex = DefaultExecutionTopology.computeExecutionGraphIndex(executionGraph.getAllExecutionVertices(), executionGraph.getTotalNumberOfVertices());
        IndexedPipelinedRegions indexedPipelinedRegions = DefaultExecutionTopology.computePipelinedRegions(executionGraphIndex.executionVerticesList);
        DefaultExecutionTopology.ensureCoLocatedVerticesInSameRegion(indexedPipelinedRegions.pipelinedRegions, executionGraph);
        return new DefaultExecutionTopology(executionGraphIndex.executionVerticesById, executionGraphIndex.executionVerticesList, executionGraphIndex.resultPartitionsById, indexedPipelinedRegions.pipelinedRegionsByVertex, indexedPipelinedRegions.pipelinedRegions);
    }

    private static ExecutionGraphIndex computeExecutionGraphIndex(Iterable<ExecutionVertex> executionVertices, int vertexNumber) {
        HashMap<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById = new HashMap<ExecutionVertexID, DefaultExecutionVertex>();
        ArrayList<DefaultExecutionVertex> executionVerticesList = new ArrayList<DefaultExecutionVertex>(vertexNumber);
        HashMap<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById = new HashMap<IntermediateResultPartitionID, DefaultResultPartition>();
        HashMap<ExecutionVertex, DefaultExecutionVertex> executionVertexMap = new HashMap<ExecutionVertex, DefaultExecutionVertex>();
        for (ExecutionVertex vertex : executionVertices) {
            List<DefaultResultPartition> producedPartitions = DefaultExecutionTopology.generateProducedSchedulingResultPartition(vertex.getProducedPartitions());
            producedPartitions.forEach(partition -> resultPartitionsById.put(partition.getId(), (DefaultResultPartition)partition));
            DefaultExecutionVertex schedulingVertex = DefaultExecutionTopology.generateSchedulingExecutionVertex(vertex, producedPartitions);
            executionVerticesById.put(schedulingVertex.getId(), schedulingVertex);
            executionVerticesList.add(schedulingVertex);
            executionVertexMap.put(vertex, schedulingVertex);
        }
        DefaultExecutionTopology.connectVerticesToConsumedPartitions(executionVertexMap, resultPartitionsById);
        return new ExecutionGraphIndex(executionVerticesById, executionVerticesList, resultPartitionsById);
    }

    private static List<DefaultResultPartition> generateProducedSchedulingResultPartition(Map<IntermediateResultPartitionID, IntermediateResultPartition> producedIntermediatePartitions) {
        ArrayList<DefaultResultPartition> producedSchedulingPartitions = new ArrayList<DefaultResultPartition>(producedIntermediatePartitions.size());
        producedIntermediatePartitions.values().forEach(irp -> producedSchedulingPartitions.add(new DefaultResultPartition(irp.getPartitionId(), irp.getIntermediateResult().getId(), irp.getResultType(), () -> irp.isConsumable() ? ResultPartitionState.CONSUMABLE : ResultPartitionState.CREATED)));
        return producedSchedulingPartitions;
    }

    private static DefaultExecutionVertex generateSchedulingExecutionVertex(ExecutionVertex vertex, List<DefaultResultPartition> producedPartitions) {
        DefaultExecutionVertex schedulingVertex = new DefaultExecutionVertex(vertex.getID(), producedPartitions, vertex::getExecutionState, vertex.getInputDependencyConstraint());
        producedPartitions.forEach(partition -> partition.setProducer(schedulingVertex));
        return schedulingVertex;
    }

    private static void connectVerticesToConsumedPartitions(Map<ExecutionVertex, DefaultExecutionVertex> executionVertexMap, Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitions) {
        for (Map.Entry<ExecutionVertex, DefaultExecutionVertex> mapEntry : executionVertexMap.entrySet()) {
            DefaultExecutionVertex schedulingVertex = mapEntry.getValue();
            ExecutionVertex executionVertex = mapEntry.getKey();
            for (int index = 0; index < executionVertex.getNumberOfInputs(); ++index) {
                for (ExecutionEdge edge : executionVertex.getInputEdges(index)) {
                    DefaultResultPartition partition = resultPartitions.get(edge.getSource().getPartitionId());
                    schedulingVertex.addConsumedResult(partition);
                    partition.addConsumer(schedulingVertex);
                }
            }
        }
    }

    private static IndexedPipelinedRegions computePipelinedRegions(Iterable<DefaultExecutionVertex> topologicallySortedVertexes) {
        long buildRegionsStartTime = System.nanoTime();
        Set<Set<DefaultExecutionVertex>> rawPipelinedRegions = PipelinedRegionComputeUtil.computePipelinedRegions(topologicallySortedVertexes);
        HashMap pipelinedRegionsByVertex = new HashMap();
        ArrayList<DefaultSchedulingPipelinedRegion> pipelinedRegions = new ArrayList<DefaultSchedulingPipelinedRegion>();
        for (Set<DefaultExecutionVertex> rawPipelinedRegion : rawPipelinedRegions) {
            DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(rawPipelinedRegion);
            pipelinedRegions.add(pipelinedRegion);
            for (SchedulingExecutionVertex schedulingExecutionVertex : rawPipelinedRegion) {
                pipelinedRegionsByVertex.put(schedulingExecutionVertex.getId(), pipelinedRegion);
            }
        }
        long buildRegionsDuration = (System.nanoTime() - buildRegionsStartTime) / 1000000L;
        LOG.info("Built {} pipelined regions in {} ms", (Object)pipelinedRegions.size(), (Object)buildRegionsDuration);
        return new IndexedPipelinedRegions(pipelinedRegionsByVertex, pipelinedRegions);
    }

    private static void ensureCoLocatedVerticesInSameRegion(List<DefaultSchedulingPipelinedRegion> pipelinedRegions, ExecutionGraph executionGraph) {
        IdentityHashMap<CoLocationConstraint, DefaultSchedulingPipelinedRegion> constraintToRegion = new IdentityHashMap<CoLocationConstraint, DefaultSchedulingPipelinedRegion>();
        for (DefaultSchedulingPipelinedRegion region : pipelinedRegions) {
            for (DefaultExecutionVertex vertex : region.getVertices()) {
                CoLocationConstraint constraint = DefaultExecutionTopology.getCoLocationConstraint(vertex.getId(), executionGraph);
                if (constraint == null) continue;
                DefaultSchedulingPipelinedRegion regionOfConstraint = (DefaultSchedulingPipelinedRegion)constraintToRegion.get(constraint);
                Preconditions.checkState((regionOfConstraint == null || regionOfConstraint == region ? 1 : 0) != 0, (Object)"co-located tasks must be in the same pipelined region");
                constraintToRegion.putIfAbsent(constraint, region);
            }
        }
    }

    private static CoLocationConstraint getCoLocationConstraint(ExecutionVertexID executionVertexId, ExecutionGraph executionGraph) {
        return executionGraph.getJobVertex(executionVertexId.getJobVertexId()).getTaskVertices()[executionVertexId.getSubtaskIndex()].getLocationConstraint();
    }

    private static class IndexedPipelinedRegions {
        private final Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex;
        private final List<DefaultSchedulingPipelinedRegion> pipelinedRegions;

        private IndexedPipelinedRegions(Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex, List<DefaultSchedulingPipelinedRegion> pipelinedRegions) {
            this.pipelinedRegionsByVertex = (Map)Preconditions.checkNotNull(pipelinedRegionsByVertex);
            this.pipelinedRegions = (List)Preconditions.checkNotNull(pipelinedRegions);
        }
    }

    private static class ExecutionGraphIndex {
        private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById;
        private final List<DefaultExecutionVertex> executionVerticesList;
        private final Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById;

        private ExecutionGraphIndex(Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById, List<DefaultExecutionVertex> executionVerticesList, Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById) {
            this.executionVerticesById = (Map)Preconditions.checkNotNull(executionVerticesById);
            this.executionVerticesList = (List)Preconditions.checkNotNull(executionVerticesList);
            this.resultPartitionsById = (Map)Preconditions.checkNotNull(resultPartitionsById);
        }
    }
}

