/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.util.Preconditions;

public class DefaultSchedulingPipelinedRegion
implements SchedulingPipelinedRegion {
    private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVertices;
    private Set<DefaultResultPartition> consumedResults;

    public DefaultSchedulingPipelinedRegion(Set<DefaultExecutionVertex> defaultExecutionVertices) {
        Preconditions.checkNotNull(defaultExecutionVertices);
        this.executionVertices = new HashMap<ExecutionVertexID, DefaultExecutionVertex>();
        for (DefaultExecutionVertex executionVertex : defaultExecutionVertices) {
            this.executionVertices.put(executionVertex.getId(), executionVertex);
        }
    }

    @Override
    public Iterable<DefaultExecutionVertex> getVertices() {
        return Collections.unmodifiableCollection(this.executionVertices.values());
    }

    @Override
    public DefaultExecutionVertex getVertex(ExecutionVertexID vertexId) {
        DefaultExecutionVertex executionVertex = this.executionVertices.get(vertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException(String.format("Execution vertex %s not found in pipelined region", vertexId));
        }
        return executionVertex;
    }

    @Override
    public Iterable<DefaultResultPartition> getConsumedResults() {
        if (this.consumedResults == null) {
            this.initializeConsumedResults();
        }
        return this.consumedResults;
    }

    private void initializeConsumedResults() {
        HashSet<DefaultResultPartition> consumedResults = new HashSet<DefaultResultPartition>();
        for (DefaultExecutionVertex executionVertex : this.executionVertices.values()) {
            for (DefaultResultPartition resultPartition : executionVertex.getConsumedResults()) {
                if (this.executionVertices.containsKey(resultPartition.getProducer().getId())) continue;
                consumedResults.add(resultPartition);
            }
        }
        this.consumedResults = Collections.unmodifiableSet(consumedResults);
    }
}

