/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.AbstractServerChannel;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelException;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelSink;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.DefaultServerSocketChannelConfig;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.ServerSocketChannel;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.ServerSocketChannelConfig;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.Boss;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioWorker;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.WorkerPool;
import org.apache.flink.shaded.akka.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.shaded.akka.org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioServerSocketChannel
extends AbstractServerChannel
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketChannel.class);
    final java.nio.channels.ServerSocketChannel socket;
    final Boss boss;
    final WorkerPool<NioWorker> workerPool;
    private final ServerSocketChannelConfig config;

    NioServerSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Boss boss, WorkerPool<NioWorker> workerPool) {
        super(factory, pipeline, sink);
        this.boss = boss;
        this.workerPool = workerPool;
        try {
            this.socket = java.nio.channels.ServerSocketChannel.open();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a server socket.", e);
        }
        try {
            this.socket.configureBlocking(false);
        }
        catch (IOException e) {
            block6: {
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn("Failed to close a partially initialized socket.", e2);
                }
            }
            throw new ChannelException("Failed to enter non-blocking mode.", e);
        }
        this.config = new DefaultServerSocketChannelConfig(this.socket.socket());
        Channels.fireChannelOpen(this);
    }

    @Override
    public ServerSocketChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && this.socket.socket().isBound();
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }
}

