/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAlterTableReset
extends SqlAlterTable {
    private final SqlNodeList propertyKeyList;

    public SqlAlterTableReset(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyKeyList) {
        super(pos, tableName, null);
        this.propertyKeyList = Objects.requireNonNull(propertyKeyList, "propertyKeyList should not be null");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableIdentifier, (Object)this.propertyKeyList);
    }

    public SqlNodeList getPropertyKeyList() {
        return this.propertyKeyList;
    }

    public Set<String> getResetKeys() {
        return this.propertyKeyList.getList().stream().map(key -> ((NlsString)SqlLiteral.value((SqlNode)key)).getValue()).collect(Collectors.toSet());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RESET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.propertyKeyList) {
            this.printIndent(writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }

    protected void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    @Override
    public String[] fullTableName() {
        return (String[])this.tableIdentifier.names.toArray((Object[])new String[0]);
    }
}

