/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.util.Preconditions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.InfoLogLevel;

public class RocksDBConfigurableOptions
implements Serializable {
    public static final ConfigOption<Integer> MAX_BACKGROUND_THREADS = ConfigOptions.key((String)"state.backend.rocksdb.thread.num").intType().defaultValue((Object)2).withDescription("The maximum number of concurrent background flush and compaction jobs (per stateful operator). The default value is '2'.");
    public static final ConfigOption<Integer> MAX_OPEN_FILES = ConfigOptions.key((String)"state.backend.rocksdb.files.open").intType().defaultValue((Object)-1).withDescription("The maximum number of open files (per stateful operator) that can be used by the DB, '-1' means no limit. The default value is '-1'.");
    public static final ConfigOption<MemorySize> LOG_MAX_FILE_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.log.max-file-size").memoryType().defaultValue((Object)MemorySize.parse((String)"25mb")).withDescription("The maximum size of RocksDB's file used for information logging. If the log files becomes larger than this, a new file will be created. If 0, all logs will be written to one log file. The default maximum file size is '25MB'. ");
    public static final ConfigOption<Integer> LOG_FILE_NUM = ConfigOptions.key((String)"state.backend.rocksdb.log.file-num").intType().defaultValue((Object)4).withDescription("The maximum number of files RocksDB should keep for information logging (Default setting: 4).");
    public static final ConfigOption<String> LOG_DIR = ConfigOptions.key((String)"state.backend.rocksdb.log.dir").stringType().noDefaultValue().withDescription("The directory for RocksDB's information logging files. If empty (Flink default setting), log files will be in the same directory as the Flink log. If non-empty, this directory will be used and the data directory's absolute path will be used as the prefix of the log file name.");
    public static final ConfigOption<InfoLogLevel> LOG_LEVEL = ConfigOptions.key((String)"state.backend.rocksdb.log.level").enumType(InfoLogLevel.class).defaultValue((Object)InfoLogLevel.INFO_LEVEL).withDescription(Description.builder().text("The specified information logging level for RocksDB. If unset, Flink will use %s.", new InlineElement[]{TextElement.code((String)InfoLogLevel.INFO_LEVEL.name())}).linebreak().text("Note: RocksDB info logs will not be written to the TaskManager logs and there is no rolling strategy, unless you configure %s, %s, and %s accordingly. Without a rolling strategy, long-running tasks may lead to uncontrolled disk space usage if configured with increased log levels!", new InlineElement[]{TextElement.code((String)LOG_DIR.key()), TextElement.code((String)LOG_MAX_FILE_SIZE.key()), TextElement.code((String)LOG_FILE_NUM.key())}).linebreak().text("There is no need to modify the RocksDB log level, unless for troubleshooting RocksDB.").build());
    public static final ConfigOption<CompactionStyle> COMPACTION_STYLE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.style").enumType(CompactionStyle.class).defaultValue((Object)CompactionStyle.LEVEL).withDescription(String.format("The specified compaction style for DB. Candidate compaction style is %s, %s, %s or %s, and Flink chooses '%s' as default style.", CompactionStyle.LEVEL.name(), CompactionStyle.FIFO.name(), CompactionStyle.UNIVERSAL.name(), CompactionStyle.NONE.name(), CompactionStyle.LEVEL.name()));
    public static final ConfigOption<Boolean> USE_DYNAMIC_LEVEL_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.level.use-dynamic-size").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If true, RocksDB will pick target size of each level dynamically. From an empty DB, ").text("RocksDB would make last level the base level, which means merging L0 data into the last level, ").text("until it exceeds max_bytes_for_level_base. And then repeat this process for second last level and so on. ").text("The default value is 'false'. ").text("For more information, please refer to %s", new InlineElement[]{LinkElement.link((String)"https://github.com/facebook/rocksdb/wiki/Leveled-Compaction#level_compaction_dynamic_level_bytes-is-true", (String)"RocksDB's doc.")}).build());
    public static final ConfigOption<MemorySize> TARGET_FILE_SIZE_BASE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.level.target-file-size-base").memoryType().defaultValue((Object)MemorySize.parse((String)"64mb")).withDescription("The target file size for compaction, which determines a level-1 file size. The default value is '64MB'.");
    public static final ConfigOption<MemorySize> MAX_SIZE_LEVEL_BASE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.level.max-size-level-base").memoryType().defaultValue((Object)MemorySize.parse((String)"256mb")).withDescription("The upper-bound of the total size of level base files in bytes. The default value is '256MB'.");
    public static final ConfigOption<MemorySize> WRITE_BUFFER_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.writebuffer.size").memoryType().defaultValue((Object)MemorySize.parse((String)"64mb")).withDescription("The amount of data built up in memory (backed by an unsorted log on disk) before converting to a sorted on-disk files. The default writebuffer size is '64MB'.");
    public static final ConfigOption<Integer> MAX_WRITE_BUFFER_NUMBER = ConfigOptions.key((String)"state.backend.rocksdb.writebuffer.count").intType().defaultValue((Object)2).withDescription("The maximum number of write buffers that are built up in memory. The default value is '2'.");
    public static final ConfigOption<Integer> MIN_WRITE_BUFFER_NUMBER_TO_MERGE = ConfigOptions.key((String)"state.backend.rocksdb.writebuffer.number-to-merge").intType().defaultValue((Object)1).withDescription("The minimum number of write buffers that will be merged together before writing to storage. The default value is '1'.");
    public static final ConfigOption<MemorySize> BLOCK_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.block.blocksize").memoryType().defaultValue((Object)MemorySize.parse((String)"4kb")).withDescription("The approximate size (in bytes) of user data packed per block. The default blocksize is '4KB'.");
    public static final ConfigOption<MemorySize> METADATA_BLOCK_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.block.metadata-blocksize").memoryType().defaultValue((Object)MemorySize.parse((String)"4kb")).withDescription("Approximate size of partitioned metadata packed per block. Currently applied to indexes block when partitioned index/filters option is enabled. The default blocksize is '4KB'.");
    public static final ConfigOption<MemorySize> BLOCK_CACHE_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.block.cache-size").memoryType().defaultValue((Object)MemorySize.parse((String)"8mb")).withDescription("The amount of the cache for data blocks in RocksDB. The default block-cache size is '8MB'.");
    public static final ConfigOption<MemorySize> WRITE_BATCH_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.write-batch-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("The max size of the consumed memory for RocksDB batch write, will flush just based on item count if this config set to 0.");
    public static final ConfigOption<Boolean> USE_BLOOM_FILTER = ConfigOptions.key((String)"state.backend.rocksdb.use-bloom-filter").booleanType().defaultValue((Object)false).withDescription("If true, every newly created SST file will contain a Bloom filter. It is disabled by default.");
    public static final ConfigOption<Double> BLOOM_FILTER_BITS_PER_KEY = ConfigOptions.key((String)"state.backend.rocksdb.bloom-filter.bits-per-key").doubleType().defaultValue((Object)10.0).withDescription("Bits per key that bloom filter will use, this only take effect when bloom filter is used. The default value is 10.0.");
    public static final ConfigOption<Boolean> BLOOM_FILTER_BLOCK_BASED_MODE = ConfigOptions.key((String)"state.backend.rocksdb.bloom-filter.block-based-mode").booleanType().defaultValue((Object)false).withDescription("If true, RocksDB will use block-based filter instead of full filter, this only take effect when bloom filter is used. The default value is 'false'.");
    static final ConfigOption<?>[] CANDIDATE_CONFIGS = new ConfigOption[]{MAX_BACKGROUND_THREADS, MAX_OPEN_FILES, LOG_LEVEL, LOG_MAX_FILE_SIZE, LOG_FILE_NUM, LOG_DIR, COMPACTION_STYLE, USE_DYNAMIC_LEVEL_SIZE, TARGET_FILE_SIZE_BASE, MAX_SIZE_LEVEL_BASE, WRITE_BUFFER_SIZE, MAX_WRITE_BUFFER_NUMBER, MIN_WRITE_BUFFER_NUMBER_TO_MERGE, BLOCK_SIZE, METADATA_BLOCK_SIZE, BLOCK_CACHE_SIZE, USE_BLOOM_FILTER, BLOOM_FILTER_BITS_PER_KEY, BLOOM_FILTER_BLOCK_BASED_MODE};
    private static final Set<ConfigOption<?>> POSITIVE_INT_CONFIG_SET = new HashSet<ConfigOption>(Arrays.asList(MAX_BACKGROUND_THREADS, LOG_FILE_NUM, MAX_WRITE_BUFFER_NUMBER, MIN_WRITE_BUFFER_NUMBER_TO_MERGE));
    private static final Set<ConfigOption<?>> SIZE_CONFIG_SET = new HashSet<ConfigOption>(Arrays.asList(TARGET_FILE_SIZE_BASE, MAX_SIZE_LEVEL_BASE, WRITE_BUFFER_SIZE, BLOCK_SIZE, METADATA_BLOCK_SIZE, BLOCK_CACHE_SIZE));

    static void checkArgumentValid(ConfigOption<?> option, Object value) {
        String key = option.key();
        if (POSITIVE_INT_CONFIG_SET.contains(option)) {
            Preconditions.checkArgument(((Integer)value > 0 ? 1 : 0) != 0, (Object)("Configured value for key: " + key + " must be larger than 0."));
        } else if (SIZE_CONFIG_SET.contains(option)) {
            Preconditions.checkArgument((((MemorySize)value).getBytes() > 0L ? 1 : 0) != 0, (Object)("Configured size for key" + key + " must be larger than 0."));
        } else if (LOG_MAX_FILE_SIZE.equals(option)) {
            Preconditions.checkArgument((((MemorySize)value).getBytes() >= 0L ? 1 : 0) != 0, (Object)("Configured size for key " + key + " must be larger than or equal to 0."));
        } else if (LOG_DIR.equals(option)) {
            Preconditions.checkArgument((boolean)new File((String)value).isAbsolute(), (Object)("Configured path for key " + key + " is not absolute."));
        }
    }
}

