/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.contrib.streaming.state.RocksDBProperty;

public class RocksDBNativeMetricOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String METRICS_COLUMN_FAMILY_AS_VARIABLE_KEY = "state.backend.rocksdb.metrics.column-family-as-variable";
    public static final ConfigOption<Boolean> MONITOR_NUM_IMMUTABLE_MEM_TABLES = ConfigOptions.key((String)RocksDBProperty.NumImmutableMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of immutable memtables in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_MEM_TABLE_FLUSH_PENDING = ConfigOptions.key((String)RocksDBProperty.MemTableFlushPending.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of pending memtable flushes in RocksDB.");
    public static final ConfigOption<Boolean> TRACK_COMPACTION_PENDING = ConfigOptions.key((String)RocksDBProperty.CompactionPending.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Track pending compactions in RocksDB. Returns 1 if a compaction is pending, 0 otherwise.");
    public static final ConfigOption<Boolean> MONITOR_BACKGROUND_ERRORS = ConfigOptions.key((String)RocksDBProperty.BackgroundErrors.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of background errors in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_CUR_SIZE_ACTIVE_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.CurSizeActiveMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the approximate size of the active memtable in bytes.");
    public static final ConfigOption<Boolean> MONITOR_CUR_SIZE_ALL_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.CurSizeAllMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the approximate size of the active and unflushed immutable memtables in bytes.");
    public static final ConfigOption<Boolean> MONITOR_SIZE_ALL_MEM_TABLES = ConfigOptions.key((String)RocksDBProperty.SizeAllMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the approximate size of the active, unflushed immutable, and pinned immutable memtables in bytes.");
    public static final ConfigOption<Boolean> MONITOR_NUM_ENTRIES_ACTIVE_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.NumEntriesActiveMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of entries in the active memtable.");
    public static final ConfigOption<Boolean> MONITOR_NUM_ENTRIES_IMM_MEM_TABLES = ConfigOptions.key((String)RocksDBProperty.NumEntriesImmMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of entries in the unflushed immutable memtables.");
    public static final ConfigOption<Boolean> MONITOR_NUM_DELETES_ACTIVE_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.NumDeletesActiveMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of delete entries in the active memtable.");
    public static final ConfigOption<Boolean> MONITOR_NUM_DELETES_IMM_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.NumDeletesImmMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of delete entries in the unflushed immutable memtables.");
    public static final ConfigOption<Boolean> ESTIMATE_NUM_KEYS = ConfigOptions.key((String)RocksDBProperty.EstimateNumKeys.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimate the number of keys in RocksDB.");
    public static final ConfigOption<Boolean> ESTIMATE_TABLE_READERS_MEM = ConfigOptions.key((String)RocksDBProperty.EstimateTableReadersMem.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimate the memory used for reading SST tables, excluding memory used in block cache (e.g.,filter and index blocks) in bytes.");
    public static final ConfigOption<Boolean> MONITOR_NUM_SNAPSHOTS = ConfigOptions.key((String)RocksDBProperty.NumSnapshots.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of unreleased snapshots of the database.");
    public static final ConfigOption<Boolean> MONITOR_NUM_LIVE_VERSIONS = ConfigOptions.key((String)RocksDBProperty.NumLiveVersions.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor number of live versions. Version is an internal data structure. See RocksDB file version_set.h for details. More live versions often mean more SST files are held from being deleted, by iterators or unfinished compactions.");
    public static final ConfigOption<Boolean> ESTIMATE_LIVE_DATA_SIZE = ConfigOptions.key((String)RocksDBProperty.EstimateLiveDataSize.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimate of the amount of live data in bytes (usually smaller than sst files size due to space amplification).");
    public static final ConfigOption<Boolean> MONITOR_TOTAL_SST_FILES_SIZE = ConfigOptions.key((String)RocksDBProperty.TotalSstFilesSize.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total size (bytes) of all SST files of all versions.WARNING: may slow down online queries if there are too many files.");
    public static final ConfigOption<Boolean> MONITOR_LIVE_SST_FILES_SIZE = ConfigOptions.key((String)RocksDBProperty.LiveSstFilesSize.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total size (bytes) of all SST files belonging to the latest version.WARNING: may slow down online queries if there are too many files.");
    public static final ConfigOption<Boolean> ESTIMATE_PENDING_COMPACTION_BYTES = ConfigOptions.key((String)RocksDBProperty.EstimatePendingCompactionBytes.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimated total number of bytes compaction needs to rewrite to get all levels down to under target size. Not valid for other compactions than level-based.");
    public static final ConfigOption<Boolean> MONITOR_NUM_RUNNING_COMPACTIONS = ConfigOptions.key((String)RocksDBProperty.NumRunningCompactions.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of currently running compactions.");
    public static final ConfigOption<Boolean> MONITOR_NUM_RUNNING_FLUSHES = ConfigOptions.key((String)RocksDBProperty.NumRunningFlushes.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of currently running flushes.");
    public static final ConfigOption<Boolean> MONITOR_ACTUAL_DELAYED_WRITE_RATE = ConfigOptions.key((String)RocksDBProperty.ActualDelayedWriteRate.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the current actual delayed write rate. 0 means no delay.");
    public static final ConfigOption<Boolean> IS_WRITE_STOPPED = ConfigOptions.key((String)RocksDBProperty.IsWriteStopped.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Track whether write has been stopped in RocksDB. Returns 1 if write has been stopped, 0 otherwise.");
    public static final ConfigOption<Boolean> BLOCK_CACHE_CAPACITY = ConfigOptions.key((String)RocksDBProperty.BlockCacheCapacity.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor block cache capacity.");
    public static final ConfigOption<Boolean> BLOCK_CACHE_USAGE = ConfigOptions.key((String)RocksDBProperty.BlockCacheUsage.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the memory size for the entries residing in block cache.");
    public static final ConfigOption<Boolean> BLOCK_CACHE_PINNED_USAGE = ConfigOptions.key((String)RocksDBProperty.BlockCachePinnedUsage.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the memory size for the entries being pinned in block cache.");
    public static final ConfigOption<Boolean> COLUMN_FAMILY_AS_VARIABLE = ConfigOptions.key((String)"state.backend.rocksdb.metrics.column-family-as-variable").booleanType().defaultValue((Object)false).withDescription("Whether to expose the column family as a variable.");
    private final Set<String> properties;
    private boolean columnFamilyAsVariable = (Boolean)COLUMN_FAMILY_AS_VARIABLE.defaultValue();

    public static RocksDBNativeMetricOptions fromConfig(ReadableConfig config) {
        RocksDBNativeMetricOptions options = new RocksDBNativeMetricOptions();
        if (((Boolean)config.get(MONITOR_NUM_IMMUTABLE_MEM_TABLES)).booleanValue()) {
            options.enableNumImmutableMemTable();
        }
        if (((Boolean)config.get(MONITOR_MEM_TABLE_FLUSH_PENDING)).booleanValue()) {
            options.enableMemTableFlushPending();
        }
        if (((Boolean)config.get(TRACK_COMPACTION_PENDING)).booleanValue()) {
            options.enableCompactionPending();
        }
        if (((Boolean)config.get(MONITOR_BACKGROUND_ERRORS)).booleanValue()) {
            options.enableBackgroundErrors();
        }
        if (((Boolean)config.get(MONITOR_CUR_SIZE_ACTIVE_MEM_TABLE)).booleanValue()) {
            options.enableCurSizeActiveMemTable();
        }
        if (((Boolean)config.get(MONITOR_CUR_SIZE_ALL_MEM_TABLE)).booleanValue()) {
            options.enableCurSizeAllMemTables();
        }
        if (((Boolean)config.get(MONITOR_SIZE_ALL_MEM_TABLES)).booleanValue()) {
            options.enableSizeAllMemTables();
        }
        if (((Boolean)config.get(MONITOR_NUM_ENTRIES_ACTIVE_MEM_TABLE)).booleanValue()) {
            options.enableNumEntriesActiveMemTable();
        }
        if (((Boolean)config.get(MONITOR_NUM_ENTRIES_IMM_MEM_TABLES)).booleanValue()) {
            options.enableNumEntriesImmMemTables();
        }
        if (((Boolean)config.get(MONITOR_NUM_DELETES_ACTIVE_MEM_TABLE)).booleanValue()) {
            options.enableNumDeletesActiveMemTable();
        }
        if (((Boolean)config.get(MONITOR_NUM_DELETES_IMM_MEM_TABLE)).booleanValue()) {
            options.enableNumDeletesImmMemTables();
        }
        if (((Boolean)config.get(ESTIMATE_NUM_KEYS)).booleanValue()) {
            options.enableEstimateNumKeys();
        }
        if (((Boolean)config.get(ESTIMATE_TABLE_READERS_MEM)).booleanValue()) {
            options.enableEstimateTableReadersMem();
        }
        if (((Boolean)config.get(MONITOR_NUM_SNAPSHOTS)).booleanValue()) {
            options.enableNumSnapshots();
        }
        if (((Boolean)config.get(MONITOR_NUM_LIVE_VERSIONS)).booleanValue()) {
            options.enableNumLiveVersions();
        }
        if (((Boolean)config.get(ESTIMATE_LIVE_DATA_SIZE)).booleanValue()) {
            options.enableEstimateLiveDataSize();
        }
        if (((Boolean)config.get(MONITOR_TOTAL_SST_FILES_SIZE)).booleanValue()) {
            options.enableTotalSstFilesSize();
        }
        if (((Boolean)config.get(MONITOR_LIVE_SST_FILES_SIZE)).booleanValue()) {
            options.enableLiveSstFilesSize();
        }
        if (((Boolean)config.get(ESTIMATE_PENDING_COMPACTION_BYTES)).booleanValue()) {
            options.enableEstimatePendingCompactionBytes();
        }
        if (((Boolean)config.get(MONITOR_NUM_RUNNING_COMPACTIONS)).booleanValue()) {
            options.enableNumRunningCompactions();
        }
        if (((Boolean)config.get(MONITOR_NUM_RUNNING_FLUSHES)).booleanValue()) {
            options.enableNumRunningFlushes();
        }
        if (((Boolean)config.get(MONITOR_ACTUAL_DELAYED_WRITE_RATE)).booleanValue()) {
            options.enableActualDelayedWriteRate();
        }
        if (((Boolean)config.get(IS_WRITE_STOPPED)).booleanValue()) {
            options.enableIsWriteStopped();
        }
        if (((Boolean)config.get(BLOCK_CACHE_CAPACITY)).booleanValue()) {
            options.enableBlockCacheCapacity();
        }
        if (((Boolean)config.get(BLOCK_CACHE_USAGE)).booleanValue()) {
            options.enableBlockCacheUsage();
        }
        if (((Boolean)config.get(BLOCK_CACHE_PINNED_USAGE)).booleanValue()) {
            options.enableBlockCachePinnedUsage();
        }
        options.setColumnFamilyAsVariable((Boolean)config.get(COLUMN_FAMILY_AS_VARIABLE));
        return options;
    }

    public RocksDBNativeMetricOptions() {
        this.properties = new HashSet<String>();
    }

    public void enableNumImmutableMemTable() {
        this.properties.add(RocksDBProperty.NumImmutableMemTable.getRocksDBProperty());
    }

    public void enableMemTableFlushPending() {
        this.properties.add(RocksDBProperty.MemTableFlushPending.getRocksDBProperty());
    }

    public void enableCompactionPending() {
        this.properties.add(RocksDBProperty.CompactionPending.getRocksDBProperty());
    }

    public void enableBackgroundErrors() {
        this.properties.add(RocksDBProperty.BackgroundErrors.getRocksDBProperty());
    }

    public void enableCurSizeActiveMemTable() {
        this.properties.add(RocksDBProperty.CurSizeActiveMemTable.getRocksDBProperty());
    }

    public void enableCurSizeAllMemTables() {
        this.properties.add(RocksDBProperty.CurSizeAllMemTables.getRocksDBProperty());
    }

    public void enableSizeAllMemTables() {
        this.properties.add(RocksDBProperty.SizeAllMemTables.getRocksDBProperty());
    }

    public void enableNumEntriesActiveMemTable() {
        this.properties.add(RocksDBProperty.NumEntriesActiveMemTable.getRocksDBProperty());
    }

    public void enableNumEntriesImmMemTables() {
        this.properties.add(RocksDBProperty.NumEntriesImmMemTables.getRocksDBProperty());
    }

    public void enableNumDeletesActiveMemTable() {
        this.properties.add(RocksDBProperty.NumDeletesActiveMemTable.getRocksDBProperty());
    }

    public void enableNumDeletesImmMemTables() {
        this.properties.add(RocksDBProperty.NumDeletesImmMemTables.getRocksDBProperty());
    }

    public void enableEstimateNumKeys() {
        this.properties.add(RocksDBProperty.EstimateNumKeys.getRocksDBProperty());
    }

    public void enableEstimateTableReadersMem() {
        this.properties.add(RocksDBProperty.EstimateTableReadersMem.getRocksDBProperty());
    }

    public void enableNumSnapshots() {
        this.properties.add(RocksDBProperty.NumSnapshots.getRocksDBProperty());
    }

    public void enableNumLiveVersions() {
        this.properties.add(RocksDBProperty.NumLiveVersions.getRocksDBProperty());
    }

    public void enableEstimateLiveDataSize() {
        this.properties.add(RocksDBProperty.EstimateLiveDataSize.getRocksDBProperty());
    }

    public void enableTotalSstFilesSize() {
        this.properties.add(RocksDBProperty.TotalSstFilesSize.getRocksDBProperty());
    }

    public void enableLiveSstFilesSize() {
        this.properties.add(RocksDBProperty.LiveSstFilesSize.getRocksDBProperty());
    }

    public void enableEstimatePendingCompactionBytes() {
        this.properties.add(RocksDBProperty.EstimatePendingCompactionBytes.getRocksDBProperty());
    }

    public void enableNumRunningCompactions() {
        this.properties.add(RocksDBProperty.NumRunningCompactions.getRocksDBProperty());
    }

    public void enableNumRunningFlushes() {
        this.properties.add(RocksDBProperty.NumRunningFlushes.getRocksDBProperty());
    }

    public void enableActualDelayedWriteRate() {
        this.properties.add(RocksDBProperty.ActualDelayedWriteRate.getRocksDBProperty());
    }

    public void enableIsWriteStopped() {
        this.properties.add(RocksDBProperty.IsWriteStopped.getRocksDBProperty());
    }

    public void enableBlockCacheCapacity() {
        this.properties.add(RocksDBProperty.BlockCacheCapacity.getRocksDBProperty());
    }

    public void enableBlockCacheUsage() {
        this.properties.add(RocksDBProperty.BlockCacheUsage.getRocksDBProperty());
    }

    public void enableBlockCachePinnedUsage() {
        this.properties.add(RocksDBProperty.BlockCachePinnedUsage.getRocksDBProperty());
    }

    public void setColumnFamilyAsVariable(boolean columnFamilyAsVariable) {
        this.columnFamilyAsVariable = columnFamilyAsVariable;
    }

    public Collection<String> getProperties() {
        return Collections.unmodifiableCollection(this.properties);
    }

    public boolean isEnabled() {
        return !this.properties.isEmpty();
    }

    public boolean isColumnFamilyAsVariable() {
        return this.columnFamilyAsVariable;
    }
}

