/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.contrib.streaming.state.RocksDBCachingPriorityQueueSet;

public class TreeOrderedSetCache
implements RocksDBCachingPriorityQueueSet.OrderedByteArraySetCache {
    private final int maxSize;
    @Nonnull
    private final TreeSet<byte[]> treeSet;

    TreeOrderedSetCache(int maxSize) {
        this.maxSize = maxSize;
        this.treeSet = new TreeSet(LEXICOGRAPHIC_BYTE_COMPARATOR);
    }

    @Override
    public int size() {
        return this.treeSet.size();
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public boolean isEmpty() {
        return this.treeSet.isEmpty();
    }

    @Override
    public boolean isFull() {
        return this.treeSet.size() >= this.maxSize;
    }

    @Override
    public boolean add(@Nonnull byte[] toAdd) {
        return this.treeSet.add(toAdd);
    }

    @Override
    public boolean remove(@Nonnull byte[] toRemove) {
        return this.treeSet.remove(toRemove);
    }

    @Override
    @Nullable
    public byte[] peekFirst() {
        return !this.isEmpty() ? this.treeSet.first() : null;
    }

    @Override
    @Nullable
    public byte[] peekLast() {
        return !this.isEmpty() ? this.treeSet.last() : null;
    }

    @Override
    @Nullable
    public byte[] pollFirst() {
        return !this.isEmpty() ? this.treeSet.pollFirst() : null;
    }

    @Override
    @Nullable
    public byte[] pollLast() {
        return !this.isEmpty() ? this.treeSet.pollLast() : null;
    }

    @Override
    public void bulkLoadFromOrderedIterator(@Nonnull Iterator<byte[]> orderedIterator) {
        this.treeSet.clear();
        int i = this.maxSize;
        while (--i >= 0 && orderedIterator.hasNext()) {
            this.treeSet.add(orderedIterator.next());
        }
    }
}

