/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.RocksIteratorWrapper;
import org.apache.flink.contrib.streaming.state.iterator.RocksSingleStateIterator;
import org.apache.flink.contrib.streaming.state.iterator.SingleStateIterator;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.KeyValueStateIterator;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class RocksStatesPerKeyGroupMergeIterator
implements KeyValueStateIterator {
    private final CloseableRegistry closeableRegistry;
    private final PriorityQueue<SingleStateIterator> heap;
    private final int keyGroupPrefixByteCount;
    private boolean newKeyGroup;
    private boolean newKVState;
    private boolean valid;
    private SingleStateIterator currentSubIterator;
    private static final List<Comparator<SingleStateIterator>> COMPARATORS;

    public RocksStatesPerKeyGroupMergeIterator(CloseableRegistry closeableRegistry, List<Tuple2<RocksIteratorWrapper, Integer>> kvStateIterators, List<SingleStateIterator> heapPriorityQueueIterators, int keyGroupPrefixByteCount) throws IOException {
        Preconditions.checkNotNull((Object)closeableRegistry);
        Preconditions.checkNotNull(kvStateIterators);
        Preconditions.checkArgument((keyGroupPrefixByteCount >= 1 ? 1 : 0) != 0);
        this.closeableRegistry = closeableRegistry;
        this.keyGroupPrefixByteCount = keyGroupPrefixByteCount;
        if (kvStateIterators.size() > 0 || heapPriorityQueueIterators.size() > 0) {
            this.heap = this.buildIteratorHeap(kvStateIterators, heapPriorityQueueIterators);
            this.valid = !this.heap.isEmpty();
            this.currentSubIterator = this.heap.poll();
            kvStateIterators.clear();
        } else {
            this.heap = null;
            this.valid = false;
        }
        this.newKeyGroup = true;
        this.newKVState = true;
    }

    public void next() {
        this.newKeyGroup = false;
        this.newKVState = false;
        byte[] oldKey = this.currentSubIterator.key();
        this.currentSubIterator.next();
        if (this.currentSubIterator.isValid()) {
            if (this.isDifferentKeyGroup(oldKey, this.currentSubIterator.key())) {
                SingleStateIterator oldIterator = this.currentSubIterator;
                this.heap.offer(this.currentSubIterator);
                this.currentSubIterator = (SingleStateIterator)this.heap.remove();
                this.newKVState = this.currentSubIterator != oldIterator;
                this.detectNewKeyGroup(oldKey);
            }
        } else {
            if (this.closeableRegistry.unregisterCloseable((AutoCloseable)this.currentSubIterator)) {
                IOUtils.closeQuietly((AutoCloseable)this.currentSubIterator);
            }
            if (this.heap.isEmpty()) {
                this.currentSubIterator = null;
                this.valid = false;
            } else {
                this.currentSubIterator = (SingleStateIterator)this.heap.remove();
                this.newKVState = true;
                this.detectNewKeyGroup(oldKey);
            }
        }
    }

    private PriorityQueue<SingleStateIterator> buildIteratorHeap(List<Tuple2<RocksIteratorWrapper, Integer>> kvStateIterators, List<SingleStateIterator> heapPriorityQueueIterators) throws IOException {
        Comparator<SingleStateIterator> iteratorComparator = COMPARATORS.get(this.keyGroupPrefixByteCount - 1);
        PriorityQueue<SingleStateIterator> iteratorPriorityQueue = new PriorityQueue<SingleStateIterator>(kvStateIterators.size() + heapPriorityQueueIterators.size(), iteratorComparator);
        for (Tuple2<RocksIteratorWrapper, Integer> rocksIteratorWithKVStateId : kvStateIterators) {
            RocksIteratorWrapper rocksIterator = (RocksIteratorWrapper)rocksIteratorWithKVStateId.f0;
            rocksIterator.seekToFirst();
            if (rocksIterator.isValid()) {
                RocksSingleStateIterator wrappingIterator = new RocksSingleStateIterator(rocksIterator, (Integer)rocksIteratorWithKVStateId.f1);
                iteratorPriorityQueue.offer(wrappingIterator);
                this.closeableRegistry.registerCloseable((AutoCloseable)wrappingIterator);
                this.closeableRegistry.unregisterCloseable((AutoCloseable)rocksIterator);
                continue;
            }
            if (!this.closeableRegistry.unregisterCloseable((AutoCloseable)rocksIterator)) continue;
            IOUtils.closeQuietly((AutoCloseable)rocksIterator);
        }
        for (SingleStateIterator heapQueueIterator : heapPriorityQueueIterators) {
            if (heapQueueIterator.isValid()) {
                iteratorPriorityQueue.offer(heapQueueIterator);
                this.closeableRegistry.registerCloseable((AutoCloseable)heapQueueIterator);
                continue;
            }
            IOUtils.closeQuietly((AutoCloseable)heapQueueIterator);
        }
        return iteratorPriorityQueue;
    }

    private boolean isDifferentKeyGroup(byte[] a, byte[] b) {
        return 0 != RocksStatesPerKeyGroupMergeIterator.compareKeyGroupsForByteArrays(a, b, this.keyGroupPrefixByteCount);
    }

    private void detectNewKeyGroup(byte[] oldKey) {
        if (this.isDifferentKeyGroup(oldKey, this.currentSubIterator.key())) {
            this.newKeyGroup = true;
        }
    }

    public int keyGroup() {
        byte[] currentKey = this.currentSubIterator.key();
        int result = 0;
        for (int i = 0; i < this.keyGroupPrefixByteCount; ++i) {
            result <<= 8;
            result |= currentKey[i] & 0xFF;
        }
        return result;
    }

    public byte[] key() {
        return this.currentSubIterator.key();
    }

    public byte[] value() {
        return this.currentSubIterator.value();
    }

    public int kvStateId() {
        return this.currentSubIterator.getKvStateId();
    }

    public boolean isNewKeyValueState() {
        return this.newKVState;
    }

    public boolean isNewKeyGroup() {
        return this.newKeyGroup;
    }

    public boolean isValid() {
        return this.valid;
    }

    private static int compareKeyGroupsForByteArrays(byte[] a, byte[] b, int len) {
        for (int i = 0; i < len; ++i) {
            int diff = (a[i] & 0xFF) - (b[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.closeableRegistry);
        if (this.heap != null) {
            this.heap.clear();
        }
    }

    static {
        int maxBytes = 2;
        COMPARATORS = new ArrayList<Comparator<SingleStateIterator>>(maxBytes);
        for (int i = 0; i < maxBytes; ++i) {
            int currentBytes = i + 1;
            COMPARATORS.add((o1, o2) -> {
                int arrayCmpRes = RocksStatesPerKeyGroupMergeIterator.compareKeyGroupsForByteArrays(o1.key(), o2.key(), currentBytes);
                return arrayCmpRes == 0 ? o1.getKvStateId() - o2.getKvStateId() : arrayCmpRes;
            });
        }
    }
}

