/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.contrib.streaming.state.EmbeddedRocksDBStateBackend;
import org.apache.flink.contrib.streaming.state.LegacyEnumBridge;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBOptionsFactory;
import org.apache.flink.contrib.streaming.state.RocksDBResourceContainer;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractManagedMemoryStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RocksDBStateBackend
extends AbstractManagedMemoryStateBackend
implements CheckpointStorage,
ConfigurableStateBackend {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBStateBackend.class);
    private final EmbeddedRocksDBStateBackend rocksDBStateBackend;
    private final StateBackend checkpointStreamBackend;

    public RocksDBStateBackend(String checkpointDataUri) throws IOException {
        this(new Path(checkpointDataUri).toUri());
    }

    public RocksDBStateBackend(String checkpointDataUri, boolean enableIncrementalCheckpointing) throws IOException {
        this(new Path(checkpointDataUri).toUri(), enableIncrementalCheckpointing);
    }

    public RocksDBStateBackend(URI checkpointDataUri) throws IOException {
        this((AbstractStateBackend)new FsStateBackend(checkpointDataUri));
    }

    public RocksDBStateBackend(URI checkpointDataUri, boolean enableIncrementalCheckpointing) throws IOException {
        this((AbstractStateBackend)new FsStateBackend(checkpointDataUri), enableIncrementalCheckpointing);
    }

    public RocksDBStateBackend(StateBackend checkpointStreamBackend) {
        this(checkpointStreamBackend, TernaryBoolean.UNDEFINED);
    }

    public RocksDBStateBackend(StateBackend checkpointStreamBackend, TernaryBoolean enableIncrementalCheckpointing) {
        if (!(checkpointStreamBackend instanceof CheckpointStorage)) {
            throw new IllegalStateException("RocksDBStateBackend can only checkpointto state backends that also implement CheckpointStorage.");
        }
        this.checkpointStreamBackend = (StateBackend)Preconditions.checkNotNull((Object)checkpointStreamBackend);
        this.rocksDBStateBackend = new EmbeddedRocksDBStateBackend(enableIncrementalCheckpointing);
    }

    @Deprecated
    public RocksDBStateBackend(AbstractStateBackend checkpointStreamBackend) {
        this((StateBackend)checkpointStreamBackend, TernaryBoolean.UNDEFINED);
    }

    @Deprecated
    public RocksDBStateBackend(AbstractStateBackend checkpointStreamBackend, boolean enableIncrementalCheckpointing) {
        this((StateBackend)checkpointStreamBackend, TernaryBoolean.fromBoolean((boolean)enableIncrementalCheckpointing));
    }

    private RocksDBStateBackend(RocksDBStateBackend original, ReadableConfig config, ClassLoader classLoader) {
        StateBackend originalStreamBackend = original.checkpointStreamBackend;
        this.checkpointStreamBackend = originalStreamBackend instanceof ConfigurableStateBackend ? ((ConfigurableStateBackend)originalStreamBackend).configure(config, classLoader) : originalStreamBackend;
        this.rocksDBStateBackend = original.rocksDBStateBackend.configure(config, classLoader);
    }

    public RocksDBStateBackend configure(ReadableConfig config, ClassLoader classLoader) {
        return new RocksDBStateBackend(this, config, classLoader);
    }

    public StateBackend getCheckpointBackend() {
        return this.checkpointStreamBackend;
    }

    public boolean supportsNoClaimRestoreMode() {
        return true;
    }

    public boolean supportsSavepointFormat(SavepointFormatType formatType) {
        return true;
    }

    public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
        return ((CheckpointStorage)this.checkpointStreamBackend).resolveCheckpoint(pointer);
    }

    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
        return ((CheckpointStorage)this.checkpointStreamBackend).createCheckpointStorage(jobId);
    }

    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws IOException {
        return this.rocksDBStateBackend.createKeyedStateBackend(env, jobID, operatorIdentifier, keySerializer, numberOfKeyGroups, keyGroupRange, kvStateRegistry, ttlTimeProvider, metricGroup, stateHandles, cancelStreamRegistry);
    }

    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry, double managedMemoryFraction) throws IOException {
        return this.rocksDBStateBackend.createKeyedStateBackend(env, jobID, operatorIdentifier, keySerializer, numberOfKeyGroups, keyGroupRange, kvStateRegistry, ttlTimeProvider, metricGroup, stateHandles, cancelStreamRegistry, managedMemoryFraction);
    }

    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
        return this.rocksDBStateBackend.createOperatorStateBackend(env, operatorIdentifier, stateHandles, cancelStreamRegistry);
    }

    public void setDbStoragePath(String path) {
        String[] stringArray;
        if (path == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        this.setDbStoragePaths(stringArray);
    }

    public void setDbStoragePaths(String ... paths) {
        this.rocksDBStateBackend.setDbStoragePaths(paths);
    }

    public String[] getDbStoragePaths() {
        return this.rocksDBStateBackend.getDbStoragePaths();
    }

    public boolean isIncrementalCheckpointsEnabled() {
        return this.rocksDBStateBackend.isIncrementalCheckpointsEnabled();
    }

    public PriorityQueueStateType getPriorityQueueStateType() {
        return LegacyEnumBridge.convert(this.rocksDBStateBackend.getPriorityQueueStateType());
    }

    public void setPriorityQueueStateType(PriorityQueueStateType priorityQueueStateType) {
        this.rocksDBStateBackend.setPriorityQueueStateType(LegacyEnumBridge.convert(priorityQueueStateType));
    }

    public void setPredefinedOptions(@Nonnull PredefinedOptions options) {
        this.rocksDBStateBackend.setPredefinedOptions(options);
    }

    @VisibleForTesting
    public PredefinedOptions getPredefinedOptions() {
        return this.rocksDBStateBackend.getPredefinedOptions();
    }

    @VisibleForTesting
    EmbeddedRocksDBStateBackend getEmbeddedRocksDBStateBackend() {
        return this.rocksDBStateBackend;
    }

    public void setRocksDBOptions(RocksDBOptionsFactory optionsFactory) {
        this.rocksDBStateBackend.setRocksDBOptions(optionsFactory);
    }

    @Nullable
    public RocksDBOptionsFactory getRocksDBOptions() {
        return this.rocksDBStateBackend.getRocksDBOptions();
    }

    public int getNumberOfTransferThreads() {
        return this.rocksDBStateBackend.getNumberOfTransferThreads();
    }

    public void setNumberOfTransferThreads(int numberOfTransferThreads) {
        this.rocksDBStateBackend.setNumberOfTransferThreads(numberOfTransferThreads);
    }

    @Deprecated
    public int getNumberOfTransferingThreads() {
        return this.getNumberOfTransferThreads();
    }

    @Deprecated
    public void setNumberOfTransferingThreads(int numberOfTransferingThreads) {
        this.setNumberOfTransferThreads(numberOfTransferingThreads);
    }

    public long getWriteBatchSize() {
        return this.rocksDBStateBackend.getWriteBatchSize();
    }

    public void setWriteBatchSize(long writeBatchSize) {
        this.rocksDBStateBackend.setWriteBatchSize(writeBatchSize);
    }

    @VisibleForTesting
    RocksDBResourceContainer createOptionsAndResourceContainer() {
        return this.rocksDBStateBackend.createOptionsAndResourceContainer();
    }

    public String toString() {
        return "RocksDBStateBackend{checkpointStreamBackend=" + this.checkpointStreamBackend + ", localRocksDbDirectories=" + Arrays.toString(this.rocksDBStateBackend.getDbStoragePaths()) + ", enableIncrementalCheckpointing=" + this.rocksDBStateBackend.isIncrementalCheckpointsEnabled() + ", numberOfTransferThreads=" + this.rocksDBStateBackend.getNumberOfTransferThreads() + ", writeBatchSize=" + this.rocksDBStateBackend.getWriteBatchSize() + '}';
    }

    @VisibleForTesting
    static void ensureRocksDBIsLoaded(String tempDirectory) throws IOException {
        EmbeddedRocksDBStateBackend.ensureRocksDBIsLoaded(tempDirectory);
    }

    @VisibleForTesting
    static void resetRocksDBLoadedFlag() throws Exception {
        EmbeddedRocksDBStateBackend.resetRocksDBLoadedFlag();
    }

    @Deprecated
    public static enum PriorityQueueStateType {
        HEAP,
        ROCKSDB;

    }
}

