/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.RocksIteratorWrapper;
import org.apache.flink.contrib.streaming.state.iterator.AbstractRocksStateKeysIterator;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.util.FlinkRuntimeException;

public class RocksStateKeysAndNamespaceIterator<K, N>
extends AbstractRocksStateKeysIterator<K>
implements Iterator<Tuple2<K, N>> {
    @Nonnull
    private final TypeSerializer<N> namespaceSerializer;
    private Tuple2<K, N> nextKey;

    public RocksStateKeysAndNamespaceIterator(@Nonnull RocksIteratorWrapper iterator, @Nonnull String state, @Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer, int keyGroupPrefixBytes, boolean ambiguousKeyPossible) {
        super(iterator, state, keySerializer, keyGroupPrefixBytes, ambiguousKeyPossible);
        this.namespaceSerializer = namespaceSerializer;
        this.nextKey = null;
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.nextKey == null && this.iterator.isValid()) {
                byte[] keyBytes = this.iterator.key();
                Object currentKey = this.deserializeKey(keyBytes, this.byteArrayDataInputView);
                Object currentNamespace = CompositeKeySerializationUtils.readNamespace(this.namespaceSerializer, (DataInputDeserializer)this.byteArrayDataInputView, (boolean)this.ambiguousKeyPossible);
                this.nextKey = Tuple2.of(currentKey, (Object)currentNamespace);
                this.iterator.next();
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to access state [" + this.state + "]", (Throwable)e);
        }
        return this.nextKey != null;
    }

    @Override
    public Tuple2<K, N> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Failed to access state [" + this.state + "]");
        }
        Tuple2<K, N> tmpKey = this.nextKey;
        this.nextKey = null;
        return tmpKey;
    }
}

