/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.HierarchyDescriptorValidator;

@Internal
public class LiteralValueValidator
extends HierarchyDescriptorValidator {
    public static final String TYPE = "type";
    public static final String VALUE = "value";

    public static Object getValue(String keyPrefix, DescriptorProperties properties) {
        String typeKey = keyPrefix + TYPE;
        if (properties.containsKey(typeKey)) {
            String valueKey = keyPrefix + VALUE;
            TypeInformation<?> typeInfo = properties.getType(typeKey);
            if (typeInfo.equals((Object)Types.BIG_DEC)) {
                return properties.getBigDecimal(valueKey);
            }
            if (typeInfo.equals((Object)Types.BOOLEAN)) {
                return properties.getBoolean(valueKey);
            }
            if (typeInfo.equals((Object)Types.BYTE)) {
                return properties.getByte(valueKey);
            }
            if (typeInfo.equals((Object)Types.DOUBLE)) {
                return properties.getDouble(valueKey);
            }
            if (typeInfo.equals((Object)Types.FLOAT)) {
                return Float.valueOf(properties.getFloat(valueKey));
            }
            if (typeInfo.equals((Object)Types.INT)) {
                return properties.getInt(valueKey);
            }
            if (typeInfo.equals((Object)Types.LONG)) {
                return properties.getLong(valueKey);
            }
            if (typeInfo.equals((Object)Types.SHORT)) {
                return properties.getShort(valueKey);
            }
            if (typeInfo.equals((Object)Types.STRING)) {
                return properties.getString(valueKey);
            }
            throw new TableException("Unsupported type '" + typeInfo.getTypeClass() + "'.");
        }
        return LiteralValueValidator.deriveTypeStringFromValueString(properties.getString(keyPrefix.substring(0, keyPrefix.length() - 1)));
    }

    private static Object deriveTypeStringFromValueString(String valueString) {
        if (valueString.equals("true") || valueString.equals("false")) {
            return Boolean.valueOf(valueString);
        }
        try {
            return Integer.valueOf(valueString);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.valueOf(valueString);
            }
            catch (NumberFormatException e2) {
                return valueString;
            }
        }
    }

    public LiteralValueValidator(String keyPrefix) {
        super(keyPrefix);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateWithPrefix(String keyPrefix, DescriptorProperties properties) {
        String typeKey = keyPrefix + TYPE;
        properties.validateType(typeKey, true, false);
        if (properties.containsKey(typeKey)) {
            String valueKey = keyPrefix + VALUE;
            TypeInformation<?> typeInfo = properties.getType(typeKey);
            if (typeInfo.equals((Object)Types.BIG_DEC)) {
                properties.validateBigDecimal(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.BOOLEAN)) {
                properties.validateBoolean(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.BYTE)) {
                properties.validateByte(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.DOUBLE)) {
                properties.validateDouble(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.FLOAT)) {
                properties.validateFloat(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.INT)) {
                properties.validateInt(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.LONG)) {
                properties.validateLong(valueKey, false);
                return;
            } else if (typeInfo.equals((Object)Types.SHORT)) {
                properties.validateShort(valueKey, false);
                return;
            } else {
                if (!typeInfo.equals((Object)Types.STRING)) throw new TableException("Unsupported type '" + typeInfo + "'.");
                properties.validateString(valueKey, false);
            }
            return;
        } else {
            if (keyPrefix.equals("")) {
                throw new ValidationException("Literal values with implicit type must not exist in the top level of a hierarchy.");
            }
            properties.validateString(keyPrefix.substring(0, keyPrefix.length() - 1), false);
        }
    }
}

