/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorBase;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class TableDescriptor<D extends TableDescriptor<D>>
extends DescriptorBase {
    private final ConnectorDescriptor connectorDescriptor;
    @Nullable
    private FormatDescriptor formatDescriptor;
    @Nullable
    private String updateMode;

    protected TableDescriptor(ConnectorDescriptor connectorDescriptor) {
        this.connectorDescriptor = (ConnectorDescriptor)Preconditions.checkNotNull((Object)connectorDescriptor, (String)"Connector must not be null.");
    }

    public D withFormat(FormatDescriptor format) {
        this.formatDescriptor = (FormatDescriptor)Preconditions.checkNotNull((Object)format, (String)"Format must not be null.");
        return (D)this;
    }

    public D inAppendMode() {
        this.updateMode = "append";
        return (D)this;
    }

    public D inRetractMode() {
        this.updateMode = "retract";
        return (D)this;
    }

    public D inUpsertMode() {
        this.updateMode = "upsert";
        return (D)this;
    }

    @Override
    public final Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        if (this.connectorDescriptor.isFormatNeeded() && this.formatDescriptor == null) {
            throw new ValidationException(String.format("The connector %s requires a format description.", this.connectorDescriptor.getClass().getName()));
        }
        if (!this.connectorDescriptor.isFormatNeeded() && this.formatDescriptor != null) {
            throw new ValidationException(String.format("The connector %s does not require a format description but %s found.", this.connectorDescriptor.getClass().getName(), this.formatDescriptor.getClass().getName()));
        }
        properties.putProperties(this.connectorDescriptor.toProperties());
        if (this.formatDescriptor != null) {
            properties.putProperties(this.formatDescriptor.toProperties());
        }
        if (this.updateMode != null) {
            properties.putString("update-mode", this.updateMode);
        }
        properties.putProperties(this.additionalProperties());
        return properties.asMap();
    }

    protected Map<String, String> additionalProperties() {
        return Collections.emptyMap();
    }
}

