/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class VarCharType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final int EMPTY_LITERAL_LENGTH = 0;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    private static final String FORMAT = "VARCHAR(%d)";
    private static final String MAX_FORMAT = "STRING";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = VarCharType.conversionSet(String.class.getName(), byte[].class.getName(), StringData.class.getName());
    private static final Class<?> DEFAULT_CONVERSION = String.class;
    private final int length;

    public VarCharType(boolean isNullable, int length) {
        super(isNullable, LogicalTypeRoot.VARCHAR);
        if (length < 1) {
            throw new ValidationException(String.format("Variable character string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public VarCharType(int length) {
        this(true, length);
    }

    public VarCharType() {
        this(1);
    }

    private VarCharType(int length, boolean isNullable) {
        super(isNullable, LogicalTypeRoot.VARCHAR);
        this.length = length;
    }

    public static VarCharType ofEmptyLiteral() {
        return new VarCharType(0, false);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new VarCharType(this.length, isNullable);
    }

    @Override
    public String asSerializableString() {
        if (this.length == 0) {
            throw new TableException("Zero-length character strings have no serializable string representation.");
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public String asSummaryString() {
        if (this.length == Integer.MAX_VALUE) {
            return this.withNullability(MAX_FORMAT, new Object[0]);
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VarCharType that = (VarCharType)o;
        return this.length == that.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }
}

