/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CodecPool {
    private static final Logger LOG = LoggerFactory.getLogger(CodecPool.class);
    private static final Map<Class<Compressor>, Set<Compressor>> compressorPool = new HashMap<Class<Compressor>, Set<Compressor>>();
    private static final Map<Class<Decompressor>, Set<Decompressor>> decompressorPool = new HashMap<Class<Decompressor>, Set<Decompressor>>();
    private static final LoadingCache<Class<Compressor>, AtomicInteger> compressorCounts = CodecPool.createCache(Compressor.class);
    private static final LoadingCache<Class<Decompressor>, AtomicInteger> decompressorCounts = CodecPool.createCache(Decompressor.class);

    private static <T> LoadingCache<Class<T>, AtomicInteger> createCache(Class<T> klass) {
        return CacheBuilder.newBuilder().build(new CacheLoader<Class<T>, AtomicInteger>(){

            public AtomicInteger load(Class<T> key) throws Exception {
                return new AtomicInteger();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T borrow(Map<Class<T>, Set<T>> pool, Class<? extends T> codecClass) {
        Set<T> codecSet;
        T codec = null;
        Object object = pool;
        synchronized (object) {
            codecSet = pool.get(codecClass);
        }
        if (codecSet != null) {
            object = codecSet;
            synchronized (object) {
                if (!codecSet.isEmpty()) {
                    codec = codecSet.iterator().next();
                    codecSet.remove(codec);
                }
            }
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean payback(Map<Class<T>, Set<T>> pool, T codec) {
        if (codec != null) {
            Set<T> codecSet;
            Class<T> codecClass = ReflectionUtils.getClass(codec);
            Object object = pool;
            synchronized (object) {
                codecSet = pool.get(codecClass);
                if (codecSet == null) {
                    codecSet = new HashSet<T>();
                    pool.put(codecClass, codecSet);
                }
            }
            object = codecSet;
            synchronized (object) {
                return codecSet.add(codec);
            }
        }
        return false;
    }

    private static <T> int getLeaseCount(LoadingCache<Class<T>, AtomicInteger> usageCounts, Class<? extends T> codecClass) {
        return ((AtomicInteger)usageCounts.getUnchecked(codecClass)).get();
    }

    private static <T> void updateLeaseCount(LoadingCache<Class<T>, AtomicInteger> usageCounts, T codec, int delta) {
        if (codec != null) {
            Class<T> codecClass = ReflectionUtils.getClass(codec);
            ((AtomicInteger)usageCounts.getUnchecked(codecClass)).addAndGet(delta);
        }
    }

    public static Compressor getCompressor(CompressionCodec codec, Configuration conf) {
        Compressor compressor = CodecPool.borrow(compressorPool, codec.getCompressorType());
        if (compressor == null) {
            compressor = codec.createCompressor();
            LOG.info("Got brand-new compressor [" + codec.getDefaultExtension() + "]");
        } else {
            compressor.reinit(conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got recycled compressor");
            }
        }
        if (compressor != null && !compressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            CodecPool.updateLeaseCount(compressorCounts, compressor, 1);
        }
        return compressor;
    }

    public static Compressor getCompressor(CompressionCodec codec) {
        return CodecPool.getCompressor(codec, null);
    }

    public static Decompressor getDecompressor(CompressionCodec codec) {
        Decompressor decompressor = CodecPool.borrow(decompressorPool, codec.getDecompressorType());
        if (decompressor == null) {
            decompressor = codec.createDecompressor();
            LOG.info("Got brand-new decompressor [" + codec.getDefaultExtension() + "]");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Got recycled decompressor");
        }
        if (decompressor != null && !decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            CodecPool.updateLeaseCount(decompressorCounts, decompressor, 1);
        }
        return decompressor;
    }

    public static void returnCompressor(Compressor compressor) {
        if (compressor == null) {
            return;
        }
        if (compressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        compressor.reset();
        if (CodecPool.payback(compressorPool, compressor)) {
            CodecPool.updateLeaseCount(compressorCounts, compressor, -1);
        }
    }

    public static void returnDecompressor(Decompressor decompressor) {
        if (decompressor == null) {
            return;
        }
        if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        decompressor.reset();
        if (CodecPool.payback(decompressorPool, decompressor)) {
            CodecPool.updateLeaseCount(decompressorCounts, decompressor, -1);
        }
    }

    public static int getLeasedCompressorsCount(CompressionCodec codec) {
        return codec == null ? 0 : CodecPool.getLeaseCount(compressorCounts, codec.getCompressorType());
    }

    public static int getLeasedDecompressorsCount(CompressionCodec codec) {
        return codec == null ? 0 : CodecPool.getLeaseCount(decompressorCounts, codec.getDecompressorType());
    }
}

