/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.Cluster;
import org.junit.Assert;
import org.junit.Test;

public class TestClientProtocolProviderImpls {
    @Test
    public void testClusterWithLocalClientProvider() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "local");
        Cluster cluster = new Cluster(conf);
        Assert.assertTrue((boolean)(cluster.getClient() instanceof LocalJobRunner));
        cluster.close();
    }

    @Test
    public void testClusterWithJTClientProvider() throws Exception {
        Configuration conf = new Configuration();
        try {
            conf.set("mapreduce.framework.name", "classic");
            conf.set("mapreduce.jobtracker.address", "local");
            new Cluster(conf);
            Assert.fail((String)"Cluster with classic Framework name should not use local JT address");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot initialize Cluster. Please check"));
        }
    }

    @Test
    public void testClusterWithYarnClientProvider() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "yarn");
        Cluster cluster = new Cluster(conf);
        Assert.assertTrue((boolean)(cluster.getClient() instanceof YARNRunner));
        cluster.close();
    }

    @Test
    public void testClusterException() {
        Configuration conf = new Configuration();
        try {
            conf.set("mapreduce.framework.name", "incorrect");
            new Cluster(conf);
            Assert.fail((String)"Cluster should not be initialized with incorrect framework name");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot initialize Cluster. Please check"));
        }
    }
}

