/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;

public class TestNLineInputFormat
extends TestCase {
    private static int MAX_LENGTH = 200;
    private static Configuration conf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        Job job = Job.getInstance((Configuration)conf);
        Path file = new Path(workDir, "test.txt");
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        int numLinesPerMap = 5;
        NLineInputFormat.setNumLinesPerSplit((Job)job, (int)numLinesPerMap);
        for (int length = 0; length < MAX_LENGTH; ++length) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i) + " some more text");
                    writer.write("\n");
                }
            }
            int lastN = 0;
            if (length != 0 && (lastN = length % 5) == 0) {
                lastN = 5;
            }
            this.checkFormat(job, numLinesPerMap, lastN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkFormat(Job job, int expectedN, int lastN) throws IOException, InterruptedException {
        NLineInputFormat format = new NLineInputFormat();
        List splits = format.getSplits((JobContext)job);
        int count = 0;
        for (int i = 0; i < splits.size(); ++i) {
            TestNLineInputFormat.assertEquals((String)"There are no split locations", (int)0, (int)((InputSplit)splits.get(i)).getLocations().length);
            TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
            RecordReader reader = format.createRecordReader((InputSplit)splits.get(i), context);
            Class<?> clazz = reader.getClass();
            TestNLineInputFormat.assertEquals((String)"reader class is LineRecordReader.", LineRecordReader.class, clazz);
            MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)splits.get(i));
            reader.initialize((InputSplit)splits.get(i), (TaskAttemptContext)mcontext);
            try {
                count = 0;
                while (reader.nextKeyValue()) {
                    ++count;
                }
            }
            finally {
                reader.close();
            }
            if (i == splits.size() - 1) {
                TestNLineInputFormat.assertEquals((String)("number of lines in split(" + i + ") is wrong"), (int)lastN, (int)count);
                continue;
            }
            TestNLineInputFormat.assertEquals((String)("number of lines in split(" + i + ") is wrong"), (int)expectedN, (int)count);
        }
    }

    public static void main(String[] args) throws Exception {
        new TestNLineInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestNLineInputFormat");
    }
}

