/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.EntityWriterV2;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.SimpleEntityWriterConstants;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TimelineServicePerformance;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorManager;

class SimpleEntityWriterV2
extends EntityWriterV2
implements SimpleEntityWriterConstants {
    private static final Log LOG = LogFactory.getLog(SimpleEntityWriterV2.class);

    SimpleEntityWriterV2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeEntities(Configuration tlConf, TimelineCollectorManager manager, Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        int taskId = context.getTaskAttemptID().getTaskID().getId();
        long timestamp = conf.getLong("timeline.server.performance.run.id", 0L);
        ApplicationId appId = ApplicationId.newInstance((long)timestamp, (int)taskId);
        AppLevelTimelineCollector collector = new AppLevelTimelineCollector(appId);
        manager.putIfAbsent(appId, (TimelineCollector)collector);
        try {
            TimelineCollectorContext tlContext = collector.getTimelineEntityContext();
            tlContext.setFlowName(context.getJobName());
            tlContext.setFlowRunId(timestamp);
            tlContext.setUserId(context.getUser());
            int kbs = conf.getInt("kbs sent", 1);
            long totalTime = 0L;
            int testtimes = conf.getInt("testtimes", 100);
            Random rand = new Random();
            TaskAttemptID taskAttemptId = context.getTaskAttemptID();
            char[] payLoad = new char[kbs * 1024];
            for (int i = 0; i < testtimes; ++i) {
                for (int xx = 0; xx < kbs * 1024; ++xx) {
                    int alphaNumIdx = rand.nextInt(ALPHA_NUMS.length);
                    payLoad[xx] = ALPHA_NUMS[alphaNumIdx];
                }
                String entId = taskAttemptId + "_" + Integer.toString(i);
                TimelineEntity entity = new TimelineEntity();
                entity.setId(entId);
                entity.setType("FOO_ATTEMPT");
                entity.addInfo("PERF_TEST", (Object)payLoad);
                TimelineEvent event = new TimelineEvent();
                event.setId("foo_event_id");
                event.setTimestamp(System.currentTimeMillis());
                event.addInfo("foo_event", (Object)"test");
                entity.addEvent(event);
                TimelineMetric metric = new TimelineMetric();
                metric.setId("foo_metric");
                metric.addValue(System.currentTimeMillis(), (Number)123456789L);
                entity.addMetric(metric);
                entity.addConfig("foo", "bar");
                TimelineEntities entities = new TimelineEntities();
                entities.addEntity(entity);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                long startWrite = System.nanoTime();
                try {
                    collector.putEntities(entities, ugi);
                }
                catch (Exception e) {
                    context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_FAILURES).increment(1L);
                    LOG.error((Object)"writing to the timeline service failed", (Throwable)e);
                }
                long endWrite = System.nanoTime();
                totalTime += TimeUnit.NANOSECONDS.toMillis(endWrite - startWrite);
            }
            LOG.info((Object)("wrote " + testtimes + " entities (" + kbs * testtimes + " kB) in " + totalTime + " ms"));
            context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_TIME).increment(totalTime);
            context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_COUNTER).increment((long)testtimes);
            context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_KBS).increment((long)(kbs * testtimes));
        }
        finally {
            manager.remove(appId);
        }
    }
}

