/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.CombineSequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestCombineSequenceFileInputFormat {
    private static final Log LOG = LogFactory.getLog(TestCombineSequenceFileInputFormat.class);
    private static Configuration conf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFormat() throws IOException, InterruptedException {
        Job job = Job.getInstance((Configuration)conf);
        Random random = new Random();
        long seed = random.nextLong();
        random.setSeed(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        int length = 10000;
        int numFiles = 10;
        TestCombineSequenceFileInputFormat.createFiles(10000, 10, random, job);
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
        CombineSequenceFileInputFormat format = new CombineSequenceFileInputFormat();
        for (int i = 0; i < 3; ++i) {
            int numSplits = random.nextInt(1) + 1;
            LOG.info((Object)("splitting: requesting = " + numSplits));
            List splits = format.getSplits((JobContext)job);
            LOG.info((Object)("splitting: got =        " + splits.size()));
            Assert.assertEquals((String)"We got more than one splits!", (long)1L, (long)splits.size());
            InputSplit split = (InputSplit)splits.get(0);
            Assert.assertEquals((String)"It should be CombineFileSplit", CombineFileSplit.class, split.getClass());
            BitSet bits = new BitSet(10000);
            RecordReader reader = format.createRecordReader(split, context);
            MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
            reader.initialize(split, (TaskAttemptContext)mcontext);
            Assert.assertEquals((String)"reader class is CombineFileRecordReader.", CombineFileRecordReader.class, reader.getClass());
            try {
                while (reader.nextKeyValue()) {
                    IntWritable key = (IntWritable)reader.getCurrentKey();
                    BytesWritable value = (BytesWritable)reader.getCurrentValue();
                    Assert.assertNotNull((String)"Value should not be null.", (Object)value);
                    int k = key.get();
                    LOG.debug((Object)("read " + k));
                    Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(k));
                    bits.set(k);
                }
            }
            finally {
                reader.close();
            }
            Assert.assertEquals((String)"Some keys in no partition.", (long)10000L, (long)bits.cardinality());
        }
    }

    private static Range[] createRanges(int length, int numFiles, Random random) {
        Range[] ranges = new Range[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            int start = i == 0 ? 0 : ranges[i - 1].end;
            int end = i == numFiles - 1 ? length : length / numFiles * (2 * i + 1) / 2 + random.nextInt(length / numFiles) + 1;
            ranges[i] = new Range(start, end);
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFiles(int length, int numFiles, Random random, Job job) throws IOException {
        Range[] ranges = TestCombineSequenceFileInputFormat.createRanges(length, numFiles, random);
        for (int i = 0; i < numFiles; ++i) {
            Path file = new Path(workDir, "test_" + i + ".seq");
            Range range = ranges[i];
            try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)localFs, (Configuration)job.getConfiguration(), (Path)file, IntWritable.class, BytesWritable.class);){
                for (int j = range.start; j < range.end; ++j) {
                    IntWritable key = new IntWritable(j);
                    byte[] data = new byte[random.nextInt(10)];
                    random.nextBytes(data);
                    BytesWritable value = new BytesWritable(data);
                    writer.append((Writable)key, (Writable)value);
                }
                continue;
            }
        }
    }

    static {
        try {
            conf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestCombineSequenceFileInputFormat");
    }

    private static class Range {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

