/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.apache.hadoop.yarn.webapp.view.TestInfoBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInfoBlock {
    public static StringWriter sw;
    public static PrintWriter pw;
    static final String JAVASCRIPT = "<script>alert('text')</script>";
    static final String JAVASCRIPT_ESCAPED = "&lt;script&gt;alert('text')&lt;/script&gt;";

    @Before
    public void setup() {
        sw = new StringWriter();
        pw = new PrintWriter(sw);
    }

    @Test(timeout=60000L)
    public void testMultilineInfoBlock() throws Exception {
        WebAppTests.testBlock(MultilineInfoBlock.class);
        pw.flush();
        String output = sw.toString().replaceAll(" +", " ");
        String expectedSinglelineData = String.format("<tr class=\"odd\">%n <th>%n Single_line_value%n <td>%n This is one line.%n", new Object[0]);
        String expectedMultilineData = String.format("<tr class=\"even\">%n <th>%n Multiple_line_value%n <td>%n <div>%n This is first line.%n </div>%n <div>%n This is second line.%n </div>%n", new Object[0]);
        Assert.assertTrue((output.contains(expectedSinglelineData) && output.contains(expectedMultilineData) ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testJavaScriptInfoBlock() throws Exception {
        WebAppTests.testBlock(JavaScriptInfoBlock.class);
        pw.flush();
        String output = sw.toString();
        Assert.assertFalse((boolean)output.contains("<script>"));
        Assert.assertTrue((boolean)output.contains(JAVASCRIPT_ESCAPED));
    }
}

