/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.hive.PartitionValueExtractor;

public class SlashEncodedDayPartitionValueExtractor
implements PartitionValueExtractor {
    private static final long serialVersionUID = 1L;
    private transient DateTimeFormatter dtfOut = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private DateTimeFormatter getDtfOut() {
        if (this.dtfOut == null) {
            this.dtfOut = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        }
        return this.dtfOut;
    }

    @Override
    public List<String> extractPartitionValuesInPath(String partitionPath) {
        String[] splits = partitionPath.split("/");
        if (splits.length != 3) {
            throw new IllegalArgumentException("Partition path " + partitionPath + " is not in the form yyyy/mm/dd ");
        }
        int year = Integer.parseInt(splits[0].contains("=") ? splits[0].split("=")[1] : splits[0]);
        int mm = Integer.parseInt(splits[1].contains("=") ? splits[1].split("=")[1] : splits[1]);
        int dd = Integer.parseInt(splits[2].contains("=") ? splits[2].split("=")[1] : splits[2]);
        ZonedDateTime dateTime = ZonedDateTime.of(LocalDateTime.of(year, mm, dd, 0, 0), ZoneId.systemDefault());
        return Collections.singletonList(dateTime.format(this.getDtfOut()));
    }
}

