/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.util.StringUtils;

public class ConfigUtils {
    public static final String IS_QUERY_AS_RO_TABLE = "hoodie.query.as.ro.table";

    public static Map<String, String> toMap(String keyValueConfig) {
        if (StringUtils.isNullOrEmpty((String)keyValueConfig)) {
            return new HashMap<String, String>();
        }
        String[] keyvalues = keyValueConfig.split("\n");
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        for (String keyValue : keyvalues) {
            String[] keyValueArray = keyValue.split("=");
            if (keyValueArray.length != 1 && keyValueArray.length != 2) {
                throw new IllegalArgumentException("Bad key-value config: " + keyValue + ", must be the format 'key = value'");
            }
            String key = keyValueArray[0].trim();
            String value = keyValueArray.length == 2 ? keyValueArray[1].trim() : "";
            tableProperties.put(key, value);
        }
        return tableProperties;
    }

    public static String configToString(Map<String, String> config) {
        if (config == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }
}

