/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeCommitReq
extends TPipeSubscribeReq {
    private transient Map<String, List<String>> topicNameToSubscriptionCommitIds = new HashMap<String, List<String>>();

    public Map<String, List<String>> getTopicNameToSubscriptionCommitIds() {
        return this.topicNameToSubscriptionCommitIds;
    }

    public static PipeSubscribeCommitReq toTPipeSubscribeReq(Map<String, List<String>> topicNameToSubscriptionCommitIds) throws IOException {
        PipeSubscribeCommitReq req = new PipeSubscribeCommitReq();
        req.topicNameToSubscriptionCommitIds = topicNameToSubscriptionCommitIds;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.COMMIT.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)topicNameToSubscriptionCommitIds.size(), (OutputStream)outputStream);
            for (Map.Entry<String, List<String>> entry : topicNameToSubscriptionCommitIds.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.writeStringList(entry.getValue(), (OutputStream)outputStream);
            }
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeSubscribeCommitReq fromTPipeSubscribeReq(TPipeSubscribeReq commitReq) {
        PipeSubscribeCommitReq req = new PipeSubscribeCommitReq();
        if (Objects.nonNull(commitReq.body) && commitReq.body.hasRemaining()) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)commitReq.body);
            for (int i = 0; i < size; ++i) {
                String topicName = ReadWriteIOUtils.readString((ByteBuffer)commitReq.body);
                List subscriptionCommitIds = ReadWriteIOUtils.readStringList((ByteBuffer)commitReq.body);
                req.topicNameToSubscriptionCommitIds.put(topicName, subscriptionCommitIds);
            }
        }
        req.version = commitReq.version;
        req.type = commitReq.type;
        req.body = commitReq.body;
        return req;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeCommitReq that = (PipeSubscribeCommitReq)((Object)obj);
        return Objects.equals(this.topicNameToSubscriptionCommitIds, that.topicNameToSubscriptionCommitIds) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.topicNameToSubscriptionCommitIds, this.version, this.type, this.body);
    }
}

