/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.payload.EnrichedTablets;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;

public class PipeSubscribePollResp
extends TPipeSubscribeResp {
    private transient List<EnrichedTablets> enrichedTabletsList = new ArrayList<EnrichedTablets>();

    public List<EnrichedTablets> getEnrichedTabletsList() {
        return this.enrichedTabletsList;
    }

    public static PipeSubscribePollResp toTPipeSubscribeResp(TSStatus status, List<Pair<ByteBuffer, EnrichedTablets>> enrichedTabletsWithByteBufferList) {
        PipeSubscribePollResp resp = new PipeSubscribePollResp();
        resp.enrichedTabletsList = enrichedTabletsWithByteBufferList.stream().map(Pair::getRight).collect(Collectors.toList());
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.POLL_TABLETS.getType();
        try {
            resp.body = PipeSubscribePollResp.serializeEnrichedTabletsWithByteBufferList(enrichedTabletsWithByteBufferList);
        }
        catch (IOException e) {
            resp.status = RpcUtils.getStatus(TSStatusCode.SUBSCRIPTION_POLL_ERROR, e.getMessage());
        }
        return resp;
    }

    public static PipeSubscribePollResp directToTPipeSubscribeResp(TSStatus status, List<ByteBuffer> byteBuffers) {
        PipeSubscribePollResp resp = new PipeSubscribePollResp();
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.POLL_TABLETS.getType();
        resp.body = byteBuffers;
        return resp;
    }

    public static PipeSubscribePollResp fromTPipeSubscribeResp(TPipeSubscribeResp pollResp) {
        PipeSubscribePollResp resp = new PipeSubscribePollResp();
        if (Objects.nonNull(pollResp.body)) {
            for (ByteBuffer byteBuffer : pollResp.body) {
                if (!Objects.nonNull(byteBuffer) || !byteBuffer.hasRemaining()) continue;
                resp.enrichedTabletsList.add(EnrichedTablets.deserialize(byteBuffer));
            }
        }
        resp.status = pollResp.status;
        resp.version = pollResp.version;
        resp.type = pollResp.type;
        resp.body = pollResp.body;
        return resp;
    }

    public static List<ByteBuffer> serializeEnrichedTabletsList(List<EnrichedTablets> enrichedTabletsList) throws IOException {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        for (EnrichedTablets enrichedTablets : enrichedTabletsList) {
            byteBufferList.add(PipeSubscribePollResp.serializeEnrichedTablets(enrichedTablets));
        }
        return byteBufferList;
    }

    public static List<ByteBuffer> serializeEnrichedTabletsWithByteBufferList(List<Pair<ByteBuffer, EnrichedTablets>> enrichedTabletsWithByteBufferList) throws IOException {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        for (Pair<ByteBuffer, EnrichedTablets> enrichedTabletsWithByteBuffer : enrichedTabletsWithByteBufferList) {
            if (Objects.nonNull(enrichedTabletsWithByteBuffer.getLeft())) {
                byteBufferList.add((ByteBuffer)enrichedTabletsWithByteBuffer.getLeft());
                continue;
            }
            byteBufferList.add(PipeSubscribePollResp.serializeEnrichedTablets((EnrichedTablets)enrichedTabletsWithByteBuffer.getRight()));
        }
        return byteBufferList;
    }

    public static ByteBuffer serializeEnrichedTablets(EnrichedTablets enrichedTablets) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                enrichedTablets.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribePollResp that = (PipeSubscribePollResp)((Object)obj);
        return Objects.equals(this.enrichedTabletsList, that.enrichedTabletsList) && Objects.equals(this.status, that.status) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.enrichedTabletsList, this.status, this.version, this.type, this.body);
    }
}

