/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

public enum TSEncoding {
    PLAIN(0),
    DICTIONARY(1),
    RLE(2),
    DIFF(3),
    TS_2DIFF(4),
    BITMAP(5),
    GORILLA_V1(6),
    REGULAR(7),
    GORILLA(8),
    ZIGZAG(9),
    FREQ(10),
    CHIMP(11),
    SPRINTZ(12),
    RLBE(13);

    private final byte type;

    private TSEncoding(byte type) {
        this.type = type;
    }

    public static TSEncoding deserialize(byte encoding) {
        return TSEncoding.getTsEncoding(encoding);
    }

    private static TSEncoding getTsEncoding(byte encoding) {
        switch (encoding) {
            case 0: {
                return PLAIN;
            }
            case 1: {
                return DICTIONARY;
            }
            case 2: {
                return RLE;
            }
            case 3: {
                return DIFF;
            }
            case 4: {
                return TS_2DIFF;
            }
            case 5: {
                return BITMAP;
            }
            case 6: {
                return GORILLA_V1;
            }
            case 7: {
                return REGULAR;
            }
            case 8: {
                return GORILLA;
            }
            case 9: {
                return ZIGZAG;
            }
            case 11: {
                return CHIMP;
            }
            case 12: {
                return SPRINTZ;
            }
            case 13: {
                return RLBE;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + encoding);
    }

    public static int getSerializedSize() {
        return 1;
    }

    public byte serialize() {
        return this.type;
    }
}

