/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;

public class TimeStatistics
extends Statistics<Long> {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeStatistics.class);
    private static final String TIME = "Time";
    private static final String UPDATE_STATS = "update stats";

    @Override
    public TSDataType getType() {
        return TSDataType.VECTOR;
    }

    @Override
    public int getStatsSize() {
        return 0;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public void update(long time) {
        super.update(time);
        this.setEmpty(false);
    }

    @Override
    public void update(long[] time, int batchSize) {
        super.update(time, batchSize);
        if (batchSize > 0) {
            this.setEmpty(false);
        }
    }

    @Override
    public void update(long[] time, int batchSize, int arrayOffset) {
        super.update(time, batchSize, arrayOffset);
        if (batchSize > 0) {
            this.setEmpty(false);
        }
    }

    @Override
    public Long getMinValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "min value"));
    }

    @Override
    public Long getMaxValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "max value"));
    }

    @Override
    public Long getFirstValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "first value"));
    }

    @Override
    public Long getLastValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "last value"));
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "double sum"));
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, "long sum"));
    }

    @Override
    void updateStats(long value) {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, UPDATE_STATS));
    }

    @Override
    void updateStats(long[] values, int batchSize) {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, UPDATE_STATS));
    }

    @Override
    public void updateStats(long minValue, long maxValue) {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TIME, UPDATE_STATS));
    }

    @Override
    protected void mergeStatisticsValue(Statistics<Long> stats) {
    }

    @Override
    public int serializeStats(OutputStream outputStream) {
        return 0;
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
    }
}

