/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class TsFileDeviceIterator
implements Iterator<Pair<IDeviceID, Boolean>> {
    private final TsFileSequenceReader reader;
    private final Queue<Pair<IDeviceID, long[]>> queue;
    private Pair<IDeviceID, Boolean> currentDevice = null;
    private MetadataIndexNode measurementNode;
    private final List<long[]> leafDeviceNodeOffsetList;

    public TsFileDeviceIterator(TsFileSequenceReader reader, List<long[]> leafDeviceNodeOffsetList, Queue<Pair<IDeviceID, long[]>> queue) {
        this.reader = reader;
        this.queue = queue;
        this.leafDeviceNodeOffsetList = leafDeviceNodeOffsetList;
    }

    public Pair<IDeviceID, Boolean> current() {
        return this.currentDevice;
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.leafDeviceNodeOffsetList.isEmpty()) {
            return false;
        }
        long[] nextDeviceLeafNodeOffset = this.leafDeviceNodeOffsetList.remove(0);
        try {
            this.reader.getDevicesAndEntriesOfOneLeafNode(nextDeviceLeafNodeOffset[0], nextDeviceLeafNodeOffset[1], this.queue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public Pair<IDeviceID, Boolean> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<IDeviceID, long[]> startEndPair = this.queue.remove();
        try {
            this.measurementNode = this.reader.readMetadataIndexNode(((long[])startEndPair.right)[0], ((long[])startEndPair.right)[1], false);
            boolean isAligned = this.reader.isAlignedDevice(this.measurementNode);
            this.currentDevice = new Pair<IDeviceID, Boolean>((IDeviceID)startEndPair.left, isAligned);
            return this.currentDevice;
        }
        catch (IOException e) {
            throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
        }
    }

    public MetadataIndexNode getFirstMeasurementNodeOfCurrentDevice() {
        return this.measurementNode;
    }
}

