/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.value.Magnitude;

@Value(semanticsProviderName="org.apache.isis.core.progmodel.facets.value.color.ColorValueSemanticsProvider")
public class Color
extends Magnitude<Color> {
    private static final long serialVersionUID = 1L;
    public static final Color WHITE = new Color(0xFFFFFF);
    public static final Color BLACK = new Color(0);
    private final int color;

    public Color(int color) {
        this.color = color;
    }

    public int intValue() {
        return this.color;
    }

    @Override
    public boolean isEqualTo(Color number) {
        return number.color == this.color;
    }

    @Override
    public boolean isLessThan(Color value) {
        return this.color < value.color;
    }

    public String title() {
        if (this.color == 0) {
            return "Black";
        }
        if (this.color == 0xFFFFFF) {
            return "White";
        }
        return "#" + Integer.toHexString(this.color).toUpperCase();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        return this.color == other.color;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.color;
        return result;
    }

    public String toString() {
        return "Color: #" + Integer.toHexString(this.color).toUpperCase();
    }
}

