/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.producer.internals.ProducerMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ProducerMetadataTest {
    private long refreshBackoffMs = 100L;
    private long metadataExpireMs = 1000L;
    private ProducerMetadata metadata = new ProducerMetadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), new ClusterResourceListeners(), Time.SYSTEM);
    private AtomicReference<Exception> backgroundError = new AtomicReference();

    @After
    public void tearDown() {
        Assert.assertNull((String)("Exception in background thread : " + this.backgroundError.get()), (Object)this.backgroundError.get());
    }

    @Test
    public void testMetadata() throws Exception {
        String topic = "my-topic";
        this.metadata.add(topic);
        long time = Time.SYSTEM.milliseconds();
        this.metadata.update(this.responseWithTopics(Collections.emptySet()), time);
        Assert.assertTrue((String)"No update needed.", (this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0);
        this.metadata.requestUpdate();
        Assert.assertTrue((String)"Still no updated needed due to backoff", (this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Update needed now that backoff time expired", (long)0L, (long)this.metadata.timeToNextUpdate(time += this.refreshBackoffMs));
        Thread t1 = this.asyncFetch(topic, 500L);
        Thread t2 = this.asyncFetch(topic, 500L);
        Assert.assertTrue((String)"Awaiting update", (boolean)t1.isAlive());
        Assert.assertTrue((String)"Awaiting update", (boolean)t2.isAlive());
        while (t1.isAlive() || t2.isAlive()) {
            if (this.metadata.timeToNextUpdate(time) == 0L) {
                this.metadata.update(this.responseWithCurrentTopics(), time);
                time += this.refreshBackoffMs;
            }
            Thread.sleep(1L);
        }
        t1.join();
        t2.join();
        Assert.assertTrue((String)"No update needed.", (this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Update needed due to stale metadata.", (long)0L, (long)this.metadata.timeToNextUpdate(time += this.metadataExpireMs));
    }

    @Test
    public void testMetadataAwaitAfterClose() throws InterruptedException {
        long time = 0L;
        this.metadata.update(this.responseWithCurrentTopics(), time);
        Assert.assertTrue((String)"No update needed.", (this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0);
        this.metadata.requestUpdate();
        Assert.assertTrue((String)"Still no updated needed due to backoff", (this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Update needed now that backoff time expired", (long)0L, (long)this.metadata.timeToNextUpdate(time += this.refreshBackoffMs));
        String topic = "my-topic";
        this.metadata.close();
        Thread t1 = this.asyncFetch(topic, 500L);
        t1.join();
        Assert.assertEquals(KafkaException.class, this.backgroundError.get().getClass());
        Assert.assertTrue((boolean)this.backgroundError.get().toString().contains("Requested metadata update after close"));
        this.clearBackgroundError();
    }

    @Test
    public void testMetadataUpdateWaitTime() throws Exception {
        long time = 0L;
        this.metadata.update(this.responseWithCurrentTopics(), time);
        Assert.assertTrue((String)"No update needed.", (this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0);
        try {
            this.metadata.awaitUpdate(this.metadata.requestUpdate(), 0L);
            Assert.fail((String)"Wait on metadata update was expected to timeout, but it didn't");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        long twoSecondWait = 2000L;
        try {
            this.metadata.awaitUpdate(this.metadata.requestUpdate(), 2000L);
            Assert.fail((String)"Wait on metadata update was expected to timeout, but it didn't");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeToNextUpdateOverwriteBackoff() {
        long now = 10000L;
        this.metadata.update(this.responseWithCurrentTopics(), now);
        this.metadata.add("new-topic");
        Assert.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now));
        this.metadata.update(this.responseWithCurrentTopics(), now);
        this.metadata.add("new-topic");
        Assert.assertEquals((long)this.metadataExpireMs, (long)this.metadata.timeToNextUpdate(now));
        this.metadata.add("another-new-topic");
        Assert.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now));
    }

    @Test
    public void testTopicExpiry() {
        long time = 0L;
        String topic1 = "topic1";
        this.metadata.add(topic1);
        this.metadata.update(this.responseWithCurrentTopics(), time);
        Assert.assertTrue((boolean)this.metadata.containsTopic(topic1));
        this.metadata.update(this.responseWithCurrentTopics(), time += 300000L);
        Assert.assertFalse((String)"Unused topic not expired", (boolean)this.metadata.containsTopic(topic1));
        this.metadata.add("topic2");
        this.metadata.update(this.responseWithCurrentTopics(), time);
        for (int i = 0; i < 3; ++i) {
            this.metadata.update(this.responseWithCurrentTopics(), time += 150000L);
            Assert.assertTrue((String)"Topic expired even though in use", (boolean)this.metadata.containsTopic("topic2"));
            this.metadata.add("topic2");
        }
    }

    private MetadataResponse responseWithCurrentTopics() {
        return this.responseWithTopics(this.metadata.topics());
    }

    private MetadataResponse responseWithTopics(Set<String> topics) {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        for (String topic : topics) {
            partitionCounts.put(topic, 1);
        }
        return TestUtils.metadataUpdateWith(1, partitionCounts);
    }

    private void clearBackgroundError() {
        this.backgroundError.set(null);
    }

    private Thread asyncFetch(String topic, long maxWaitMs) {
        Thread thread = new Thread(() -> {
            try {
                while (this.metadata.fetch().partitionsForTopic(topic).isEmpty()) {
                    this.metadata.awaitUpdate(this.metadata.requestUpdate(), maxWaitMs);
                }
            }
            catch (Exception e) {
                this.backgroundError.set(e);
            }
        });
        thread.start();
        return thread;
    }
}

