/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class HeartbeatResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public HeartbeatResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public HeartbeatResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public HeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
    }

    public short apiKey() {
        return 12;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        this.errorCode = readable.readShort();
    }

    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeShort(this.errorCode);
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        if (version >= 1) {
            size += 4;
        }
        return size += 2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeartbeatResponseData)) {
            return false;
        }
        HeartbeatResponseData other = (HeartbeatResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return this.errorCode == other.errorCode;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    public String toString() {
        return "HeartbeatResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public HeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public HeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error.")}));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

