/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.junit.Assert;
import org.junit.Test;

public class KerberosNameTest {
    @Test
    public void testParse() throws IOException {
        List<String> rules = Arrays.asList("RULE:[1:$1](App\\..*)s/App\\.(.*)/$1/g", "RULE:[2:$1](App\\..*)s/App\\.(.*)/$1/g", "DEFAULT");
        KerberosShortNamer shortNamer = KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
        KerberosName name = KerberosName.parse((String)"App.service-name/example.com@REALM.COM");
        Assert.assertEquals((Object)"App.service-name", (Object)name.serviceName());
        Assert.assertEquals((Object)"example.com", (Object)name.hostName());
        Assert.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assert.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"App.service-name@REALM.COM");
        Assert.assertEquals((Object)"App.service-name", (Object)name.serviceName());
        Assert.assertNull((Object)name.hostName());
        Assert.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assert.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"user/host@REALM.COM");
        Assert.assertEquals((Object)"user", (Object)name.serviceName());
        Assert.assertEquals((Object)"host", (Object)name.hostName());
        Assert.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assert.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
    }

    @Test
    public void testToLowerCase() throws Exception {
        List<String> rules = Arrays.asList("RULE:[1:$1]/L", "RULE:[2:$1](Test.*)s/ABC///L", "RULE:[2:$1](ABC.*)s/ABC/XYZ/g/L", "RULE:[2:$1](App\\..*)s/App\\.(.*)/$1/g/L", "RULE:[2:$1]/L", "DEFAULT");
        KerberosShortNamer shortNamer = KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
        KerberosName name = KerberosName.parse((String)"User@REALM.COM");
        Assert.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"TestABC/host@FOO.COM");
        Assert.assertEquals((Object)"test", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"ABC_User_ABC/host@FOO.COM");
        Assert.assertEquals((Object)"xyz_user_xyz", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"App.SERVICE-name/example.com@REALM.COM");
        Assert.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"User/root@REALM.COM");
        Assert.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
    }

    @Test
    public void testInvalidRules() {
        this.testInvalidRule(Arrays.asList("default"));
        this.testInvalidRule(Arrays.asList("DEFAUL"));
        this.testInvalidRule(Arrays.asList("DEFAULT/L"));
        this.testInvalidRule(Arrays.asList("DEFAULT/g"));
        this.testInvalidRule(Arrays.asList("rule:[1:$1]"));
        this.testInvalidRule(Arrays.asList("RULE:[1:$1/L"));
        this.testInvalidRule(Arrays.asList("RULE:[1:$1]/l"));
        this.testInvalidRule(Arrays.asList("RULE:[2:$1](ABC.*)s/ABC/XYZ/L/g"));
    }

    private void testInvalidRule(List<String> rules) {
        try {
            KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
            Assert.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

