/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerUnsecuredLoginCallbackHandlerTest {
    @Test
    public void addsExtensions() throws IOException, UnsupportedCallbackException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("unsecuredLoginExtension_testId", "1");
        OAuthBearerUnsecuredLoginCallbackHandler callbackHandler = OAuthBearerUnsecuredLoginCallbackHandlerTest.createCallbackHandler(options, new MockTime());
        SaslExtensionsCallback callback = new SaslExtensionsCallback();
        callbackHandler.handle(new Callback[]{callback});
        Assert.assertEquals((Object)"1", callback.extensions().map().get("testId"));
    }

    @Test(expected=IOException.class)
    public void throwsErrorOnInvalidExtensionName() throws IOException, UnsupportedCallbackException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("unsecuredLoginExtension_test.Id", "1");
        OAuthBearerUnsecuredLoginCallbackHandler callbackHandler = OAuthBearerUnsecuredLoginCallbackHandlerTest.createCallbackHandler(options, new MockTime());
        SaslExtensionsCallback callback = new SaslExtensionsCallback();
        callbackHandler.handle(new Callback[]{callback});
    }

    @Test(expected=IOException.class)
    public void throwsErrorOnInvalidExtensionValue() throws IOException, UnsupportedCallbackException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("unsecuredLoginExtension_testId", "\u00c7alifornia");
        OAuthBearerUnsecuredLoginCallbackHandler callbackHandler = OAuthBearerUnsecuredLoginCallbackHandlerTest.createCallbackHandler(options, new MockTime());
        SaslExtensionsCallback callback = new SaslExtensionsCallback();
        callbackHandler.handle(new Callback[]{callback});
    }

    @Test
    public void minimalToken() throws IOException, UnsupportedCallbackException {
        HashMap<String, String> options = new HashMap<String, String>();
        String user = "user";
        options.put("unsecuredLoginStringClaim_sub", user);
        MockTime mockTime = new MockTime();
        OAuthBearerUnsecuredLoginCallbackHandler callbackHandler = OAuthBearerUnsecuredLoginCallbackHandlerTest.createCallbackHandler(options, mockTime);
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        callbackHandler.handle(new Callback[]{callback});
        OAuthBearerUnsecuredJws jws = (OAuthBearerUnsecuredJws)callback.token();
        Assert.assertNotNull((String)"create token failed", (Object)jws);
        long startMs = mockTime.milliseconds();
        OAuthBearerUnsecuredLoginCallbackHandlerTest.confirmCorrectValues(jws, user, startMs, 3600000L);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("sub", "iat", "exp")), jws.claims().keySet());
    }

    @Test
    public void validOptionsWithExplicitOptionValues() throws IOException, UnsupportedCallbackException {
        String[] scopeClaimNameOptionValues;
        String explicitScope1 = "scope1";
        String explicitScope2 = "scope2";
        String explicitScopeClaimName = "putScopeInHere";
        String principalClaimName = "principal";
        for (String scopeClaimNameOptionValue : scopeClaimNameOptionValues = new String[]{null, explicitScopeClaimName}) {
            HashMap<String, String> options = new HashMap<String, String>();
            String user = "user";
            options.put("unsecuredLoginStringClaim_" + principalClaimName, user);
            options.put("unsecuredLoginListClaim_list", ",1,2,");
            options.put("unsecuredLoginListClaim_emptyList1", "");
            options.put("unsecuredLoginListClaim_emptyList2", ",");
            options.put("unsecuredLoginNumberClaim_number", "1");
            long lifetmeSeconds = 10000L;
            options.put("unsecuredLoginLifetimeSeconds", String.valueOf(lifetmeSeconds));
            options.put("unsecuredLoginPrincipalClaimName", principalClaimName);
            if (scopeClaimNameOptionValue != null) {
                options.put("unsecuredLoginScopeClaimName", scopeClaimNameOptionValue);
            }
            String actualScopeClaimName = scopeClaimNameOptionValue == null ? "scope" : explicitScopeClaimName;
            options.put("unsecuredLoginListClaim_" + actualScopeClaimName, String.format("|%s|%s", explicitScope1, explicitScope2));
            MockTime mockTime = new MockTime();
            OAuthBearerUnsecuredLoginCallbackHandler callbackHandler = OAuthBearerUnsecuredLoginCallbackHandlerTest.createCallbackHandler(options, mockTime);
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            callbackHandler.handle(new Callback[]{callback});
            OAuthBearerUnsecuredJws jws = (OAuthBearerUnsecuredJws)callback.token();
            Assert.assertNotNull((String)"create token failed", (Object)jws);
            long startMs = mockTime.milliseconds();
            OAuthBearerUnsecuredLoginCallbackHandlerTest.confirmCorrectValues(jws, user, startMs, lifetmeSeconds * 1000L);
            Map claims = jws.claims();
            Assert.assertEquals(new HashSet<String>(Arrays.asList(actualScopeClaimName, principalClaimName, "iat", "exp", "number", "list", "emptyList1", "emptyList2")), claims.keySet());
            Assert.assertEquals(new HashSet<String>(Arrays.asList(explicitScope1, explicitScope2)), new HashSet((List)claims.get(actualScopeClaimName)));
            Assert.assertEquals(new HashSet<String>(Arrays.asList(explicitScope1, explicitScope2)), (Object)jws.scope());
            Assert.assertEquals((Object)1.0, (Object)jws.claim("number", Number.class));
            Assert.assertEquals(Arrays.asList("1", "2", ""), (Object)jws.claim("list", List.class));
            Assert.assertEquals(Collections.emptyList(), (Object)jws.claim("emptyList1", List.class));
            Assert.assertEquals(Collections.emptyList(), (Object)jws.claim("emptyList2", List.class));
        }
    }

    private static OAuthBearerUnsecuredLoginCallbackHandler createCallbackHandler(Map<String, String> options, MockTime mockTime) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry("KafkaClient", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule", options);
        OAuthBearerUnsecuredLoginCallbackHandler callbackHandler = new OAuthBearerUnsecuredLoginCallbackHandler();
        callbackHandler.time((Time)mockTime);
        callbackHandler.configure(Collections.emptyMap(), "OAUTHBEARER", Arrays.asList(config.getAppConfigurationEntry("KafkaClient")[0]));
        return callbackHandler;
    }

    private static void confirmCorrectValues(OAuthBearerUnsecuredJws jws, String user, long startMs, long lifetimeSeconds) throws OAuthBearerIllegalTokenException {
        Map header = jws.header();
        Assert.assertEquals((long)header.size(), (long)1L);
        Assert.assertEquals((Object)"none", header.get("alg"));
        Assert.assertEquals((Object)(user != null ? user : "<unknown>"), (Object)jws.principalName());
        Assert.assertEquals((Object)startMs, (Object)jws.startTimeMs());
        Assert.assertEquals((long)startMs, (long)Math.round(jws.issuedAt().doubleValue() * 1000.0));
        Assert.assertEquals((long)(startMs + lifetimeSeconds), (long)jws.lifetimeMs());
        Assert.assertEquals((long)jws.lifetimeMs(), (long)Math.round(jws.expirationTime().doubleValue() * 1000.0));
    }
}

