/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class AlterReplicaLogDirsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<AlterReplicaLogDirTopicResult> results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AlterReplicaLogDirsResponseData(Readable readable, short version) {
        this.results = new ArrayList<AlterReplicaLogDirTopicResult>();
        this.read(readable, version);
    }

    public AlterReplicaLogDirsResponseData(Struct struct, short version) {
        this.results = new ArrayList<AlterReplicaLogDirTopicResult>();
        this.fromStruct(struct, version);
    }

    public AlterReplicaLogDirsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<AlterReplicaLogDirTopicResult>();
    }

    @Override
    public short apiKey() {
        return 34;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results = null;
        } else {
            this.results.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new AlterReplicaLogDirTopicResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        for (AlterReplicaLogDirTopicResult element : this.results) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new ArrayList<AlterReplicaLogDirTopicResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new AlterReplicaLogDirTopicResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        for (AlterReplicaLogDirTopicResult element : this.results) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (AlterReplicaLogDirTopicResult element : this.results) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterReplicaLogDirsResponseData)) {
            return false;
        }
        AlterReplicaLogDirsResponseData other = (AlterReplicaLogDirsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AlterReplicaLogDirsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AlterReplicaLogDirTopicResult> results() {
        return this.results;
    }

    public AlterReplicaLogDirsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterReplicaLogDirsResponseData setResults(List<AlterReplicaLogDirTopicResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(AlterReplicaLogDirTopicResult.SCHEMA_0), "The results for each topic."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AlterReplicaLogDirPartitionResult
    implements Message {
        private int partitionIndex;
        private short errorCode;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterReplicaLogDirPartitionResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public AlterReplicaLogDirPartitionResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AlterReplicaLogDirPartitionResult() {
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirPartitionResult)) {
                return false;
            }
            AlterReplicaLogDirPartitionResult other = (AlterReplicaLogDirPartitionResult)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "AlterReplicaLogDirPartitionResult(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public AlterReplicaLogDirPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AlterReplicaLogDirPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterReplicaLogDirTopicResult
    implements Message {
        private String topicName;
        private List<AlterReplicaLogDirPartitionResult> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterReplicaLogDirTopicResult(Readable readable, short version) {
            this.partitions = new ArrayList<AlterReplicaLogDirPartitionResult>();
            this.read(readable, version);
        }

        public AlterReplicaLogDirTopicResult(Struct struct, short version) {
            this.partitions = new ArrayList<AlterReplicaLogDirPartitionResult>();
            this.fromStruct(struct, version);
        }

        public AlterReplicaLogDirTopicResult() {
            this.topicName = "";
            this.partitions = new ArrayList<AlterReplicaLogDirPartitionResult>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.topicName = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new AlterReplicaLogDirPartitionResult(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.topicName);
            writable.writeInt(this.partitions.size());
            for (AlterReplicaLogDirPartitionResult element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.topicName = struct.getString("topic_name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<AlterReplicaLogDirPartitionResult>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new AlterReplicaLogDirPartitionResult((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (AlterReplicaLogDirPartitionResult element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            size += 4;
            for (AlterReplicaLogDirPartitionResult element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopicResult)) {
                return false;
            }
            AlterReplicaLogDirTopicResult other = (AlterReplicaLogDirTopicResult)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterReplicaLogDirTopicResult(topicName='" + this.topicName + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<AlterReplicaLogDirPartitionResult> partitions() {
            return this.partitions;
        }

        public AlterReplicaLogDirTopicResult setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public AlterReplicaLogDirTopicResult setPartitions(List<AlterReplicaLogDirPartitionResult> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The name of the topic."), new Field("partitions", new ArrayOf(AlterReplicaLogDirPartitionResult.SCHEMA_0), "The results for each partition."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

