/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class BrokerRegistration {
    private final int id;
    private final long epoch;
    private final Uuid incarnationId;
    private final Map<String, Endpoint> listeners;
    private final Map<String, VersionRange> supportedFeatures;
    private final Optional<String> rack;
    private final boolean fenced;
    private final boolean inControlledShutdown;
    private final boolean isMigratingZkBroker;
    private final List<Uuid> directories;

    public static Optional<Long> zkBrokerEpoch(long value) {
        if (value == -1L) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    private BrokerRegistration(int id, long epoch, Uuid incarnationId, Map<String, Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Optional<String> rack, boolean fenced, boolean inControlledShutdown, boolean isMigratingZkBroker, List<Uuid> directories) {
        this.id = id;
        this.epoch = epoch;
        this.incarnationId = incarnationId;
        HashMap<String, Endpoint> newListeners = new HashMap<String, Endpoint>(listeners.size());
        for (Map.Entry<String, Endpoint> entry : listeners.entrySet()) {
            if (!entry.getValue().listenerName().isPresent()) {
                throw new IllegalArgumentException("Broker listeners must be named.");
            }
            newListeners.put(entry.getKey(), entry.getValue());
        }
        this.listeners = Collections.unmodifiableMap(newListeners);
        Objects.requireNonNull(supportedFeatures);
        this.supportedFeatures = new HashMap<String, VersionRange>(supportedFeatures);
        this.rack = rack;
        this.fenced = fenced;
        this.inControlledShutdown = inControlledShutdown;
        this.isMigratingZkBroker = isMigratingZkBroker;
        directories = new ArrayList<Uuid>(directories);
        directories.sort(Uuid::compareTo);
        this.directories = Collections.unmodifiableList(directories);
    }

    public static BrokerRegistration fromRecord(RegisterBrokerRecord record) {
        HashMap<String, Endpoint> listeners = new HashMap<String, Endpoint>();
        Iterator iterator = record.endPoints().iterator();
        while (iterator.hasNext()) {
            RegisterBrokerRecord.BrokerEndpoint endpoint = (RegisterBrokerRecord.BrokerEndpoint)iterator.next();
            listeners.put(endpoint.name(), new Endpoint(endpoint.name(), SecurityProtocol.forId((short)endpoint.securityProtocol()), endpoint.host(), endpoint.port()));
        }
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        Iterator iterator2 = record.features().iterator();
        while (iterator2.hasNext()) {
            RegisterBrokerRecord.BrokerFeature feature = (RegisterBrokerRecord.BrokerFeature)iterator2.next();
            supportedFeatures.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()));
        }
        return new BrokerRegistration(record.brokerId(), record.brokerEpoch(), record.incarnationId(), listeners, supportedFeatures, Optional.ofNullable(record.rack()), record.fenced(), record.inControlledShutdown(), record.isMigratingZkBroker(), record.logDirs());
    }

    public int id() {
        return this.id;
    }

    public long epoch() {
        return this.epoch;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public Map<String, Endpoint> listeners() {
        return this.listeners;
    }

    public Optional<Node> node(String listenerName) {
        Endpoint endpoint = this.listeners().get(listenerName);
        if (endpoint == null) {
            return Optional.empty();
        }
        return Optional.of(new Node(this.id, endpoint.host(), endpoint.port(), (String)this.rack.orElse(null)));
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Optional<String> rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public boolean inControlledShutdown() {
        return this.inControlledShutdown;
    }

    public boolean isMigratingZkBroker() {
        return this.isMigratingZkBroker;
    }

    public List<Uuid> directories() {
        return this.directories;
    }

    public boolean hasOnlineDir(Uuid dir) {
        return DirectoryId.isOnline((Uuid)dir, this.directories);
    }

    public List<Uuid> directoryIntersection(List<Uuid> otherDirectories) {
        ArrayList<Uuid> results = new ArrayList<Uuid>();
        for (Uuid directory : this.directories) {
            if (!otherDirectories.contains(directory)) continue;
            results.add(directory);
        }
        return results;
    }

    public List<Uuid> directoryDifference(List<Uuid> otherDirectories) {
        ArrayList<Uuid> results = new ArrayList<Uuid>();
        for (Uuid directory : this.directories) {
            if (otherDirectories.contains(directory)) continue;
            results.add(directory);
        }
        return results;
    }

    public ApiMessageAndVersion toRecord(ImageWriterOptions options) {
        RegisterBrokerRecord registrationRecord = new RegisterBrokerRecord().setBrokerId(this.id).setRack(this.rack.orElse(null)).setBrokerEpoch(this.epoch).setIncarnationId(this.incarnationId).setFenced(this.fenced);
        if (this.inControlledShutdown) {
            if (options.metadataVersion().isInControlledShutdownStateSupported()) {
                registrationRecord.setInControlledShutdown(true);
            } else {
                options.handleLoss("the inControlledShutdown state of one or more brokers");
            }
        }
        if (this.isMigratingZkBroker) {
            if (options.metadataVersion().isMigrationSupported()) {
                registrationRecord.setIsMigratingZkBroker(this.isMigratingZkBroker);
            } else {
                options.handleLoss("the isMigratingZkBroker state of one or more brokers");
            }
        }
        if (this.directories.isEmpty() || options.metadataVersion().isDirectoryAssignmentSupported()) {
            registrationRecord.setLogDirs(this.directories);
        } else {
            options.handleLoss("the online log directories of one or more brokers");
        }
        for (Map.Entry<String, Endpoint> entry : this.listeners.entrySet()) {
            Endpoint endpoint = entry.getValue();
            registrationRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setName(entry.getKey()).setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        }
        for (Map.Entry<String, Object> entry : this.supportedFeatures.entrySet()) {
            registrationRecord.features().add(new RegisterBrokerRecord.BrokerFeature().setName(entry.getKey()).setMinSupportedVersion(((VersionRange)entry.getValue()).min()).setMaxSupportedVersion(((VersionRange)entry.getValue()).max()));
        }
        return new ApiMessageAndVersion((ApiMessage)registrationRecord, options.metadataVersion().registerBrokerRecordVersion());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, this.fenced, this.inControlledShutdown, this.isMigratingZkBroker, this.directories);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BrokerRegistration)) {
            return false;
        }
        BrokerRegistration other = (BrokerRegistration)o;
        return other.id == this.id && other.epoch == this.epoch && other.incarnationId.equals((Object)this.incarnationId) && other.listeners.equals(this.listeners) && other.supportedFeatures.equals(this.supportedFeatures) && other.rack.equals(this.rack) && other.fenced == this.fenced && other.inControlledShutdown == this.inControlledShutdown && other.isMigratingZkBroker == this.isMigratingZkBroker && other.directories.equals(this.directories);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("BrokerRegistration(id=").append(this.id);
        bld.append(", epoch=").append(this.epoch);
        bld.append(", incarnationId=").append(this.incarnationId);
        bld.append(", listeners=[").append(this.listeners.keySet().stream().sorted().map(n -> this.listeners.get(n).toString()).collect(Collectors.joining(", ")));
        bld.append("], supportedFeatures={").append(this.supportedFeatures.keySet().stream().sorted().map(k -> k + ": " + this.supportedFeatures.get(k)).collect(Collectors.joining(", ")));
        bld.append("}");
        bld.append(", rack=").append(this.rack);
        bld.append(", fenced=").append(this.fenced);
        bld.append(", inControlledShutdown=").append(this.inControlledShutdown);
        bld.append(", isMigratingZkBroker=").append(this.isMigratingZkBroker);
        bld.append(", directories=").append(this.directories);
        bld.append(")");
        return bld.toString();
    }

    public BrokerRegistration cloneWith(Optional<Boolean> fencingChange, Optional<Boolean> inControlledShutdownChange, Optional<List<Uuid>> directoriesChange) {
        boolean newFenced = fencingChange.orElse(this.fenced);
        boolean newInControlledShutdownChange = inControlledShutdownChange.orElse(this.inControlledShutdown);
        List<Uuid> newDirectories = directoriesChange.orElse(this.directories);
        if (newFenced == this.fenced && newInControlledShutdownChange == this.inControlledShutdown && newDirectories.equals(this.directories)) {
            return this;
        }
        return new BrokerRegistration(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, newFenced, newInControlledShutdownChange, this.isMigratingZkBroker, newDirectories);
    }

    public static class Builder {
        private int id = 0;
        private long epoch = -1L;
        private Uuid incarnationId = null;
        private Map<String, Endpoint> listeners = new HashMap<String, Endpoint>();
        private Map<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        private Optional<String> rack = Optional.empty();
        private boolean fenced = false;
        private boolean inControlledShutdown = false;
        private boolean isMigratingZkBroker = false;
        private List<Uuid> directories = Collections.emptyList();

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setEpoch(long epoch) {
            this.epoch = epoch;
            return this;
        }

        public Builder setIncarnationId(Uuid incarnationId) {
            this.incarnationId = incarnationId;
            return this;
        }

        public Builder setListeners(List<Endpoint> listeners) {
            HashMap<String, Endpoint> listenersMap = new HashMap<String, Endpoint>();
            for (Endpoint endpoint : listeners) {
                listenersMap.put((String)endpoint.listenerName().get(), endpoint);
            }
            this.listeners = listenersMap;
            return this;
        }

        public Builder setListeners(Map<String, Endpoint> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder setSupportedFeatures(Map<String, VersionRange> supportedFeatures) {
            this.supportedFeatures = supportedFeatures;
            return this;
        }

        public Builder setRack(Optional<String> rack) {
            Objects.requireNonNull(rack);
            this.rack = rack;
            return this;
        }

        public Builder setFenced(boolean fenced) {
            this.fenced = fenced;
            return this;
        }

        public Builder setInControlledShutdown(boolean inControlledShutdown) {
            this.inControlledShutdown = inControlledShutdown;
            return this;
        }

        public Builder setIsMigratingZkBroker(boolean isMigratingZkBroker) {
            this.isMigratingZkBroker = isMigratingZkBroker;
            return this;
        }

        public Builder setDirectories(List<Uuid> directories) {
            this.directories = directories;
            return this;
        }

        public BrokerRegistration build() {
            return new BrokerRegistration(this.id, this.epoch, this.incarnationId, this.listeners, this.supportedFeatures, this.rack, this.fenced, this.inControlledShutdown, this.isMigratingZkBroker, this.directories);
        }
    }
}

