/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedTableImpl;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamMapValues;
import org.apache.kafka.streams.kstream.internals.KTableFilter;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableInnerJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoinMerger;
import org.apache.kafka.streams.kstream.internals.KTableKTableLeftJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableOuterJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.kstream.internals.KTableMapValues;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableRepartitionMap;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KTableSourceValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableTransformValues;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.SerializedInternal;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

public class KTableImpl<K, S, V>
extends AbstractStream<K>
implements KTable<K, V> {
    static final String SOURCE_NAME = "KTABLE-SOURCE-";
    static final String STATE_STORE_NAME = "STATE-STORE-";
    private static final String FILTER_NAME = "KTABLE-FILTER-";
    private static final String JOINTHIS_NAME = "KTABLE-JOINTHIS-";
    private static final String JOINOTHER_NAME = "KTABLE-JOINOTHER-";
    private static final String MAPVALUES_NAME = "KTABLE-MAPVALUES-";
    private static final String MERGE_NAME = "KTABLE-MERGE-";
    private static final String SELECT_NAME = "KTABLE-SELECT-";
    private static final String TOSTREAM_NAME = "KTABLE-TOSTREAM-";
    private static final String TRANSFORMVALUES_NAME = "KTABLE-TRANSFORMVALUES-";
    private final ProcessorSupplier<?, ?> processorSupplier;
    private final String queryableStoreName;
    private final boolean isQueryable;
    private boolean sendOldValues = false;
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;

    public KTableImpl(InternalStreamsBuilder builder, String name, ProcessorSupplier<?, ?> processorSupplier, Set<String> sourceNodes, String queryableStoreName, boolean isQueryable) {
        super(builder, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.queryableStoreName = queryableStoreName;
        this.keySerde = null;
        this.valSerde = null;
        this.isQueryable = isQueryable;
    }

    public KTableImpl(InternalStreamsBuilder builder, String name, ProcessorSupplier<?, ?> processorSupplier, Serde<K> keySerde, Serde<V> valSerde, Set<String> sourceNodes, String queryableStoreName, boolean isQueryable) {
        super(builder, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.queryableStoreName = queryableStoreName;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.isQueryable = isQueryable;
    }

    @Override
    public String queryableStoreName() {
        if (!this.isQueryable) {
            return null;
        }
        return this.queryableStoreName;
    }

    private KTable<K, V> doFilter(Predicate<? super K, ? super V> predicate, MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized, boolean filterNot) {
        String name = this.builder.newProcessorName(FILTER_NAME);
        boolean shouldMaterialize = materialized != null && materialized.isQueryable();
        KTableFilter<? super K, ? super V> processorSupplier = new KTableFilter<K, V>(this, predicate, filterNot, shouldMaterialize ? materialized.storeName() : null);
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        if (shouldMaterialize) {
            this.builder.internalTopologyBuilder.addStateStore(new KeyValueStoreMaterializer<K, V>(materialized).materialize(), name);
        }
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.keySerde, this.valSerde, this.sourceNodes, shouldMaterialize ? materialized.storeName() : this.queryableStoreName, shouldMaterialize);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        return this.doFilter(predicate, null, false);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, FILTER_NAME);
        return this.doFilter(predicate, materializedInternal, false);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        return this.doFilter(predicate, null, true);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, FILTER_NAME);
        return this.doFilter(predicate, materializedInternal, true);
    }

    private <VR> KTable<K, VR> doMapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> mapper, MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        String name = this.builder.newProcessorName(MAPVALUES_NAME);
        boolean shouldMaterialize = materialized != null && materialized.isQueryable();
        KTableMapValues<? super K, ? super V, ? extends VR> processorSupplier = new KTableMapValues<K, V, VR>(this, mapper, shouldMaterialize ? materialized.storeName() : null);
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        if (shouldMaterialize) {
            this.builder.internalTopologyBuilder.addStateStore(new KeyValueStoreMaterializer<K, VR>(materialized).materialize(), name);
        }
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.sourceNodes, shouldMaterialize ? materialized.storeName() : this.queryableStoreName, shouldMaterialize);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapper<? super V, ? extends VR> mapper) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        return this.doMapValues(KTableImpl.withKey(mapper), null);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> mapper) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        return this.doMapValues(mapper, null);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapper<? super V, ? extends VR> mapper, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, MAPVALUES_NAME);
        return this.doMapValues(KTableImpl.withKey(mapper), materializedInternal);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> mapper, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, MAPVALUES_NAME);
        return this.doMapValues(mapper, materializedInternal);
    }

    @Override
    public <VR> KTable<K, VR> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> transformerSupplier, String ... stateStoreNames) {
        return this.doTransformValues(transformerSupplier, null, stateStoreNames);
    }

    @Override
    public <VR> KTable<K, VR> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> transformerSupplier, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized, String ... stateStoreNames) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, TRANSFORMVALUES_NAME);
        return this.doTransformValues(transformerSupplier, materializedInternal, stateStoreNames);
    }

    private <VR> KTable<K, VR> doTransformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> transformerSupplier, MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materialized, String ... stateStoreNames) {
        Objects.requireNonNull(stateStoreNames, "stateStoreNames");
        String name = this.builder.newProcessorName(TRANSFORMVALUES_NAME);
        boolean shouldMaterialize = materialized != null && materialized.isQueryable();
        KTableTransformValues<? super K, ? super V, ? extends VR> processorSupplier = new KTableTransformValues<K, V, VR>(this, transformerSupplier, shouldMaterialize ? materialized.storeName() : null);
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        if (stateStoreNames.length > 0) {
            this.builder.internalTopologyBuilder.connectProcessorAndStateStores(name, stateStoreNames);
        }
        if (shouldMaterialize) {
            this.builder.internalTopologyBuilder.addStateStore(new KeyValueStoreMaterializer<K, VR>(materialized).materialize(), name);
        }
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.sourceNodes, shouldMaterialize ? materialized.storeName() : this.queryableStoreName, shouldMaterialize);
    }

    @Override
    public KStream<K, V> toStream() {
        String name = this.builder.newProcessorName(TOSTREAM_NAME);
        this.builder.internalTopologyBuilder.addProcessor(name, new KStreamMapValues(new ValueMapperWithKey<K, Change<V>, V>(){

            @Override
            public V apply(K key, Change<V> change) {
                return change.newValue;
            }
        }), this.name);
        return new KStreamImpl(this.builder, name, this.sourceNodes, false);
    }

    @Override
    public <K1> KStream<K1, V> toStream(KeyValueMapper<? super K, ? super V, ? extends K1> mapper) {
        return this.toStream().selectKey(mapper);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, null, false, false);
    }

    @Override
    public <VO, VR> KTable<K, VR> join(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, MERGE_NAME);
        return this.doJoin(other, joiner, materializedInternal, false, false);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, null, true, true);
    }

    @Override
    public <VO, VR> KTable<K, VR> outerJoin(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, MERGE_NAME);
        return this.doJoin(other, joiner, materializedInternal, true, true);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, null, true, false);
    }

    @Override
    public <VO, VR> KTable<K, VR> leftJoin(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, MERGE_NAME);
        return this.doJoin(other, joiner, materializedInternal, true, false);
    }

    private <VO, VR> KTable<K, VR> doJoin(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materialized, boolean leftOuter, boolean rightOuter) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        String internalQueryableName = materialized == null ? null : materialized.storeName();
        String joinMergeName = this.builder.newProcessorName(MERGE_NAME);
        KTable<K, ? extends VR> result = this.buildJoin((AbstractStream)((Object)other), joiner, leftOuter, rightOuter, joinMergeName, internalQueryableName);
        if (materialized != null) {
            StoreBuilder<KeyValueStore<K, VR>> storeBuilder = new KeyValueStoreMaterializer<K, VR>(materialized).materialize();
            this.builder.internalTopologyBuilder.addStateStore(storeBuilder, joinMergeName);
        }
        return result;
    }

    private <V1, R> KTable<K, R> buildJoin(AbstractStream<K> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, boolean leftOuter, boolean rightOuter, String joinMergeName, String internalQueryableName) {
        KTableKTableAbstractJoin joinOther;
        KTableKTableAbstractJoin joinThis;
        Set<String> allSourceNodes = this.ensureJoinableWith(other);
        if (leftOuter) {
            this.enableSendingOldValues();
        }
        if (rightOuter) {
            ((KTableImpl)other).enableSendingOldValues();
        }
        String joinThisName = this.builder.newProcessorName(JOINTHIS_NAME);
        String joinOtherName = this.builder.newProcessorName(JOINOTHER_NAME);
        if (!leftOuter) {
            joinThis = new KTableKTableInnerJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableInnerJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        } else if (!rightOuter) {
            joinThis = new KTableKTableLeftJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableRightJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        } else {
            joinThis = new KTableKTableOuterJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableOuterJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        }
        KTableKTableJoinMerger<K, V> joinMerge = new KTableKTableJoinMerger<K, V>(new KTableImpl<K, S, V>(this.builder, joinThisName, joinThis, this.sourceNodes, this.queryableStoreName, false), new KTableImpl<K, S, V>(this.builder, joinOtherName, joinOther, ((KTableImpl)other).sourceNodes, ((KTableImpl)other).queryableStoreName, false), internalQueryableName);
        this.builder.internalTopologyBuilder.addProcessor(joinThisName, joinThis, this.name);
        this.builder.internalTopologyBuilder.addProcessor(joinOtherName, joinOther, ((KTableImpl)other).name);
        this.builder.internalTopologyBuilder.addProcessor(joinMergeName, joinMerge, joinThisName, joinOtherName);
        this.builder.internalTopologyBuilder.connectProcessorAndStateStores(joinThisName, ((KTableImpl)other).valueGetterSupplier().storeNames());
        this.builder.internalTopologyBuilder.connectProcessorAndStateStores(joinOtherName, this.valueGetterSupplier().storeNames());
        return new KTableImpl<K, S, V>(this.builder, joinMergeName, joinMerge, allSourceNodes, internalQueryableName, internalQueryableName != null);
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector) {
        return this.groupBy(selector, Serialized.with(null, null));
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector, Serialized<K1, V1> serialized) {
        Objects.requireNonNull(selector, "selector can't be null");
        Objects.requireNonNull(serialized, "serialized can't be null");
        String selectName = this.builder.newProcessorName(SELECT_NAME);
        KTableRepartitionMap<? super K, ? super V, K1, V1> selectSupplier = new KTableRepartitionMap<K, V, K1, V1>(this, selector);
        this.builder.internalTopologyBuilder.addProcessor(selectName, selectSupplier, this.name);
        this.enableSendingOldValues();
        SerializedInternal<K1, V1> serializedInternal = new SerializedInternal<K1, V1>(serialized);
        return new KGroupedTableImpl<K1, V1>(this.builder, selectName, this.name, serializedInternal.keySerde(), serializedInternal.valueSerde());
    }

    KTableValueGetterSupplier<K, V> valueGetterSupplier() {
        if (this.processorSupplier instanceof KTableSource) {
            KTableSource source = (KTableSource)this.processorSupplier;
            return new KTableSourceValueGetterSupplier(source.storeName);
        }
        if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
            return ((KStreamAggProcessorSupplier)this.processorSupplier).view();
        }
        return ((KTableProcessorSupplier)this.processorSupplier).view();
    }

    void enableSendingOldValues() {
        if (!this.sendOldValues) {
            if (this.processorSupplier instanceof KTableSource) {
                KTableSource source = (KTableSource)this.processorSupplier;
                source.enableSendingOldValues();
            } else if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
                ((KStreamAggProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            } else {
                ((KTableProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            }
            this.sendOldValues = true;
        }
    }

    boolean sendingOldValueEnabled() {
        return this.sendOldValues;
    }
}

