/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static final DeleteRecordsCommand$ MODULE$;
    private final int EarliestVersion;

    static {
        new DeleteRecordsCommand$();
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<JsonValue> option;
        block4: {
            Option<JsonValue> option2;
            block7: {
                int n;
                JsonValue js;
                block6: {
                    block5: {
                        option = Json$.MODULE$.parseFull(jsonData);
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        js = (JsonValue)some.x();
                        option2 = js.asJsonObject().get("version");
                        if (!(option2 instanceof Some)) break block5;
                        Some some2 = (Some)option2;
                        JsonValue jsonValue = (JsonValue)some2.x();
                        n = BoxesRunTime.unboxToInt((Object)jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    n = this.EarliestVersion();
                }
                int version = n;
                Seq<Tuple2<TopicPartition, Object>> seq = this.parseJsonData(version, js);
                return seq;
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseJsonData(int version, JsonValue js) {
        int n = version;
        switch (n) {
            default: {
                throw new AdminOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not supported version field value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
        }
        Option<JsonValue> option = js.asJsonObject().get("partitions");
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue partitions = (JsonValue)some.x();
            Buffer buffer = partitions.asJsonArray().iterator().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonObject apply(JsonValue x$1) {
                    return x$1.asJsonObject();
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Object> apply(JsonObject partitionJs) {
                    String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt((Object)partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    long offset2 = BoxesRunTime.unboxToLong((Object)partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToLong((long)offset2));
                }
            }).toBuffer();
            return buffer;
        }
        throw new AdminOperationException("Missing partitions field");
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String offsetJsonFile = (String)opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString((String)offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Traversable)offsetSeq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp;
                    TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
                    return topicPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
        }
        java.util.Map recordsToDelete = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)offsetSeq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, RecordsToDelete> apply(Tuple2<TopicPartition, Object> x0$2) {
                Tuple2<TopicPartition, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset2 = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)RecordsToDelete.beforeOffset((long)offset2));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        out.println("Executing records delete operation");
        DeleteRecordsResult deleteRecordsResult = adminClient.deleteRecords(recordsToDelete);
        out.println("Records delete operation completed:");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(deleteRecordsResult.lowWatermarks()).asScala()).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final PrintStream out$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<TopicPartition, KafkaFuture<DeletedRecords>> x0$3) {
                BoxedUnit boxedUnit;
                Tuple2<TopicPartition, KafkaFuture<DeletedRecords>> tuple2 = x0$3;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicPartition tp = (TopicPartition)tuple2._1();
                KafkaFuture partitionResult = (KafkaFuture)tuple2._2();
                try {
                    this.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\tlow_watermark: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToLong((long)((DeletedRecords)partitionResult.get()).lowWatermark())})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    this.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\terror: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, exception.getMessage()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                this.out$1 = out$1;
            }
        });
        adminClient.close();
    }

    private AdminClient createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient.create((Properties)props);
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
        this.EarliestVersion = 1;
    }
}

