/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventProcessor;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\tY\u0011+^3vK\u0012,e/\u001a8u\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u0005)QM^3oiV\t\u0011\u0003\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\ty1i\u001c8ue>dG.\u001a:Fm\u0016tG\u000f\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0012\u0003\u0019)g/\u001a8uA!A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0011$A\u0007f]F,X-^3US6,Wj]\u000b\u00025A\u0011\u0011bG\u0005\u00039)\u0011A\u0001T8oO\"Aa\u0004\u0001B\u0001B\u0003%!$\u0001\bf]F,X-^3US6,Wj\u001d\u0011\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\r\u00113\u0005\n\t\u0003%\u0001AQaD\u0010A\u0002EAQ\u0001G\u0010A\u0002iAqA\n\u0001C\u0002\u0013\u0005q%A\tqe>\u001cWm]:j]\u001e\u001cF/\u0019:uK\u0012,\u0012\u0001\u000b\t\u0003SAj\u0011A\u000b\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\tic&\u0001\u0003vi&d'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c)\u0012abQ8v]R$un\u001e8MCR\u001c\u0007\u000e\u0003\u00044\u0001\u0001\u0006I\u0001K\u0001\u0013aJ|7-Z:tS:<7\u000b^1si\u0016$\u0007\u0005C\u00046\u0001\t\u0007I\u0011\u0001\u001c\u0002\u000bM\u0004XM\u001c;\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0016\u0002\r\u0005$x.\\5d\u0013\ta\u0014HA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007}\u0001\u0001\u000b\u0011B\u001c\u0002\rM\u0004XM\u001c;!\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u001d\u0001(o\\2fgN$\"AQ#\u0011\u0005%\u0019\u0015B\u0001#\u000b\u0005\u0011)f.\u001b;\t\u000b\u0019{\u0004\u0019A$\u0002\u0013A\u0014xnY3tg>\u0014\bC\u0001\nI\u0013\tI%A\u0001\rD_:$(o\u001c7mKJ,e/\u001a8u!J|7-Z:t_JDQa\u0013\u0001\u0005\u00021\u000bq\u0001\u001d:fK6\u0004H\u000f\u0006\u0002C\u001b\")aI\u0013a\u0001\u000f\")q\n\u0001C\u0001!\u0006y\u0011m^1jiB\u0013xnY3tg&tw\rF\u0001C\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003!!xn\u0015;sS:<G#\u0001+\u0011\u0005UCfBA\u0005W\u0013\t9&\"\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,\u000b\u0001")
public class QueuedEvent {
    private final ControllerEvent event;
    private final long enqueueTimeMs;
    private final CountDownLatch processingStarted;
    private final AtomicBoolean spent;

    public ControllerEvent event() {
        return this.event;
    }

    public long enqueueTimeMs() {
        return this.enqueueTimeMs;
    }

    public CountDownLatch processingStarted() {
        return this.processingStarted;
    }

    public AtomicBoolean spent() {
        return this.spent;
    }

    public void process(ControllerEventProcessor processor) {
        if (this.spent().getAndSet(true)) {
            return;
        }
        this.processingStarted().countDown();
        processor.process(this.event());
    }

    public void preempt(ControllerEventProcessor processor) {
        if (this.spent().getAndSet(true)) {
            return;
        }
        processor.preempt(this.event());
    }

    public void awaitProcessing() {
        this.processingStarted().await();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"QueuedEvent(event=", ", enqueueTimeMs=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.event(), BoxesRunTime.boxToLong((long)this.enqueueTimeMs())}));
    }

    public QueuedEvent(ControllerEvent event, long enqueueTimeMs) {
        this.event = event;
        this.enqueueTimeMs = enqueueTimeMs;
        this.processingStarted = new CountDownLatch(1);
        this.spent = new AtomicBoolean(false);
    }
}

