/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkPartitionStateMachine$;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001\u001d\u0011qCW6QCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016D\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0007G>tg-[4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011AB:feZ,'/\u0003\u0002\u0014!\tY1*\u00194lC\u000e{gNZ5h\u0011!)\u0002A!A!\u0002\u00131\u0012!E:uCR,7\t[1oO\u0016dunZ4feB\u0011\u0011bF\u0005\u00031\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!Q\u0002A!A!\u0002\u0013Y\u0012!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011\u0011\u0002H\u0005\u0003;\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\"\u0011A\u0001>l\u0013\t)#EA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005a2m\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA\u0005*\u0013\tQ#A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\u0019qs\u0006M\u00193gA\u0011\u0011\u0002\u0001\u0005\u0006\u001b-\u0002\rA\u0004\u0005\u0006+-\u0002\rA\u0006\u0005\u00065-\u0002\ra\u0007\u0005\u0006?-\u0002\r\u0001\t\u0005\u0006O-\u0002\r\u0001\u000b\u0005\bk\u0001\u0011\r\u0011\"\u00037\u00031\u0019wN\u001c;s_2dWM]%e+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$aA%oi\"1a\b\u0001Q\u0001\n]\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003\"\u0002!\u0001\t\u0003\n\u0015A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$BA\u00111fUB!1IR%U\u001d\tAD)\u0003\u0002Fs\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\u00075\u000b\u0007O\u0003\u0002FsA\u0011!JU\u0007\u0002\u0017*\u0011A*T\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q%BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001eL!aU&\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011Q+\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014B\u0001/:\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0013QC'o\\<bE2,'B\u0001/:\u0011\u0015\tw\b1\u0001c\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004+\u000eL\u0015B\u00013`\u0005\r\u0019V-\u001d\u0005\u0006M~\u0002\raZ\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0002\nQ&\u0011\u0011N\u0001\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0015Yw\b1\u0001m\u0003\t\u0002\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_(qiB\u0019\u0001(\\8\n\u00059L$AB(qi&|g\u000e\u0005\u0002\na&\u0011\u0011O\u0001\u0002 !\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eL\b\"B:\u0001\t\u0013!\u0018A\u00049beRLG/[8o'R\fG/\u001a\u000b\u0003OVDQA\u001e:A\u0002%\u000b\u0011\u0002]1si&$\u0018n\u001c8\t\u000ba\u0004A\u0011B=\u0002)\u0011|\u0007*\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0011\u0011%p\u001f?\t\u000b\u0005<\b\u0019\u00012\t\u000b\u0019<\b\u0019A4\t\u000b-<\b\u0019\u00017\t\u000by\u0004A\u0011B@\u0002G%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8ogR\u0019!-!\u0001\t\u000b\u0005l\b\u0019\u00012\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u0005AR\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\r\u0005%\u0011qBA\t!\u0015A\u00141\u00022C\u0013\r\ti!\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\r\u0005\f\u0019\u00011\u0001c\u0011\u001d\t\u0019\"a\u0001A\u0002=\fq\u0004]1si&$\u0018n\u001c8MK\u0006$WM]#mK\u000e$\u0018n\u001c8TiJ\fG/Z4z\u0011\u001d\t9\u0002\u0001C\u0005\u00033\t!\u0004Z8FY\u0016\u001cG\u000fT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$b!a\u0007\u0002*\u0005-\u0002c\u0002\u001d\u0002\u001e\t\u0014\u0017\u0011E\u0005\u0004\u0003?I$A\u0002+va2,7\u0007E\u0003D\r&\u000b\u0019\u0003E\u0002V\u0003KI1!a\n`\u0005%)\u0005pY3qi&|g\u000e\u0003\u0004b\u0003+\u0001\rA\u0019\u0005\b\u0003'\t)\u00021\u0001p\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\t\u0011eY8mY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;bi\u0016$B!a\r\u0002FA!QkYA\u001b!!A\u0014QD%\u00028\u0005}\u0002\u0003\u0002\u001dn\u0003s\u00012!CA\u001e\u0013\r\tiD\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007a\n\t%C\u0002\u0002De\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002H\u00055\u0002\u0019AA%\u0003qaW-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQN\u0004B!V2\u0002LA1\u0001(a\u0003J\u0003sAq!a\u0014\u0001\t\u0013\t\t&\u0001\u000bm_\u001eLeN^1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u0007\u0003'\nI&a\u0017\u0011\u0007a\n)&C\u0002\u0002Xe\u0012A!\u00168ji\"1a/!\u0014A\u0002%CaAZA'\u0001\u00049\u0007bBA0\u0001\u0011%\u0011\u0011M\u0001\u0015Y><g)Y5mK\u0012\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\u0015\u0005M\u00131MA3\u0003S\nY\u0007\u0003\u0004w\u0003;\u0002\r!\u0013\u0005\b\u0003O\ni\u00061\u0001h\u0003%\u0019WO\u001d:Ti\u0006$X\r\u0003\u0004g\u0003;\u0002\ra\u001a\u0005\t\u0003[\ni\u00061\u0001\u0002p\u0005!1m\u001c3f!\u0011\t\t(a\"\u000f\t\u0005M\u0014\u0011\u0011\b\u0005\u0003k\niH\u0004\u0003\u0002x\u0005mdbA,\u0002z%\t\u0011+\u0003\u0002P!&\u0019\u0011q\u0010(\u0002\u0013i|wn[3fa\u0016\u0014\u0018\u0002BAB\u0003\u000b\u000bqbS3fa\u0016\u0014X\t_2faRLwN\u001c\u0006\u0004\u0003\u007fr\u0015\u0002BAE\u0003\u0017\u0013AaQ8eK*!\u00111QAC\u0011\u001d\ty\u0006\u0001C\u0005\u0003\u001f#\"\"a\u0015\u0002\u0012\u0006M\u0015QSAL\u0011\u00191\u0018Q\u0012a\u0001\u0013\"9\u0011qMAG\u0001\u00049\u0007B\u00024\u0002\u000e\u0002\u0007q\rC\u0004\u0002\u001a\u00065\u0005\u0019\u0001+\u0002\u0003Q\u0004")
public class ZkPartitionStateMachine
extends PartitionStateMachine {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    public final ControllerContext kafka$controller$ZkPartitionStateMachine$$controllerContext;
    private final KafkaZkClient zkClient;
    public final ControllerBrokerRequestBatch kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch;
    private final int kafka$controller$ZkPartitionStateMachine$$controllerId;

    public int kafka$controller$ZkPartitionStateMachine$$controllerId() {
        return this.kafka$controller$ZkPartitionStateMachine$$controllerId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<TopicPartition, Throwable> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Map map;
        if (!partitions.nonEmpty()) {
            map = Predef$.MODULE$.Map().empty();
            return map;
        }
        try {
            this.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.newBatch();
            Map errors = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
            this.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.sendRequestsToBrokers(this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
            map = errors;
            return map;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            map = ((TraversableOnce)partitions.map((Function1)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Tuple2<TopicPartition, Throwable> apply(TopicPartition x$1) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$1), (Object)this.e$2);
                }
                {
                    this.e$2 = e$2;
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            return map;
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller moved to another broker when moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$1;

                public final ControllerMovedException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw controllerMovedException;
        }
    }

    public PartitionState kafka$controller$ZkPartitionStateMachine$$partitionState(TopicPartition partition) {
        return this.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionState(partition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<TopicPartition, Throwable> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Tuple2 tuple2;
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final void apply(TopicPartition partition) {
                this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionStateIfNotExists(partition, NonExistentPartition$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Tuple2<Seq<TopicPartition>, Seq<TopicPartition>> tuple22 = this.kafka$controller$ZkPartitionStateMachine$$controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple22 == null) throw new MatchError(tuple22);
        Seq validPartitions = (Seq)tuple22._1();
        Seq invalidPartitions = (Seq)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)validPartitions, (Object)invalidPartitions);
        Seq validPartitions2 = (Seq)tuple23._1();
        Seq invalidPartitions2 = (Seq)tuple23._2();
        invalidPartitions2.foreach((Function1)new Serializable(this, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;
            private final PartitionState targetState$2;

            public final void apply(TopicPartition partition) {
                this.$outer.kafka$controller$ZkPartitionStateMachine$$logInvalidTransition(partition, this.targetState$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetState$2 = targetState$2;
            }
        });
        PartitionState partitionState = targetState;
        if (NewPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkPartitionStateMachine $outer;
                public final PartitionState targetState$2;
                private final StateChangeLogger stateChangeLog$1;

                public final void apply(TopicPartition partition) {
                    this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$doHandleStateChanges$3 $outer;
                        private final TopicPartition partition$4;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$4, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$4), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionReplicaAssignment(this.partition$4).mkString(",")}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$4 = partition$4;
                        }
                    });
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, NewPartition$.MODULE$);
                }

                public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$2 = targetState$2;
                    this.stateChangeLog$1 = stateChangeLog$1;
                }
            });
            return Predef$.MODULE$.Map().empty();
        }
        if (OnlinePartition$.MODULE$.equals(partitionState)) {
            Map map;
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkPartitionStateMachine $outer;

                public final boolean apply(TopicPartition partition) {
                    PartitionState partitionState = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                    NewPartition$ newPartition$ = NewPartition$.MODULE$;
                    return !(partitionState != null ? !partitionState.equals(newPartition$) : newPartition$ != null);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Seq partitionsToElectLeader = (Seq)validPartitions2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkPartitionStateMachine $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(TopicPartition partition) {
                    PartitionState partitionState = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    if (partitionState == null) {
                        if (offlinePartition$ == null) return true;
                    } else if (partitionState.equals(offlinePartition$)) return true;
                    PartitionState partitionState2 = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                    OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                    if (partitionState2 != null) {
                        if (!partitionState2.equals(onlinePartition$)) return false;
                        return true;
                    }
                    if (onlinePartition$ == null) return true;
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (uninitializedPartitions.nonEmpty()) {
                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                successfulInitializations.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                    public final PartitionState targetState$2;
                    private final StateChangeLogger stateChangeLog$1;

                    public final void apply(TopicPartition partition) {
                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$doHandleStateChanges$4 $outer;
                            private final TopicPartition partition$5;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$5, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$5), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().apply((Object)this.partition$5)).leaderAndIsr()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$5 = partition$5;
                            }
                        });
                        this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                    }

                    public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.stateChangeLog$1 = stateChangeLog$1;
                    }
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Tuple2 tuple24;
                Tuple2<Seq<TopicPartition>, Map<TopicPartition, Throwable>> tuple25 = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                if (tuple25 == null) throw new MatchError(tuple25);
                Seq successfulElections = (Seq)tuple25._1();
                Map failedElections = (Map)tuple25._2();
                Tuple2 tuple26 = tuple24 = new Tuple2((Object)successfulElections, (Object)failedElections);
                Seq successfulElections2 = (Seq)tuple26._1();
                Map failedElections2 = (Map)tuple26._2();
                successfulElections2.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                    public final PartitionState targetState$2;
                    private final StateChangeLogger stateChangeLog$1;

                    public final void apply(TopicPartition partition) {
                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$doHandleStateChanges$5 $outer;
                            private final TopicPartition partition$6;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$6, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$6), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().apply((Object)this.partition$6)).leaderAndIsr()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$6 = partition$6;
                            }
                        });
                        this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                    }

                    public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.stateChangeLog$1 = stateChangeLog$1;
                    }
                });
                map = failedElections2;
                return map;
            } else {
                map = Predef$.MODULE$.Map().empty();
            }
            return map;
        }
        if (OfflinePartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkPartitionStateMachine $outer;
                public final PartitionState targetState$2;
                private final StateChangeLogger stateChangeLog$1;

                public final void apply(TopicPartition partition) {
                    this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$doHandleStateChanges$6 $outer;
                        private final TopicPartition partition$7;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$7, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$7), this.$outer.targetState$2}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$7 = partition$7;
                        }
                    });
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, OfflinePartition$.MODULE$);
                }

                public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$2 = targetState$2;
                    this.stateChangeLog$1 = stateChangeLog$1;
                }
            });
            return Predef$.MODULE$.Map().empty();
        }
        if (!NonExistentPartition$.MODULE$.equals(partitionState)) throw new MatchError((Object)partitionState);
        validPartitions2.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;
            public final PartitionState targetState$2;
            private final StateChangeLogger stateChangeLog$1;

            public final void apply(TopicPartition partition) {
                this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$doHandleStateChanges$7 $outer;
                    private final TopicPartition partition$8;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$8, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$8), this.$outer.targetState$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition$8 = partition$8;
                    }
                });
                this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, NonExistentPartition$.MODULE$);
            }

            public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetState$2 = targetState$2;
                this.stateChangeLog$1 = stateChangeLog$1;
            }
        });
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var2_2;
        Seq seq;
        Tuple2 tuple22;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final Tuple2<TopicPartition, Seq<Object>> apply(TopicPartition partition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;
                        private final TopicPartition partition$1;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$1, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Seq<Object>> x0$2) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Seq liveReplicas = (Seq)tuple2._2();
                    boolean bl = liveReplicas.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas2);
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$3) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error during state change of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " from New to Online, assigned replicas are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "], live brokers are [", "]. No assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(","), this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.liveBrokerIds()}))).append((Object)"replica is alive.").toString();
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicPartition, Seq<Object>> x0$4) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq liveReplicas = (Seq)tuple2._2();
                    LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epochZkVersion());
        }
        catch (Exception exception) {
            partitionsWithLiveReplicas.foreach((Function1)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkPartitionStateMachine $outer;
                private final Exception e$4;

                public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$5) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$5;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition), (PartitionState)NewPartition$.MODULE$, this.e$4);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.e$4 = e$4;
                }
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller moved to another broker when trying to create the topic partition state znode";
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$3;

                public final ControllerMovedException apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = e$3;
                }
            });
            throw controllerMovedException;
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1)new Serializable(this, successfulInitializations, leaderIsrAndControllerEpochs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;
            private final Buffer successfulInitializations$1;
            private final Map leaderIsrAndControllerEpochs$1;

            public final Object apply(CreateResponse createResponse2) {
                BoxedUnit boxedUnit;
                KeeperException.Code code = createResponse2.resultCode();
                TopicPartition partition = (TopicPartition)createResponse2.ctx().get();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)this.leaderIsrAndControllerEpochs$1.apply((Object)partition);
                KeeperException.Code code2 = code;
                KeeperException.Code code3 = KeeperException.Code.OK;
                if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition), true);
                    boxedUnit = this.successfulInitializations$1.$plus$eq((Object)partition);
                } else {
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulInitializations$1 = successfulInitializations$1;
                this.leaderIsrAndControllerEpochs$1 = leaderIsrAndControllerEpochs$1;
            }
        });
        return var2_2;
    }

    private Tuple2<Seq<TopicPartition>, Map<TopicPartition, Throwable>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Buffer successfulElections = (Buffer)Buffer$.MODULE$.empty();
        Seq remaining = partitions;
        Map failures = Predef$.MODULE$.Map().empty();
        while (remaining.nonEmpty()) {
            Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple3 = this.doElectLeaderForPartitions(partitions, partitionLeaderElectionStrategy);
            if (tuple3 != null) {
                Tuple3 tuple32;
                Seq success = (Seq)tuple3._1();
                Seq updatesToRetry = (Seq)tuple3._2();
                Map failedElections = (Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)success, (Object)updatesToRetry, (Object)failedElections);
                Seq success2 = (Seq)tuple33._1();
                Seq updatesToRetry2 = (Seq)tuple33._2();
                Map failedElections2 = (Map)tuple33._3();
                remaining = updatesToRetry2;
                successfulElections.$plus$plus$eq((TraversableOnce)success2);
                failedElections2.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ZkPartitionStateMachine $outer;

                    public final void apply(Tuple2<TopicPartition, Exception> x0$6) {
                        Tuple2<TopicPartition, Exception> tuple2 = x0$6;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            Exception e = (Exception)tuple2._2();
                            this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                failures = failures.$plus$plus((GenTraversableOnce)failedElections2);
                continue;
            }
            throw new MatchError(tuple3);
        }
        return new Tuple2((Object)successfulElections, (Object)failures);
    }

    private Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, Map<TopicPartition, Exception>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        block8: {
            PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2;
            block13: {
                Tuple2 tuple22;
                scala.collection.mutable.Map failedElections;
                block10: {
                    Buffer validPartitionsForElection;
                    block12: {
                        block11: {
                            block9: {
                                Tuple2 tuple23;
                                Seq<GetDataResponse> getDataResponses;
                                try {
                                    getDataResponses = this.zkClient.getTopicPartitionStatesRaw(partitions);
                                }
                                catch (Exception exception) {
                                    return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)((TraversableOnce)partitions.map((Function1)new Serializable(this, exception){
                                        public static final long serialVersionUID = 0L;
                                        private final Exception e$5;

                                        public final Tuple2<TopicPartition, Exception> apply(TopicPartition x$6) {
                                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$6), (Object)this.e$5);
                                        }
                                        {
                                            this.e$5 = e$5;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                                }
                                failedElections = Map$.MODULE$.empty();
                                Buffer leaderIsrAndControllerEpochPerPartition = (Buffer)Buffer$.MODULE$.empty();
                                getDataResponses.foreach((Function1)new Serializable(this, failedElections, leaderIsrAndControllerEpochPerPartition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                                    private final scala.collection.mutable.Map failedElections$1;
                                    private final Buffer leaderIsrAndControllerEpochPerPartition$1;

                                    public final Object apply(GetDataResponse getDataResponse) {
                                        Option option;
                                        TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
                                        PartitionState currState = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                                        KeeperException.Code code = getDataResponse.resultCode();
                                        KeeperException.Code code2 = KeeperException.Code.OK;
                                        if (!(code != null ? !code.equals(code2) : code2 != null)) {
                                            BoxedUnit boxedUnit;
                                            Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                                            if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                                                StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                                                boxedUnit = this.failedElections$1.put((Object)partition, (Object)exception);
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            option = this.leaderIsrAndControllerEpochPerPartition$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderIsrAndControllerEpochOpt.get()));
                                        } else {
                                            KeeperException.Code code3 = getDataResponse.resultCode();
                                            KeeperException.Code code4 = KeeperException.Code.NONODE;
                                            if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                                                StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                                                option = this.failedElections$1.put((Object)partition, (Object)exception);
                                            } else {
                                                option = this.failedElections$1.put((Object)partition, getDataResponse.resultException().get());
                                            }
                                        }
                                        return option;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.failedElections$1 = failedElections$1;
                                        this.leaderIsrAndControllerEpochPerPartition$1 = leaderIsrAndControllerEpochPerPartition$1;
                                    }
                                });
                                tuple2 = leaderIsrAndControllerEpochPerPartition.partition((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;

                                    public final boolean apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$7) {
                                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$7;
                                        if (tuple2 != null) {
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                                            boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch();
                                            return bl;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                if (tuple2 == null) break block8;
                                Buffer invalidPartitionsForElection = (Buffer)tuple2._1();
                                Buffer validPartitionsForElection2 = (Buffer)tuple2._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection2);
                                Buffer invalidPartitionsForElection2 = (Buffer)tuple24._1();
                                validPartitionsForElection = (Buffer)tuple24._2();
                                invalidPartitionsForElection2.foreach((Function1)new Serializable(this, failedElections){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                                    private final scala.collection.mutable.Map failedElections$1;

                                    public final Option<Exception> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$8) {
                                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$8;
                                        if (tuple2 != null) {
                                            TopicPartition partition = (TopicPartition)tuple2._1();
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                                            String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborted leader election for partition ", " since the LeaderAndIsr path was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already written by another controller. This probably means that the current controller ", " went through "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a soft failure and another controller was elected with epoch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString();
                                            Option option = this.failedElections$1.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
                                            return option;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.failedElections$1 = failedElections$1;
                                    }
                                });
                                if (validPartitionsForElection.isEmpty()) {
                                    return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)failedElections.toMap(Predef$.MODULE$.$conforms()));
                                }
                                partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
                                if (!OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block9;
                                Seq<Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object>> partitionsWithUncleanLeaderElectionState = this.collectUncleanLeaderElectionState((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection);
                                tuple22 = Election$.MODULE$.leaderForOffline(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, partitionsWithUncleanLeaderElectionState).partition((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(ElectionResult x$8) {
                                        return x$8.leaderAndIsr().isEmpty();
                                    }
                                });
                                break block10;
                            }
                            if (!ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block11;
                            tuple22 = Election$.MODULE$.leaderForReassign(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, (Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection).partition((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(ElectionResult x$9) {
                                    return x$9.leaderAndIsr().isEmpty();
                                }
                            });
                            break block10;
                        }
                        if (!PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block12;
                        tuple22 = Election$.MODULE$.leaderForPreferredReplica(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, (Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection).partition((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(ElectionResult x$10) {
                                return x$10.leaderAndIsr().isEmpty();
                            }
                        });
                        break block10;
                    }
                    if (!ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block13;
                    tuple22 = Election$.MODULE$.leaderForControlledShutdown(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, (Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection).partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ElectionResult x$11) {
                            return x$11.leaderAndIsr().isEmpty();
                        }
                    });
                }
                Tuple2 tuple25 = tuple22;
                if (tuple25 != null) {
                    Tuple2 tuple26;
                    Seq partitionsWithoutLeaders = (Seq)tuple25._1();
                    Seq partitionsWithLeaders = (Seq)tuple25._2();
                    Tuple2 tuple27 = tuple26 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
                    Seq partitionsWithoutLeaders2 = (Seq)tuple27._1();
                    Seq partitionsWithLeaders2 = (Seq)tuple27._2();
                    partitionsWithoutLeaders2.foreach((Function1)new Serializable(this, partitionLeaderElectionStrategy, failedElections){
                        public static final long serialVersionUID = 0L;
                        private final PartitionLeaderElectionStrategy partitionLeaderElectionStrategy$1;
                        private final scala.collection.mutable.Map failedElections$1;

                        public final Option<Exception> apply(ElectionResult electionResult) {
                            TopicPartition partition = electionResult.topicPartition();
                            String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to elect leader for partition ", " under strategy ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, this.partitionLeaderElectionStrategy$1}));
                            return this.failedElections$1.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
                        }
                        {
                            this.partitionLeaderElectionStrategy$1 = partitionLeaderElectionStrategy$1;
                            this.failedElections$1 = failedElections$1;
                        }
                    });
                    Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, Seq<Object>> apply(ElectionResult result) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.liveReplicas());
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, LeaderAndIsr> apply(ElectionResult result) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.leaderAndIsr().get());
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch(), this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epochZkVersion());
                    if (updateLeaderAndIsrResult != null) {
                        Tuple3 tuple3;
                        Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
                        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
                        Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
                        Tuple3 tuple32 = tuple3 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
                        Map successfulUpdates2 = (Map)tuple32._1();
                        Seq updatesToRetry2 = (Seq)tuple32._2();
                        Map failedUpdates2 = (Map)tuple32._3();
                        successfulUpdates2.foreach((Function1)new Serializable(this, recipientsPerPartition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ZkPartitionStateMachine $outer;
                            private final Map recipientsPerPartition$1;

                            public final void apply(Tuple2<TopicPartition, LeaderAndIsr> x0$9) {
                                Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$9;
                                if (tuple2 != null) {
                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                    Seq<Object> replicas = this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
                                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)this.recipientsPerPartition$1.apply((Object)partition)), partition, leaderIsrAndControllerEpoch, replicas, false);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.recipientsPerPartition$1 = recipientsPerPartition$1;
                            }
                        });
                        return new Tuple3((Object)successfulUpdates2.keys().toSeq(), (Object)updatesToRetry2, (Object)failedElections.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedUpdates2));
                    }
                    throw new MatchError((Object)updateLeaderAndIsrResult);
                }
                throw new MatchError((Object)tuple25);
            }
            throw new MatchError((Object)partitionLeaderElectionStrategy2);
        }
        throw new MatchError((Object)tuple2);
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object>> collectUncleanLeaderElectionState(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Tuple2 tuple2 = leaderIsrAndControllerEpochs.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final boolean apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$10) {
                Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$10;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    List liveInSyncReplicas = (List)leaderIsrAndControllerEpoch.leaderAndIsr().isr().filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$22 $outer;
                        private final TopicPartition partition$3;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$3, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$3 = partition$3;
                        }
                    });
                    boolean bl = liveInSyncReplicas.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
            Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas, (Object)partitionsWithLiveInSyncReplicas);
            Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple23._1();
            Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple23._2();
            Tuple2<Map<String, LogConfig>, Map<String, Exception>> tuple24 = this.zkClient.getLogConfigs((Seq<String>)((Seq)partitionsWithNoLiveInSyncReplicas2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$11) {
                    Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$11;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        String string = partition.topic();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())), this.config.originals());
            if (tuple24 != null) {
                Tuple2 tuple25;
                Map logConfigs = (Map)tuple24._1();
                Map failed = (Map)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)logConfigs, (Object)failed);
                Map logConfigs2 = (Map)tuple26._1();
                Map failed2 = (Map)tuple26._2();
                return (Seq)((TraversableLike)partitionsWithNoLiveInSyncReplicas2.map((Function1)new Serializable(this, logConfigs2, failed2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                    private final Map logConfigs$1;
                    private final Map failed$1;

                    public final Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$12) {
                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$12;
                        if (tuple2 != null) {
                            Tuple3 tuple3;
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                            if (this.failed$1.contains((Object)partition.topic())) {
                                this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)this.failed$1.apply((Object)partition.topic()));
                                tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            } else {
                                tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)((Object)this.logConfigs$1.apply((Object)partition.topic()))).uncleanLeaderElectionEnable()));
                            }
                            Tuple3 tuple32 = tuple3;
                            return tuple32;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logConfigs$1 = logConfigs$1;
                        this.failed$1 = failed$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$13) {
                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$13;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            return tuple3;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public void kafka$controller$ZkPartitionStateMachine$$logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = this.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should be in one of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " states before moving to ", " state. Instead it is in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState.validPreviousStates().mkString(","), targetState}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState}))).toString());
        this.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, currState, targetState, e);
    }

    public void kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    public void kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch()).error((Function0<String>)new Serializable(this, partition, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;
            private final TopicPartition partition$2;
            private final PartitionState currState$1;
            private final PartitionState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " failed to change state for partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch()), this.partition$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currState$1, this.targetState$3}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
                this.currState$1 = currState$1;
                this.targetState$3 = targetState$3;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public ZkPartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.kafka$controller$ZkPartitionStateMachine$$controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.kafka$controller$ZkPartitionStateMachine$$controllerId = config.brokerId();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[PartitionStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$ZkPartitionStateMachine$$controllerId())})));
    }
}

