/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.LazyOffsetIndex;
import kafka.log.LazyTimeIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.LogSegment$$anonfun$recover$1$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011ua\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005yA.\u0019>z\u001f\u001a47/\u001a;J]\u0012,\u00070F\u0001)!\tI#&D\u0001\u0003\u0013\tY#AA\bMCjLxJ\u001a4tKRLe\u000eZ3y\u0011!i\u0003A!A!\u0002\u0013A\u0013\u0001\u00057buf|eMZ:fi&sG-\u001a=!\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0014!\u00047buf$\u0016.\\3J]\u0012,\u00070F\u00012!\tI#'\u0003\u00024\u0005\tiA*\u0019>z)&lW-\u00138eKbD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I!M\u0001\u000fY\u0006T\u0018\u0010V5nK&sG-\u001a=!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001\u0003;y]&sG-\u001a=\u0016\u0003e\u0002\"!\u000b\u001e\n\u0005m\u0012!\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0011!i\u0004A!A!\u0002\u0013I\u0014!\u0003;y]&sG-\u001a=!\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0015A\u00032bg\u0016|eMZ:fiV\t\u0011\t\u0005\u0002\n\u0005&\u00111I\u0003\u0002\u0005\u0019>tw\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003B\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011\u001d\u0003!Q1A\u0005\u0002!\u000b!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\t\u0011\n\u0005\u0002\n\u0015&\u00111J\u0003\u0002\u0004\u0013:$\b\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B%\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\t\u0011=\u0003!Q1A\u0005\u0002\u0001\u000bAB]8mY*KG\u000f^3s\u001bND\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000ee>dGNS5ui\u0016\u0014Xj\u001d\u0011\t\u0011M\u0003!Q1A\u0005\u0002Q\u000bA\u0001^5nKV\tQ\u000b\u0005\u0002W16\tqK\u0003\u0002\u00125%\u0011\u0011l\u0016\u0002\u0005)&lW\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003V\u0003\u0015!\u0018.\\3!\u0011\u0019i\u0006\u0001\"\u0001\u0003=\u00061A(\u001b8jiz\"\u0012b\u00181bE\u000e$WMZ4\u0011\u0005%\u0002\u0001\"B\u0002]\u0001\u00041\u0002\"\u0002\u0014]\u0001\u0004A\u0003\"B\u0018]\u0001\u0004\t\u0004\"B\u001c]\u0001\u0004I\u0004\"B ]\u0001\u0004\t\u0005\"B$]\u0001\u0004I\u0005\"B(]\u0001\u0004\t\u0005\"B*]\u0001\u0004)\u0006\"B5\u0001\t\u0003Q\u0017aC8gMN,G/\u00138eKb,\u0012a\u001b\t\u0003S1L!!\u001c\u0002\u0003\u0017=3gm]3u\u0013:$W\r\u001f\u0005\u0006_\u0002!\t\u0001]\u0001\ni&lW-\u00138eKb,\u0012!\u001d\t\u0003SIL!a\u001d\u0002\u0003\u0013QKW.Z%oI\u0016D\b\"B;\u0001\t\u00031\u0018AC:i_VdGMU8mYR\u0011qO\u001f\t\u0003\u0013aL!!\u001f\u0006\u0003\u000f\t{w\u000e\\3b]\")1\u0010\u001ea\u0001y\u0006Q!o\u001c7m!\u0006\u0014\u0018-\\:\u0011\u0005%j\u0018B\u0001@\u0003\u0005)\u0011v\u000e\u001c7QCJ\fWn\u001d\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u00035\u0011Xm]5{K&sG-\u001a=fgR!\u0011QAA\u0006!\rI\u0011qA\u0005\u0004\u0003\u0013Q!\u0001B+oSRDa!!\u0004\u0000\u0001\u0004I\u0015\u0001B:ju\u0016Dq!!\u0005\u0001\t\u0003\t\u0019\"A\u0006tC:LG/_\"iK\u000e\\G\u0003BA\u0003\u0003+Aq!a\u0006\u0002\u0010\u0001\u0007q/A\ruS6,\u0017J\u001c3fq\u001aKG.\u001a(fo2L8I]3bi\u0016$\u0007\u0002CA\u000e\u0001\u0001\u0007I\u0011\u0002!\u0002\u000f\r\u0014X-\u0019;fI\"I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011E\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005\r\u0002\"CA\u0013\u0003;\t\t\u00111\u0001B\u0003\rAH%\r\u0005\b\u0003S\u0001\u0001\u0015)\u0003B\u0003!\u0019'/Z1uK\u0012\u0004\u0003\u0002CA\u0017\u0001\u0001\u0007I\u0011\u0002%\u00021\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018\u0010C\u0005\u00022\u0001\u0001\r\u0011\"\u0003\u00024\u0005a\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=`I\u0015\fH\u0003BA\u0003\u0003kA\u0011\"!\n\u00020\u0005\u0005\t\u0019A%\t\u000f\u0005e\u0002\u0001)Q\u0005\u0013\u0006I\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=!\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty$A\u000bs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9\u0016\u0005\u0005\u0005\u0003\u0003B\u0005\u0002D\u0005K1!!\u0012\u000b\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011\n\u0001A\u0002\u0013%\u00111J\u0001\u001ae>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u00055\u0003BCA\u0013\u0003\u000f\n\t\u00111\u0001\u0002B!A\u0011\u0011\u000b\u0001!B\u0013\t\t%\u0001\fs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9!Q\u0011\ty%!\u0016\u0011\u0007%\t9&C\u0002\u0002Z)\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003;\u0002\u0001\u0019!C\u0005\u0003\u007f\t!cX7bqRKW.Z:uC6\u00048k\u001c$be\"I\u0011\u0011\r\u0001A\u0002\u0013%\u00111M\u0001\u0017?6\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR!\u0011QAA3\u0011)\t)#a\u0018\u0002\u0002\u0003\u0007\u0011\u0011\t\u0005\t\u0003S\u0002\u0001\u0015)\u0003\u0002B\u0005\u0019r,\\1y)&lWm\u001d;b[B\u001cvNR1sA!\"\u0011qMA+\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\nQ#\\1y)&lWm\u001d;b[B\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005M\u0004bBA;\u0003[\u0002\r!Q\u0001\ni&lWm\u001d;b[BDa!!\u001f\u0001\t\u0003\u0001\u0015!E7bqRKW.Z:uC6\u00048k\u001c$be\"I\u0011Q\u0010\u0001A\u0002\u0013%\u0011qH\u0001\u001b?>4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q'>4\u0015M\u001d\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007\u000badX8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ|F%Z9\u0015\t\u0005\u0015\u0011Q\u0011\u0005\u000b\u0003K\ty(!AA\u0002\u0005\u0005\u0003\u0002CAE\u0001\u0001\u0006K!!\u0011\u00027}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:!Q\u0011\t9)!\u0016\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006irN\u001a4tKR|e-T1y)&lWm\u001d;b[B\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005M\u0005bBAK\u0003\u001b\u0003\r!Q\u0001\u0007_\u001a47/\u001a;\t\r\u0005e\u0005\u0001\"\u0001A\u0003eygMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\t\r\u00055\u0001\u0001\"\u0001I\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000b!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$2a^AR\u0011\u001d\t)*!(A\u0002\u0005Cq!a*\u0001\t\u0003\tI+\u0001\u0004baB,g\u000e\u001a\u000b\u000b\u0003\u000b\tY+a,\u00024\u0006]\u0006bBAW\u0003K\u0003\r!Q\u0001\u000eY\u0006\u0014x-Z:u\u001f\u001a47/\u001a;\t\u000f\u0005E\u0016Q\u0015a\u0001\u0003\u0006\u0001B.\u0019:hKN$H+[7fgR\fW\u000e\u001d\u0005\b\u0003k\u000b)\u000b1\u0001B\u0003m\u0019\b.\u00197m_^|eMZ:fi>3W*\u0019=US6,7\u000f^1na\"A\u0011\u0011XAS\u0001\u0004\tY,A\u0004sK\u000e|'\u000fZ:\u0011\u0007]\ti,C\u0002\u0002@b\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0006BAS\u0003\u0007\u00042aDAc\u0013\r\t9\r\u0005\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u0011QAAh\u0011\u001d\t)*!3A\u0002\u0005Cq!a5\u0001\t\u0013\t).A\nbaB,g\u000eZ\"ik:\\gI]8n\r&dW\rF\u0004J\u0003/\fI.!8\t\u000f\u0005e\u0016\u0011\u001ba\u0001-!9\u00111\\Ai\u0001\u0004I\u0015\u0001\u00039pg&$\u0018n\u001c8\t\u0011\u0005}\u0017\u0011\u001ba\u0001\u0003C\faBY;gM\u0016\u00148+\u001e9qY&,'\u000fE\u0002\u0018\u0003GL1!!:\u0019\u00059\u0011UO\u001a4feN+\b\u000f\u001d7jKJDq!!;\u0001\t\u0003\tY/\u0001\bbaB,g\u000e\u001a$s_64\u0015\u000e\\3\u0015\u000b%\u000bi/a<\t\u000f\u0005e\u0016q\u001da\u0001-!9\u0011\u0011_At\u0001\u0004I\u0015!B:uCJ$\bbBA{\u0001\u0011\u0005\u0011q_\u0001\u000fkB$\u0017\r^3Uq:Le\u000eZ3y)\u0019\t)!!?\u0003\u0004!A\u00111`Az\u0001\u0004\ti0\u0001\u0007d_6\u0004H.\u001a;fIRCh\u000eE\u0002*\u0003\u007fL1A!\u0001\u0003\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0011\u001d\u0011)!a=A\u0002\u0005\u000b\u0001\u0003\\1tiN#\u0018M\u00197f\u001f\u001a47/\u001a;)\t\u0005M\u00181\u0019\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0003M)\b\u000fZ1uKB\u0013x\u000eZ;dKJ\u001cF/\u0019;f)\u0019\t)Aa\u0004\u0003\u001a!A!\u0011\u0003B\u0005\u0001\u0004\u0011\u0019\"\u0001\u000bqe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\t\u0004S\tU\u0011b\u0001B\f\u0005\t!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJD\u0001Ba\u0007\u0003\n\u0001\u0007!QD\u0001\u0006E\u0006$8\r\u001b\t\u0004/\t}\u0011b\u0001B\u00111\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011!\u0011)\u0003\u0001C\u0001\u0005\t\u001d\u0012a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\t%\"\u0011\u000bB*!\u0011\u0011YCa\u0013\u000f\t\t5\"q\t\b\u0005\u0005_\u0011)E\u0004\u0003\u00032\t\rc\u0002\u0002B\u001a\u0005\u0003rAA!\u000e\u0003@9!!q\u0007B\u001f\u001b\t\u0011IDC\u0002\u0003<\u0019\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005yy\u0012BA\u0003\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0019!\u0011\n\r\u0002\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0005\u0005\u0005\u001b\u0012yEA\tM_\u001e|eMZ:fiB{7/\u001b;j_:T1A!\u0013\u0019\u0011\u001d\t)Ja\tA\u0002\u0005C\u0011B!\u0016\u0003$A\u0005\t\u0019A%\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\u0011\u0011\u0019C!\u0017\u0011\u0007=\u0011Y&C\u0002\u0003^A\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005G\nAA]3bIRa!Q\rB9\u0005k\u0012IH! \u0003\u0002B!!q\rB7\u001b\t\u0011IGC\u0002\u0003l\u0011\taa]3sm\u0016\u0014\u0018\u0002\u0002B8\u0005S\u0012QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002B:\u0005?\u0002\r!Q\u0001\fgR\f'\u000f^(gMN,G\u000f\u0003\u0005\u0003x\t}\u0003\u0019AA!\u0003%i\u0017\r_(gMN,G\u000fC\u0004\u0003|\t}\u0003\u0019A%\u0002\u000f5\f\u0007pU5{K\"I!q\u0010B0!\u0003\u0005\r!Q\u0001\f[\u0006D\bk\\:ji&|g\u000eC\u0005\u0003\u0004\n}\u0003\u0013!a\u0001o\u0006iQ.\u001b8P]\u0016lUm]:bO\u0016DCAa\u0018\u0003Z!9!\u0011\u0012\u0001\u0005\u0002\t-\u0015!\u00064fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u000b\u0007\u0003\u0003\u0012iIa&\t\u0011\t=%q\u0011a\u0001\u0005#\u000b1c\u001d;beR|eMZ:fiB{7/\u001b;j_:\u00042!\u000bBJ\u0013\r\u0011)J\u0001\u0002\u000f\u001f\u001a47/\u001a;Q_NLG/[8o\u0011\u001d\u0011IJa\"A\u0002%\u000b\u0011BZ3uG\"\u001c\u0016N_3\t\u000f\tu\u0005\u0001\"\u0001\u0003 \u00069!/Z2pm\u0016\u0014H#B%\u0003\"\n\r\u0006\u0002\u0003B\t\u00057\u0003\rAa\u0005\t\u0015\t\u0015&1\u0014I\u0001\u0002\u0004\u00119+\u0001\tmK\u0006$WM]#q_\u000eD7)Y2iKB)\u0011\"a\u0011\u0003*B!!1\u0016BY\u001b\t\u0011iK\u0003\u0003\u00030\n%\u0014!B3q_\u000eD\u0017\u0002\u0002BZ\u0005[\u0013A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",\u0007\u0006\u0002BN\u0003\u0007DqA!/\u0001\t\u0013\u0011Y,\u0001\u000bm_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e\u001d\u000b\u0003\u0003\u000bAqAa0\u0001\t\u0003\u0011\t-A\u0006iCN|e/\u001a:gY><X#A<\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\u0006\u00112m\u001c7mK\u000e$\u0018IY8si\u0016$G\u000b\u001f8t)\u0019\u0011IMa4\u0003TB\u0019\u0011Fa3\n\u0007\t5'A\u0001\u000bUq:Le\u000eZ3y'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\b\u0005#\u0014\u0019\r1\u0001B\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\tU'1\u0019a\u0001\u0003\u0006\u0001R\u000f\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u00053\u0004A\u0011\tBn\u0003!!xn\u0015;sS:<GC\u0001Bo!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\fA\u0001\\1oO*\u0011!q]\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003l\n\u0005(AB*ue&tw\rC\u0004\u0003p\u0002!\tA!=\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000eF\u0002J\u0005gDq!!&\u0003n\u0002\u0007\u0011\t\u000b\u0003\u0003n\u0006\r\u0007B\u0002B}\u0001\u0011\u0005\u0001)\u0001\bsK\u0006$g*\u001a=u\u001f\u001a47/\u001a;)\t\t](\u0011\f\u0005\b\u0005\u007f\u0004A\u0011\u0001B^\u0003\u00151G.^:iQ\u0011\u0011iP!\u0017\t\u000f\r\u0015\u0001\u0001\"\u0001\u0004\b\u0005IQ\u000f\u001d3bi\u0016$\u0015N\u001d\u000b\u0005\u0003\u000b\u0019I\u0001\u0003\u0005\u0004\f\r\r\u0001\u0019AB\u0007\u0003\r!\u0017N\u001d\t\u0005\u0007\u001f\u0019)\"\u0004\u0002\u0004\u0012)!11\u0003Bs\u0003\tIw.\u0003\u0003\u0004\u0018\rE!\u0001\u0002$jY\u0016Dqaa\u0007\u0001\t\u0003\u0019i\"\u0001\ndQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001cHCBA\u0003\u0007?\u0019y\u0003\u0003\u0005\u0004\"\re\u0001\u0019AB\u0012\u0003%yG\u000eZ*vM\u001aL\u0007\u0010\u0005\u0003\u0004&\r-bbA\u0005\u0004(%\u00191\u0011\u0006\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011Yo!\f\u000b\u0007\r%\"\u0002\u0003\u0005\u00042\re\u0001\u0019AB\u0012\u0003%qWm^*vM\u001aL\u0007\u0010C\u0004\u00046\u0001!\tAa/\u0002/=t')Z2p[\u0016Le.Y2uSZ,7+Z4nK:$\bbBB\u001d\u0001\u0011%!1X\u0001\u0018Y>\fGMR5sgR\u0014\u0015\r^2i)&lWm\u001d;b[BDqa!\u0010\u0001\t\u0003\u0019y$A\tuS6,w+Y5uK\u00124uN\u001d*pY2$R!QB!\u0007\u000bBqaa\u0011\u0004<\u0001\u0007\u0011)A\u0002o_^Dqaa\u0012\u0004<\u0001\u0007\u0011)\u0001\tnKN\u001c\u0018mZ3US6,7\u000f^1na\"911\n\u0001\u0005\u0002\r5\u0013AF4fi\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0015\u0003\u0005Cqa!\u0015\u0001\t\u0003\u0019\u0019&A\u000bgS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\r\rU3QLB0!\u0015I\u00111IB,!\u0011\u0011Yc!\u0017\n\t\rm#q\n\u0002\u0013)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0002v\r=\u0003\u0019A!\t\u0013\r\u00054q\nI\u0001\u0002\u0004\t\u0015AD:uCJ$\u0018N\\4PM\u001a\u001cX\r\u001e\u0005\b\u0007K\u0002A\u0011\u0001B^\u0003\u0015\u0019Gn\\:f\u0011\u001d\u0019I\u0007\u0001C\u0001\u0005w\u000bQb\u00197pg\u0016D\u0015M\u001c3mKJ\u001c\bbBB7\u0001\u0011\u0005!1X\u0001\u000fI\u0016dW\r^3JM\u0016C\u0018n\u001d;t\u0011\u0019\u0019\t\b\u0001C\u0001\u0001\u0006aA.Y:u\u001b>$\u0017NZ5fI\"1\u0011\u0011\u0017\u0001\u0005\u0002\u0001Cqaa\u001e\u0001\t\u0003\u0019I(\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR!11PBF!\u0011\u0019iha\"\u000e\u0005\r}$\u0002BBA\u0007\u0007\u000bAAZ5mK*!1Q\u0011Bs\u0003\rq\u0017n\\\u0005\u0005\u0007\u0013\u001byH\u0001\u0003QCRD\u0007bBBG\u0007k\u0002\r!Q\u0001\u0003[ND\u0011b!%\u0001#\u0003%\taa%\u0002#I,7m\u001c<fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u0016*\"!qUBLW\t\u0019I\n\u0005\u0003\u0004\u001c\u000e\u0015VBABO\u0015\u0011\u0019yj!)\u0002\u0013Ut7\r[3dW\u0016$'bABR\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001d6Q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CBV\u0001E\u0005I\u0011ABW\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"aa,+\u0007\u0005\u001b9\nC\u0005\u00044\u0002\t\n\u0011\"\u0001\u00046\u0006q!/Z1eI\u0011,g-Y;mi\u0012*TCAB\\U\r98q\u0013\u0005\n\u0007w\u0003\u0011\u0013!C\u0001\u0007{\u000b\u0011\u0004\u001e:b]Nd\u0017\r^3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0018\u0016\u0004\u0013\u000e]\u0005\"CBb\u0001E\u0005I\u0011ABW\u0003}1\u0017N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B$C-\u001a4bk2$HE\r\u0015\u0004\u0001\u0005\rwaBBe\u0005!\u000511Z\u0001\u000b\u0019><7+Z4nK:$\bcA\u0015\u0004N\u001a1\u0011A\u0001E\u0001\u0007\u001f\u001c2a!4\t\u0011\u001di6Q\u001aC\u0001\u0007'$\"aa3\t\u0011\r]7Q\u001aC\u0001\u00073\fAa\u001c9f]R\trla7\u0004^\u000e}7\u0011^Bv\u0007_\u001c\u0019pa>\t\u0011\r-1Q\u001ba\u0001\u0007\u001bAaaPBk\u0001\u0004\t\u0005\u0002CBq\u0007+\u0004\raa9\u0002\r\r|gNZ5h!\rI3Q]\u0005\u0004\u0007O\u0014!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u00196Q\u001ba\u0001+\"I1Q^Bk!\u0003\u0005\ra^\u0001\u0012M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\b\"CBy\u0007+\u0004\n\u00111\u0001J\u00031Ig.\u001b;GS2,7+\u001b>f\u0011%\u0019)p!6\u0011\u0002\u0003\u0007q/A\u0006qe\u0016\fG\u000e\\8dCR,\u0007BCB}\u0007+\u0004\n\u00111\u0001\u0004$\u0005Qa-\u001b7f'V4g-\u001b=\t\u0011\r54Q\u001aC\u0001\u0007{$\u0002\"!\u0002\u0004\u0000\u0012\u0005A1\u0001\u0005\t\u0007\u0017\u0019Y\u00101\u0001\u0004\u000e!1qha?A\u0002\u0005C!b!?\u0004|B\u0005\t\u0019AB\u0012\u0011)!9a!4\u0012\u0002\u0013\u00051QW\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00136\u0011)!Ya!4\u0012\u0002\u0013\u00051QX\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0011)!ya!4\u0012\u0002\u0013\u00051QW\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00138\u0011)!\u0019b!4\u0012\u0002\u0013\u0005AQC\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00139+\t!9B\u000b\u0003\u0004$\r]\u0005B\u0003C\u000e\u0007\u001b\f\n\u0011\"\u0001\u0005\u0016\u0005AB-\u001a7fi\u0016Le-\u0012=jgR\u001cH\u0005Z3gCVdG\u000fJ\u001a")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyOffsetIndex lazyOffsetIndex;
    private final LazyTimeIndex lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyOffsetIndex lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyTimeIndex lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size2) {
        this.offsetIndex().resize(size2);
        this.timeIndex().resize(size2);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset index file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lazyOffsetIndex().file().getAbsolutePath()})));
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
    }

    public long maxTimestampSoFar() {
        if (this._maxTimestampSoFar().isEmpty()) {
            this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().timestamp())));
        }
        return BoxesRunTime.unboxToLong((Object)this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset2) {
        this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)offset2)));
    }

    public long offsetOfMaxTimestampSoFar() {
        if (this._offsetOfMaxTimestampSoFar().isEmpty()) {
            this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().offset())));
        }
        return BoxesRunTime.unboxToLong((Object)this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset2) {
        return this.offsetIndex().canAppendOffset(offset2);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, largestOffset, largestTimestamp, shallowOffsetOfMaxTimestamp, records){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long largestOffset$1;
                private final long largestTimestamp$1;
                private final long shallowOffsetOfMaxTimestamp$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting ", " bytes at end offset ", " at position ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.largestOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with largest timestamp ", " at shallow offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.largestTimestamp$1), BoxesRunTime.boxToLong((long)this.shallowOffsetOfMaxTimestamp$1)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.largestOffset$1 = largestOffset$1;
                    this.largestTimestamp$1 = largestTimestamp$1;
                    this.shallowOffsetOfMaxTimestamp$1 = shallowOffsetOfMaxTimestamp$1;
                    this.records$1 = records$1;
                }
            });
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.kafka$log$LogSegment$$ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)new Serializable(this, largestOffset, appendedBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long largestOffset$1;
                private final int appendedBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appended ", " to ", " at end offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.appendedBytes$1), this.$outer.log().file(), BoxesRunTime.boxToLong((long)this.largestOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.largestOffset$1 = largestOffset$1;
                    this.appendedBytes$1 = appendedBytes$1;
                }
            });
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$4 = this.maxTimestampSoFar();
                long x$5 = this.offsetOfMaxTimestampSoFar();
                boolean x$6 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$4, x$5, x$6);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    public void kafka$log$LogSegment$$ensureOffsetInRange(long offset2) {
        if (this.canConvertToRelativeOffset(offset2)) {
            return;
        }
        throw new LogSegmentOffsetOverflowException(this, offset2);
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        Iterator nextBatches = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator();
        nextBatches.takeWhile((Function1)new Serializable(this, bytesToAppend, readBuffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;
            private final IntRef bytesToAppend$1;
            private final ObjectRef readBuffer$1;

            public final boolean apply(RecordBatch batch) {
                return this.$outer.kafka$log$LogSegment$$canAppend$1(batch, this.bytesToAppend$1, this.readBuffer$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytesToAppend$1 = bytesToAppend$1;
                this.readBuffer$1 = readBuffer$1;
            }
        }).foreach((Function1)new Serializable(this, bytesToAppend, maxTimestamp, offsetOfMaxTimestamp, maxOffset){
            public static final long serialVersionUID = 0L;
            private final IntRef bytesToAppend$1;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;
            private final LongRef maxOffset$1;

            public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                if (batch.maxTimestamp() > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = batch.maxTimestamp();
                    this.offsetOfMaxTimestamp$1.elem = batch.lastOffset();
                }
                this.maxOffset$1.elem = batch.lastOffset();
                this.bytesToAppend$1.elem += batch.sizeInBytes();
            }
            {
                this.bytesToAppend$1 = bytesToAppend$1;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
                this.maxOffset$1 = maxOffset$1;
            }
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset2) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)new Serializable(this, completedTxn, lastStableOffset2){
                public static final long serialVersionUID = 0L;
                private final CompletedTxn completedTxn$1;
                private final long lastStableOffset$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing aborted transaction ", " to transaction index, last stable offset is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.completedTxn$1, BoxesRunTime.boxToLong((long)this.lastStableOffset$1)}));
                }
                {
                    this.completedTxn$1 = completedTxn$1;
                    this.lastStableOffset$1 = lastStableOffset$1;
                }
            });
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset2));
        }
    }

    public void kafka$log$LogSegment$$updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1)new Serializable(this, producerStateManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$2;

                public final void apply(CompletedTxn completedTxn) {
                    long lastStableOffset2 = this.producerStateManager$2.lastStableOffset(completedTxn);
                    this.$outer.updateTxnIndex(completedTxn, lastStableOffset2);
                    this.producerStateManager$2.completeTxn(completedTxn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$2 = producerStateManager$2;
                }
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset2, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset2);
        return this.log().searchForOffsetWithSize(offset2, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Option<Object> option;
        block9: {
            int n;
            int adjustedMaxSize;
            LogOffsetMetadata offsetMetadata;
            int startPosition;
            FileRecords.LogOffsetPosition startOffsetAndSize;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid max size ", " for log read from segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize), this.log()})));
                    }
                    logSize = this.log().sizeInBytes();
                    startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startOffsetAndSize == null) {
                        return null;
                    }
                    startPosition = startOffsetAndSize.position;
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
                    int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
                    if (adjustedMaxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
                    }
                    option = maxOffset;
                    if (!None$.MODULE$.equals(option)) break block7;
                    n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset2 = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset2 < startOffset) {
                    return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
                }
                FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, startPosition);
                int endPosition = mapping == null ? logSize : mapping.position;
                n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
            }
            int fetchSize = n;
            return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
        }
        throw new MatchError(option);
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetPosition x$1) {
                return x$1.offset();
            }
        });
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1)new Serializable(this, producerStateManager, leaderEpochCache, validBytes, lastIndexEntry){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$1;
                private final Option leaderEpochCache$1;
                private final IntRef validBytes$1;
                private final IntRef lastIndexEntry$1;

                public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                    batch.ensureValid();
                    this.$outer.kafka$log$LogSegment$$ensureOffsetInRange(batch.lastOffset());
                    if (batch.maxTimestamp() > this.$outer.maxTimestampSoFar()) {
                        this.$outer.maxTimestampSoFar_$eq(batch.maxTimestamp());
                        this.$outer.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
                    }
                    if (this.validBytes$1.elem - this.lastIndexEntry$1.elem > this.$outer.indexIntervalBytes()) {
                        this.$outer.offsetIndex().append(batch.lastOffset(), this.validBytes$1.elem);
                        TimeIndex qual$2 = this.$outer.timeIndex();
                        long x$7 = this.$outer.maxTimestampSoFar();
                        long x$8 = this.$outer.offsetOfMaxTimestampSoFar();
                        boolean x$9 = qual$2.maybeAppend$default$3();
                        qual$2.maybeAppend(x$7, x$8, x$9);
                        this.lastIndexEntry$1.elem = this.validBytes$1.elem;
                    }
                    this.validBytes$1.elem += batch.sizeInBytes();
                    if (batch.magic() >= 2) {
                        this.leaderEpochCache$1.foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            public final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(LeaderEpochFileCache cache) {
                                if (this.batch$1.partitionLeaderEpoch() > 0 && cache.latestEpoch().forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$recover$1$$anonfun$apply$2 $outer;

                                    public final boolean apply(int x$2) {
                                        return this.apply$mcZI$sp(x$2);
                                    }

                                    public boolean apply$mcZI$sp(int x$2) {
                                        return this.$outer.batch$1.partitionLeaderEpoch() > x$2;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                })) {
                                    cache.assign(this.batch$1.partitionLeaderEpoch(), this.batch$1.baseOffset());
                                }
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                        this.$outer.kafka$log$LogSegment$$updateProducerState(this.producerStateManager$1, (RecordBatch)batch);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$1 = producerStateManager$1;
                    this.leaderEpochCache$1 = leaderEpochCache$1;
                    this.validBytes$1 = validBytes$1;
                    this.lastIndexEntry$1 = lastIndexEntry$1;
                }
            });
        }
        catch (CorruptRecordException corruptRecordException) {
            this.warn((Function0<String>)new Serializable(this, validBytes, corruptRecordException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final IntRef validBytes$1;
                private final CorruptRecordException e$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.validBytes$1.elem), this.e$1.getMessage()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.validBytes$1 = validBytes$1;
                    this.e$1 = e$1;
                }
            });
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)new Serializable(this, truncated){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final int truncated$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated ", " invalid bytes at the end of segment ", " during recovery"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.truncated$1), this.$outer.log().file().getAbsoluteFile()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.truncated$1 = truncated$1;
                }
            });
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset2) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset2);
        this.timeIndex().truncateTo(offset2);
        this.txnIndex().truncateTo(offset2);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return fetchData == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RecordBatch x$3) {
                return x$3.nextOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.baseOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.offsetIndex().flush();
                this.$outer.timeIndex().flush();
                this.$outer.txnIndex().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.lazyOffsetIndex().file_$eq(new File(dir, this.lazyOffsetIndex().file().getName()));
        this.lazyTimeIndex().file_$eq(new File(dir, this.lazyTimeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        java.util.Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        Some some;
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().maybeAppend(this.$outer.maxTimestampSoFar(), this.$outer.offsetOfMaxTimestampSoFar(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.offsetIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.offsetIndex().closeHandler();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().closeHandler();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().closeHandlers();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$1 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().log().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "log", this.$outer.log().file(), true);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetIndex offsetIndex = this.$outer.offsetIndex();
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this, offsetIndex){
                    public static final long serialVersionUID = 0L;
                    private final OffsetIndex eta$0$1$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.eta$0$1$1.deleteIfExists();
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                }, "offset index", this.$outer.lazyOffsetIndex().file(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TimeIndex timeIndex = this.$outer.timeIndex();
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this, timeIndex){
                    public static final long serialVersionUID = 0L;
                    private final TimeIndex eta$0$2$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.eta$0$2$1.deleteIfExists();
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                    }
                }, "time index", this.$outer.lazyTimeIndex().file(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$4 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().txnIndex().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "transaction index", this.$outer.txnIndex().file(), false);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    public final boolean kafka$log$LogSegment$$canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public final void kafka$log$LogSegment$$delete$1(Function0 delete2, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete2.apply$mcZ$sp()) {
                this.info((Function0<String>)new Serializable(this, fileType, file){
                    public static final long serialVersionUID = 0L;
                    private final String fileType$1;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileType$1, this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.fileType$1 = fileType$1;
                        this.file$1 = file$1;
                    }
                });
            } else if (logIfMissing) {
                this.info((Function0<String>)new Serializable(this, fileType, file){
                    public static final long serialVersionUID = 0L;
                    private final String fileType$1;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete ", " ", " because it does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileType$1, this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.fileType$1 = fileType$1;
                        this.file$1 = file$1;
                    }
                });
            }
            return;
        }
        catch (IOException iOException) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete of ", " ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, file.getAbsolutePath()})), iOException);
        }
    }

    public LogSegment(FileRecords log, LazyOffsetIndex lazyOffsetIndex, LazyTimeIndex lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
    }
}

