/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0015\r\u0011\"\u0003\u000f\u0003\u0019\u0019wN\u001c4jOV\tq\u0002\u0005\u0002\n!%\u0011\u0011C\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011B\b\u0002\u000f\r|gNZ5hA!AQ\u0003\u0001BC\u0002\u0013%a#A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!!\u0006\u000e\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0013DA\u0004NKR\u0014\u0018nY:\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005!A/[7f+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ti#F\u0001\u0003US6,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000bQLW.\u001a\u0011\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005MJdB\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*\u0014A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u001b\t\u0011u\u0002!\u0011!Q\u0001\ny\nQ\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0001\u001b@\u0003&\u0011\u0001)\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t3U\"A\"\u000b\u0005\u0011+\u0015!B9v_R\f'BA\u0002\u001d\u0013\t95IA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7\u000eC\u0003J\u0001\u0011\u0005!*\u0001\u0004=S:LGO\u0010\u000b\u0007\u00172kej\u0014)\u0011\u0005%\u0001\u0001\"B\u0007I\u0001\u0004y\u0001\"B\u000bI\u0001\u00049\u0002\"\u0002\u0014I\u0001\u0004A\u0003\"B\u0019I\u0001\u0004\u0011\u0004\"B\u001fI\u0001\u0004q\u0004b\u0002*\u0001\u0005\u0004%\taU\u0001\u0012[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001bX#\u0001+\u0011\u0005Q*\u0016B\u0001,6\u0005\u0011auN\\4\t\ra\u0003\u0001\u0015!\u0003U\u0003Ii\u0017\r\u001f+ie>$H\u000f\\3US6,Wj\u001d\u0011\t\u000bi\u0003A\u0011A.\u0002\u0019\u0015DX-\u001c9u'\u0016t7o\u001c:\u0016\u0003q\u0003\"\u0001G/\n\u0005yK\"AB*f]N|'\u000fC\u0003a\u0001\u0011\u0005\u0011-\u0001\u0007sK\u000e|'\u000fZ#yK6\u0004H\u000f\u0006\u0002cKB\u0011AgY\u0005\u0003IV\u0012A!\u00168ji\")am\u0018a\u0001O\u0006)a/\u00197vKB\u0011A\u0007[\u0005\u0003SV\u0012a\u0001R8vE2,\u0007\"B6\u0001\t\u0003a\u0017aH7bs\n,'+Z2pe\u0012\fe\u000eZ$fiRC'o\u001c;uY\u0016$\u0016.\\3NgR\u0011Q\u000e\u001d\t\u0003i9L!a\\\u001b\u0003\u0007%sG\u000fC\u0003rU\u0002\u0007!/A\u0004sKF,Xm\u001d;\u0011\u0005MLhB\u0001;x\u001b\u0005)(B\u0001<\u0005\u0003\u001dqW\r^<pe.L!\u0001_;\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011!p\u001f\u0002\b%\u0016\fX/Z:u\u0015\tAX\u000fC\u0003~\u0001\u0011\u0005a0A\tnCf\u0014WMU3d_J$W\t_3naR$\"AY@\t\u000bEd\b\u0019\u0001:\t\u000f\u0005\r\u0001\u0001\"\u0015\u0002\u0006\u0005aA\u000f\u001b:piRdW\rV5nKR\u0019A+a\u0002\t\u0011\u0005%\u0011\u0011\u0001a\u0001\u0003\u0017\tAb\u00197jK:$X*\u001a;sS\u000e\u00042\u0001GA\u0007\u0013\r\ty!\u0007\u0002\f\u0017\u000647.Y'fiJL7\rC\u0004\u0002\u0014\u0001!\t&!\u0006\u0002)\rd\u0017.\u001a8u%\u0006$X-T3ue&\u001cg*Y7f)\u0011\t9\"a\b\u0011\t\u0005e\u00111D\u0007\u00025%\u0019\u0011Q\u0004\u000e\u0003\u00155+GO]5d\u001d\u0006lW\r\u0003\u0005\u0002\"\u0005E\u0001\u0019AA\u0012\u0003=\tXo\u001c;b\u001b\u0016$(/[2UC\u001e\u001c\b#B\u001a\u0002&I\u0012\u0014bAA\u0014w\t\u0019Q*\u00199\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005\u0001R\r_3naRlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003/Aq!!\r\u0001\t\u0013\t\u0019$\u0001\tfq\u0016l\u0007\u000f^*f]N|'OT1nKV\t!\u0007C\u0004\u00028\u0001!I!!\u000f\u0002#9\fgn\\:U_B+'oY3oi\u0006<W\rF\u0002h\u0003wAq!!\u0010\u00026\u0001\u0007A+A\u0003oC:|7\u000f")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value2) {
        this.exemptSensor().record(value2);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int n;
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((Object)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;
                private final RequestChannel.Request request$1;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.recordNoThrottle(this.$outer.getOrCreateQuotaSensors(this.request$1.session(), this.request$1.header().clientId()), this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$1 = request$1;
                }
            }));
            n = this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), this.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(request.requestThreadTimeNanos()), this.time().milliseconds());
        } else {
            n = 0;
        }
        return n;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.recordExempt(this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.recordExempt(this.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric) {
        return package$.MODULE$.min(super.throttleTime(clientMetric), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking request-time per user/client-id", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder().append((Object)"exempt-").append((Object)QuotaType$Request$.MODULE$).toString();
    }

    public double kafka$server$ClientRequestQuotaManager$$nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

