/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.StateChangeLogger;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\n\u0015\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!!\u0004A!A!\u0002\u0013)\u0004\"\u0002\u001d\u0001\t\u0003I\u0004b\u0002!\u0001\u0005\u0004%I!\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\"\t\u000b%\u0003A\u0011\t&\t\u000bq\u0004A\u0011B?\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\t\u0001\u0011%\u00111\u0003\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002\u0012\n9\"l\u001b)beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0006\u0003+Y\t!bY8oiJ|G\u000e\\3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003QI!!\b\u000b\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK\u000611m\u001c8gS\u001e\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\f\u0002\rM,'O^3s\u0013\t!\u0013EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!E:uCR,7\t[1oO\u0016dunZ4feB\u00111dJ\u0005\u0003QQ\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u00037-J!\u0001\f\u000b\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0001\u0005{W\u000ec\u0017.\u001a8u!\ty#'D\u00011\u0015\t\td#\u0001\u0002{W&\u00111\u0007\r\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u00029\r|g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQB\u00111DN\u0005\u0003oQ\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.\u0001\u0004=S:LGO\u0010\u000b\u0007umbTHP \u0011\u0005m\u0001\u0001\"\u0002\u0010\u0007\u0001\u0004y\u0002\"B\u0013\u0007\u0001\u00041\u0003\"B\u0015\u0007\u0001\u0004Q\u0003\"B\u0017\u0007\u0001\u0004q\u0003\"\u0002\u001b\u0007\u0001\u0004)\u0014\u0001D2p]R\u0014x\u000e\u001c7fe&#W#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\u0007%sG/A\u0007d_:$(o\u001c7mKJLE\rI\u0001\u0013Q\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\u0006\u0003LU>$\b\u0003\u0002'T-\u0006t!!T)\u0011\u00059#U\"A(\u000b\u0005AC\u0012A\u0002\u001fs_>$h(\u0003\u0002S\t\u00061\u0001K]3eK\u001aL!\u0001V+\u0003\u00075\u000b\u0007O\u0003\u0002S\tB\u0011qkX\u0007\u00021*\u0011\u0011LW\u0001\u0007G>lWn\u001c8\u000b\u0005]Y&B\u0001/^\u0003\u0019\t\u0007/Y2iK*\ta,A\u0002pe\u001eL!\u0001\u0019-\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011!m\u001a\b\u0003G\u0016t!A\u00143\n\u0003\u0015K!A\u001a#\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\n)\"\u0014xn^1cY\u0016T!A\u001a#\t\u000b-L\u0001\u0019\u00017\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002c[ZK!A\\5\u0003\u0007M+\u0017\u000fC\u0003q\u0013\u0001\u0007\u0011/A\u0006uCJ<W\r^*uCR,\u0007CA\u000es\u0013\t\u0019HC\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000bUL\u0001\u0019\u0001<\u0002EA\f'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u0017p\u00149u!\r\u0019u/_\u0005\u0003q\u0012\u0013aa\u00149uS>t\u0007CA\u000e{\u0013\tYHCA\u0010QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]N#(/\u0019;fOf\fa\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0002r}\")qP\u0003a\u0001-\u0006I\u0001/\u0019:uSRLwN\\\u0001\u0015I>D\u0015M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\u000f-\u000b)!a\u0002\u0002\n!)1n\u0003a\u0001Y\")\u0001o\u0003a\u0001c\")Qo\u0003a\u0001m\u0006\u0019\u0013N\\5uS\u0006d\u0017N_3MK\u0006$WM]!oI&\u001b(OR8s!\u0006\u0014H/\u001b;j_:\u001cHc\u00017\u0002\u0010!)1\u000e\u0004a\u0001Y\u0006AR\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\r\u0005U\u00111DA\u000f!\u0015\u0019\u0015q\u00037L\u0013\r\tI\u0002\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u000b-l\u0001\u0019\u00017\t\r\u0005}Q\u00021\u0001z\u0003}\u0001\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_\u0001\u001bI>,E.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003K\t\u0019$!\u000e\u0011\u000f\r\u000b9\u0003\u001c7\u0002,%\u0019\u0011\u0011\u0006#\u0003\rQ+\b\u000f\\34!\u0015a5KVA\u0017!\r\u0011\u0017qF\u0005\u0004\u0003cI'!C#yG\u0016\u0004H/[8o\u0011\u0015Yg\u00021\u0001m\u0011\u0019\tyB\u0004a\u0001s\u0006\t3m\u001c7mK\u000e$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>t7\u000b^1uKR!\u00111HA'!\u0011\u0011W.!\u0010\u0011\u0011\r\u000b9CVA \u0003\u000f\u0002BaQ<\u0002BA\u00191$a\u0011\n\u0007\u0005\u0015CCA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0004\u0007\u0006%\u0013bAA&\t\n9!i\\8mK\u0006t\u0007bBA(\u001f\u0001\u0007\u0011\u0011K\u0001\u001dY\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195t!\u0011\u0011W.a\u0015\u0011\r\r\u000b9BVA!\u0003QawnZ%om\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R1\u0011\u0011LA0\u0003C\u00022aQA.\u0013\r\ti\u0006\u0012\u0002\u0005+:LG\u000fC\u0003\u0000!\u0001\u0007a\u000bC\u0003q!\u0001\u0007\u0011/\u0001\u000bm_\u001e4\u0015-\u001b7fIN#\u0018\r^3DQ\u0006tw-\u001a\u000b\u000b\u00033\n9'!\u001b\u0002n\u0005=\u0004\"B@\u0012\u0001\u00041\u0006BBA6#\u0001\u0007\u0011/A\u0005dkJ\u00148\u000b^1uK\")\u0001/\u0005a\u0001c\"9\u0011\u0011O\tA\u0002\u0005M\u0014\u0001B2pI\u0016\u0004B!!\u001e\u0002\f:!\u0011qOAC\u001d\u0011\tI(!!\u000f\t\u0005m\u0014q\u0010\b\u0004\u001d\u0006u\u0014\"\u00010\n\u0005qk\u0016bAAB7\u0006I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0003\u000f\u000bI)A\bLK\u0016\u0004XM]#yG\u0016\u0004H/[8o\u0015\r\t\u0019iW\u0005\u0005\u0003\u001b\u000byI\u0001\u0003D_\u0012,'\u0002BAD\u0003\u0013#\"\"!\u0017\u0002\u0014\u0006U\u0015qSAM\u0011\u0015y(\u00031\u0001W\u0011\u0019\tYG\u0005a\u0001c\")\u0001O\u0005a\u0001c\"1\u00111\u0014\nA\u0002\u0005\f\u0011\u0001\u001e")
public class ZkPartitionStateMachine
extends PartitionStateMachine {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;

    private int controllerId() {
        return this.controllerId;
    }

    @Override
    public Map<TopicPartition, Throwable> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Map map;
        if (partitions.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                Map errors = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                map = errors;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Controller moved to another broker when moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error while moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext.partitionState(partition);
    }

    private Map<TopicPartition, Throwable> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Map map;
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<TopicPartition>, Seq<TopicPartition>> tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validPartitions, (Object)invalidPartitions);
        Tuple2 tuple23 = tuple22;
        Seq validPartitions2 = (Seq)tuple23._1();
        Seq invalidPartitions2 = (Seq)tuple23._2();
        invalidPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        PartitionState partitionState = targetState;
        if (NewPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$3(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        } else if (OnlinePartition$.MODULE$.equals(partitionState)) {
            Map map2;
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doHandleStateChanges$5(this, partition)));
            Seq partitionsToElectLeader = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doHandleStateChanges$6(this, partition)));
            if (uninitializedPartitions.nonEmpty()) {
                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                successfulInitializations.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$7(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Tuple2<Seq<TopicPartition>, Map<TopicPartition, Throwable>> tuple24 = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                Seq successfulElections = (Seq)tuple24._1();
                Map failedElections = (Map)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)successfulElections, (Object)failedElections);
                Tuple2 tuple26 = tuple25;
                Seq successfulElections2 = (Seq)tuple26._1();
                Map failedElections2 = (Map)tuple26._2();
                successfulElections2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$9(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
                map2 = failedElections2;
            } else {
                map2 = Predef$.MODULE$.Map().empty();
            }
            map = map2;
        } else if (OfflinePartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$11(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        } else if (NonExistentPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$13(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError((Object)partitionState);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var3_2;
        Seq seq;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionReplicaAssignment((TopicPartition)partition)), Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$3);
            return BoxedUnit.UNIT;
        });
        Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas2.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq liveReplicas = (Seq)tuple2._2();
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.controllerContext.epochZkVersion());
        }
        catch (ControllerMovedException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller moved to another broker when trying to create the topic partition state znode", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw e;
        }
        catch (Exception e) {
            partitionsWithLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$9(this, e, x0$5);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            BoxedUnit boxedUnit;
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), true);
                boxedUnit = successfulInitializations.$plus$eq((Object)partition);
            } else {
                this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var3_2;
    }

    private Tuple2<Seq<TopicPartition>, Map<TopicPartition, Throwable>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Buffer successfulElections = (Buffer)Buffer$.MODULE$.empty();
        Seq remaining = partitions;
        Map failures = Predef$.MODULE$.Map().empty();
        while (remaining.nonEmpty()) {
            Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple3 = this.doElectLeaderForPartitions(partitions, partitionLeaderElectionStrategy);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Seq success = (Seq)tuple3._1();
            Seq updatesToRetry = (Seq)tuple3._2();
            Map failedElections = (Map)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)success, (Object)updatesToRetry, (Object)failedElections);
            Tuple3 tuple33 = tuple32;
            Seq success2 = (Seq)tuple33._1();
            Seq updatesToRetry2 = (Seq)tuple33._2();
            Map failedElections2 = (Map)tuple33._3();
            remaining = updatesToRetry2;
            successfulElections.$plus$plus$eq((TraversableOnce)success2);
            failedElections2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ZkPartitionStateMachine.$anonfun$electLeaderForPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            failures = failures.$plus$plus((GenTraversableOnce)failedElections2);
        }
        return new Tuple2((Object)successfulElections, (Object)failures);
    }

    private Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, Map<TopicPartition, Exception>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        scala.collection.mutable.Map failedElections = Map$.MODULE$.empty();
        Buffer leaderIsrAndControllerEpochPerPartition = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            Option option;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = this.partitionState(partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                BoxedUnit boxedUnit;
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    boxedUnit = failedElections.put((Object)partition, (Object)exception);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option = leaderIsrAndControllerEpochPerPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderIsrAndControllerEpochOpt.get()));
            } else {
                KeeperException.Code code3 = getDataResponse.resultCode();
                KeeperException.Code code4 = KeeperException.Code.NONODE;
                if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    option = failedElections.put((Object)partition, (Object)exception);
                } else {
                    option = failedElections.put((Object)partition, getDataResponse.resultException().get());
                }
            }
            return option;
        });
        Tuple2 tuple22 = leaderIsrAndControllerEpochPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(this, x0$1)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Buffer invalidPartitionsForElection = (Buffer)tuple22._1();
        Buffer validPartitionsForElection = (Buffer)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection);
        Tuple2 tuple24 = tuple23;
        Buffer invalidPartitionsForElection2 = (Buffer)tuple24._1();
        Buffer validPartitionsForElection2 = (Buffer)tuple24._2();
        invalidPartitionsForElection2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            String failMsg = new StringBuilder(71).append("aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append(new StringBuilder(101).append("already written by another controller. This probably means that the current controller ").append(this.controllerId()).append(" went through ").toString()).append(new StringBuilder(62).append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString()).toString();
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        if (validPartitionsForElection2.isEmpty()) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)failedElections.toMap(Predef$.MODULE$.$conforms()));
        }
        PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
        if (OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            Seq<Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object>> partitionsWithUncleanLeaderElectionState = this.collectUncleanLeaderElectionState((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2);
            tuple2 = Election$.MODULE$.leaderForOffline(this.controllerContext, partitionsWithUncleanLeaderElectionState).partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x$8)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x$9)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$7(x$10)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$8(x$11)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy2);
        }
        Tuple2 tuple25 = tuple2;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        Seq partitionsWithoutLeaders = (Seq)tuple25._1();
        Seq partitionsWithLeaders = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
        Tuple2 tuple27 = tuple26;
        Seq partitionsWithoutLeaders2 = (Seq)tuple27._1();
        Seq partitionsWithLeaders2 = (Seq)tuple27._2();
        partitionsWithoutLeaders2.foreach((Function1 & Serializable & scala.Serializable)electionResult -> {
            TopicPartition partition = electionResult.topicPartition();
            String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(partitionLeaderElectionStrategy).toString();
            return failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
        });
        Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.liveReplicas()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.leaderAndIsr().get()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)updateLeaderAndIsrResult);
        }
        Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3 tuple3 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3 tuple32 = tuple3;
        Map successfulUpdates2 = (Map)tuple32._1();
        Seq updatesToRetry2 = (Seq)tuple32._2();
        Map failedUpdates2 = (Map)tuple32._3();
        successfulUpdates2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$12(this, recipientsPerPartition, x0$3);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)successfulUpdates2.keys().toSeq(), (Object)updatesToRetry2, (Object)failedElections.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedUpdates2));
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object>> collectUncleanLeaderElectionState(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Tuple2 tuple2 = leaderIsrAndControllerEpochs.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$collectUncleanLeaderElectionState$1(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas, (Object)partitionsWithLiveInSyncReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple23._2();
        Tuple2<Map<String, LogConfig>, Map<String, Exception>> tuple24 = this.zkClient.getLogConfigs((Seq<String>)((Seq)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            String string = partition.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())), this.config.originals());
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Map logConfigs = (Map)tuple24._1();
        Map failed = (Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)logConfigs, (Object)failed);
        Tuple2 tuple26 = tuple25;
        Map logConfigs2 = (Map)tuple26._1();
        Map failed2 = (Map)tuple26._2();
        return (Seq)((TraversableLike)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple3 tuple3;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                if (failed2.contains((Object)partition.topic())) {
                    this.logFailedStateChange(partition, this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)failed2.apply((Object)partition.topic()));
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)((Object)((Object)logConfigs2.apply((Object)partition.topic())))).uncleanLeaderElectionEnable()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            return tuple32;
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = this.partitionState(partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder(31).append("Partition ").append(partition).append(" should be in one of ").append(new StringBuilder(50).append(targetState.validPreviousStates().mkString(",")).append(" states before moving to ").append(targetState).append(" state. Instead it is in ").toString()).append(new StringBuilder(6).append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" failed to change state for partition ").append(partition).append(" ").append(new StringBuilder(9).append("from ").append(currState).append(" to ").append(targetState).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with ").append(new StringBuilder(18).append("assigned replicas ").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).toString()).toString());
        $this.controllerContext.putPartitionState(partition, NewPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$5(ZkPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(partitionState != null ? !partitionState.equals(newPartition$) : newPartition$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$6(ZkPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.partitionState(partition);
        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
        if (partitionState == null) {
            if (offlinePartition$ == null) return true;
        } else if (partitionState.equals(offlinePartition$)) return true;
        PartitionState partitionState2 = $this.partitionState(partition);
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (partitionState2 != null) {
            if (!partitionState2.equals(onlinePartition$)) return false;
            return true;
        }
        if (onlinePartition$ == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$7(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply((Object)partition)).leaderAndIsr())).toString());
        $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply((Object)partition)).leaderAndIsr())).toString());
        $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$11(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).toString());
        $this.controllerContext.putPartitionState(partition, OfflinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).toString());
        $this.controllerContext.putPartitionState(partition, NonExistentPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq liveReplicas = (Seq)tuple2._2();
        boolean bl = liveReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(ZkPartitionStateMachine $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Seq replicas = (Seq)tuple2._2();
        String failMsg = new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" encountered error during state change of ").append(new StringBuilder(53).append("partition ").append(partition).append(" from New to Online, assigned replicas are ").toString()).append(new StringBuilder(37).append("[").append(replicas.mkString(",")).append("], live brokers are [").append($this.controllerContext.liveBrokerIds()).append("]. No assigned ").toString()).append("replica is alive.").toString();
        $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$9(ZkPartitionStateMachine $this, Exception e$4, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)NewPartition$.MODULE$, e$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$electLeaderForPartitions$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(ElectionResult x$8) {
        return x$8.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(ElectionResult x$9) {
        return x$9.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$7(ElectionResult x$10) {
        return x$10.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$8(ElectionResult x$11) {
        return x$11.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$12(ZkPartitionStateMachine $this, Map recipientsPerPartition$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        Seq<Object> replicas = $this.controllerContext.partitionReplicaAssignment(partition);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition)), partition, leaderIsrAndControllerEpoch, replicas, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$collectUncleanLeaderElectionState$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        List liveInSyncReplicas = (List)leaderIsrAndControllerEpoch.leaderAndIsr().isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
        boolean bl = liveInSyncReplicas.isEmpty();
        return bl;
    }

    public ZkPartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(38).append("[PartitionStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }
}

