/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r]a!\u0002\u001d:\u0001ej\u0004\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011\u0001*\t\u0011\u001d\u0004!\u0011!Q\u0001\nMC\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t!\u001b\u0005\ty\u0002\u0011\t\u0011)A\u0005U\"AQ\u0010\u0001BC\u0002\u0013\u0005a\u0010C\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005\u007f\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\r\u0001\u0011E\u00131\u0004\u0005\u000b\u0003S\u0001!\u0019!C\u0001s\u0005m\u0001\u0002CA\u0016\u0001\u0001\u0006I!!\b\t\u0013\u00055\u0002\u00011A\u0005\n\u0005=\u0002\"CA&\u0001\u0001\u0007I\u0011BA'\u0011!\tI\u0006\u0001Q!\n\u0005E\u0002\"CA2\u0001\t\u0007I\u0011BA3\u0011!\tI\b\u0001Q\u0001\n\u0005\u001d\u0004\"CA>\u0001\t\u0007I\u0011BA?\u0011!\t)\n\u0001Q\u0001\n\u0005}\u0004\"CAL\u0001\t\u0007I\u0011BAM\u0011!\ty\u000b\u0001Q\u0001\n\u0005m\u0005\"CAY\u0001\t\u0007I\u0011BAZ\u0011!\tY\f\u0001Q\u0001\n\u0005U\u0006\"CA_\u0001\u0001\u0007I\u0011BA`\u0011%\t9\r\u0001a\u0001\n\u0013\tI\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0015BAa\u0011%\t\t\u000e\u0001a\u0001\n\u0013\t\u0019\u000eC\u0005\u0002\\\u0002\u0001\r\u0011\"\u0003\u0002^\"A\u0011\u0011\u001d\u0001!B\u0013\t)\u000eC\u0004\u0002f\u0002!\t!a:\t\u0011\u00055\b\u0001\"\u0001:\u0003_D\u0001\"a?\u0001\t\u0003I\u0014Q \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011%\u0011I\u0003AI\u0001\n\u0003\u0011Y\u0003C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\tM\u0003\u0001\"\u0001\u0003D!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005G\u0002A\u0011\u0001B3\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA! \u0001\t\u0013\u0011y\bC\u0004\u0003\u0004\u0002!\tA!\"\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\"9!\u0011\u0014\u0001\u0005\u0002\tm\u0005b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005_\u0003A\u0011\u0001BY\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqAa2\u0001\t\u0003\u0011I\r\u0003\u0005\u0002|\u0001!\t!\u000fBg\u0011\u001d\u00119\u000e\u0001C\u0001\u00053DqA!9\u0001\t\u0013\u0011\u0019o\u0002\u0005\u0003jfB\t!\u000fBv\r\u001dA\u0014\b#\u0001:\u0005[Dq!!\u00044\t\u0003\u0011y\u000fC\u0004\u0003rN\"\tAa=\t\u000f\t]8\u0007\"\u0001\u0003z\"91QA\u001a\u0005\u0002\r\u001d!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u0011!hO\u0001\u0004Y><'\"\u0001\u001f\u0002\u000b-\fgm[1\u0014\t\u0001qDI\u0013\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d[\u0014!B;uS2\u001c\u0018BA%G\u0005\u001daunZ4j]\u001e\u0004\"a\u0013(\u000e\u00031S!!T\u001e\u0002\u000f5,GO]5dg&\u0011q\n\u0014\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018a\u00027pO\u0012K'o]\u0002\u0001+\u0005\u0019\u0006c\u0001+]?:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u00031F\u000ba\u0001\u0010:p_Rt\u0014\"A!\n\u0005m\u0003\u0015a\u00029bG.\fw-Z\u0005\u0003;z\u00131aU3r\u0015\tY\u0006\t\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006\u0011\u0011n\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0002UB!Qi[7y\u0013\tagI\u0001\u0003Q_>d\u0007C\u00018w\u001b\u0005y'B\u00019r\u0003\u0019\u0019w.\\7p]*\u0011AH\u001d\u0006\u0003gR\fa!\u00199bG\",'\"A;\u0002\u0007=\u0014x-\u0003\u0002x_\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA={\u001b\u0005I\u0014BA>:\u0005\raunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bY\u0014AB:feZ,'/\u0003\u0003\u0002\n\u0005\r!\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\rqJg.\u001b;?)!\t\t\"a\u0005\u0002\u0016\u0005]\u0001CA=\u0001\u0011\u0015\u0001v\u00011\u0001T\u0011\u0015Aw\u00011\u0001k\u0011\u0015ix\u00011\u0001\u0000\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\u0019\u0017\u0001\u00027b]\u001eLA!a\n\u0002\"\t11\u000b\u001e:j]\u001e\fAc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rI\u0001\fG\",7m\u001b9pS:$8/\u0006\u0002\u00022A9\u00111GA\u001f?\u0006\u0005SBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013%lW.\u001e;bE2,'bAA\u001e\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0004\u001b\u0006\u0004\b\u0003BA\"\u0003\u000fj!!!\u0012\u000b\t\u00055\u00121A\u0005\u0005\u0003\u0013\n)E\u0001\u000bPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\u001aKG.Z\u0001\u0010G\",7m\u001b9pS:$8o\u0018\u0013fcR!\u0011qJA+!\ry\u0014\u0011K\u0005\u0004\u0003'\u0002%\u0001B+oSRD\u0011\"a\u0016\r\u0003\u0003\u0005\r!!\r\u0002\u0007a$\u0013'\u0001\u0007dQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005K\u0002\u000e\u0003;\u00022aPA0\u0013\r\t\t\u0007\u0011\u0002\tm>d\u0017\r^5mK\u0006Q\u0011N\u001c)s_\u001e\u0014Xm]:\u0016\u0005\u0005\u001d\u0004cBA5\u0003_j\u00171O\u0007\u0003\u0003WRA!!\u001c\u0002:\u00059Q.\u001e;bE2,\u0017\u0002BA9\u0003W\u0012q\u0001S1tQ6\u000b\u0007\u000fE\u0002z\u0003kJ1!a\u001e:\u0005AaunZ\"mK\u0006t\u0017N\\4Ti\u0006$X-A\u0006j]B\u0013xn\u001a:fgN\u0004\u0013!F;oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u007f\u0002\u0002\"!\u001b\u0002p\u0005\u0005\u0015q\u0012\t\u0005\u0003\u0007\u000bYI\u0004\u0003\u0002\u0006\u0006\u001d\u0005C\u0001,A\u0013\r\tI\tQ\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0012Q\u0012\u0006\u0004\u0003\u0013\u0003\u0005#BA5\u0003#k\u0017\u0002BAJ\u0003W\u00121aU3u\u0003Y)hn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u00027pG.,\"!a'\u0011\t\u0005u\u00151V\u0007\u0003\u0003?SA!!)\u0002$\u0006)An\\2lg*!\u0011QUAT\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003S\u001b\u0017\u0001B;uS2LA!!,\u0002 \ni!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\n!\u0003]1vg\u0016$7\t\\3b]&twmQ8oIV\u0011\u0011Q\u0017\t\u0005\u0003;\u000b9,\u0003\u0003\u0002:\u0006}%!C\"p]\u0012LG/[8o\u0003M\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3!\u0003e!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8\u0016\u0005\u0005\u0005\u0007cA \u0002D&\u0019\u0011Q\u0019!\u0003\r\u0011{WO\u00197f\u0003u!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8`I\u0015\fH\u0003BA(\u0003\u0017D\u0011\"a\u0016\u0018\u0003\u0003\u0005\r!!1\u00025\u0011L'\u000f^5fgRdunZ\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u0011)\u0007a\ti&A\u0007uS6,wJ\u001a'bgR\u0014VO\\\u000b\u0003\u0003+\u00042aPAl\u0013\r\tI\u000e\u0011\u0002\u0005\u0019>tw-A\tuS6,wJ\u001a'bgR\u0014VO\\0%KF$B!a\u0014\u0002`\"I\u0011q\u000b\u000e\u0002\u0002\u0003\u0007\u0011Q[\u0001\u000fi&lWm\u00144MCN$(+\u001e8!Q\rY\u0012QL\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\tI\u000fE\u0004\u0002\u0004\u0006-X.!6\n\t\u0005}\u0012QR\u0001\u000eG2,\u0017M\\5oON#\u0018\r^3\u0015\t\u0005E\u0018q\u001f\t\u0006\u007f\u0005M\u00181O\u0005\u0004\u0003k\u0004%AB(qi&|g\u000e\u0003\u0004\u0002zv\u0001\r!\\\u0001\u0003iB\f\u0001c]3u\u00072,\u0017M\\5oON#\u0018\r^3\u0015\r\u0005=\u0013q B\u0001\u0011\u0019\tIP\ba\u0001[\"9!1\u0001\u0010A\u0002\u0005M\u0014!B:uCR,\u0017!G4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$bA!\u0003\u0003\u0012\t}\u0001#B \u0002t\n-\u0001cA=\u0003\u000e%\u0019!qB\u001d\u0003\u00151{w\rV8DY\u0016\fg\u000eC\u0004\u0003\u0014}\u0001\rA!\u0006\u0002\tQLW.\u001a\t\u0005\u0005/\u0011Y\"\u0004\u0002\u0003\u001a)\u0011qi\\\u0005\u0005\u0005;\u0011IB\u0001\u0003US6,\u0007\"\u0003B\u0011?A\u0005\t\u0019\u0001B\u0012\u00035\u0001(/Z\"mK\u0006t7\u000b^1ugB\u0019\u0011P!\n\n\u0007\t\u001d\u0012HA\u0007Qe\u0016\u001cE.Z1o'R\fGo]\u0001$OJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iC\u000b\u0003\u0003$\t=2F\u0001B\u0019!\u0011\u0011\u0019D!\u0010\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm\u0002)\u0001\u0006b]:|G/\u0019;j_:LAAa\u0010\u00036\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002MA\fWo]3DY\u0016\fg.\u001b8h\r>\u0014hj\u001c8D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0003FA1!q\tB%\u0005\u001bj!!!\u000f\n\t\t-\u0013\u0011\b\u0002\t\u0013R,'/\u00192mKB)qHa\u0014nq&\u0019!\u0011\u000b!\u0003\rQ+\b\u000f\\33\u00035!W\r\\3uC\ndW\rT8hg\u0006i\u0011MY8si\u000ecW-\u00198j]\u001e$B!a\u0014\u0003Z!1!1L\u0012A\u00025\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005=#\u0011\r\u0005\u0007\u00057\"\u0003\u0019A7\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR!\u0011q\nB4\u0011\u001d\u0011I'\na\u0001\u0005W\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006\u0005\u000f\u0012I%\\\u0001\u0012SN\u001cE.Z1oS:<\u0017J\\*uCR,GC\u0002B9\u0005o\u0012I\bE\u0002@\u0005gJ1A!\u001eA\u0005\u001d\u0011un\u001c7fC:DaAa\u0017'\u0001\u0004i\u0007b\u0002B>M\u0001\u0007\u00111O\u0001\u000eKb\u0004Xm\u0019;fIN#\u0018\r^3\u0002/%\u001c8\t\\3b]&tw-\u00138Ti\u0006$X\rU1vg\u0016$G\u0003\u0002B9\u0005\u0003CaAa\u0017(\u0001\u0004i\u0017\u0001F2iK\u000e\\7\t\\3b]&tw-\u00112peR,G\r\u0006\u0003\u0002P\t\u001d\u0005B\u0002B.Q\u0001\u0007Q.A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$b!a\u0014\u0003\u000e\nE\u0005B\u0002BHS\u0001\u0007q,A\u0004eCR\fG)\u001b:\t\u000f\tM\u0015\u00061\u0001\u0003\u0016\u00061Q\u000f\u001d3bi\u0016\u0004RaPAz\u0005/\u0003ba\u0010B([\u0006U\u0017AE1mi\u0016\u00148\t[3dWB|\u0017N\u001c;ESJ$\u0002\"a\u0014\u0003\u001e\n}%1\u0015\u0005\u0007\u00057R\u0003\u0019A7\t\r\t\u0005&\u00061\u0001`\u00031\u0019x.\u001e:dK2{w\rR5s\u0011\u0019\u0011)K\u000ba\u0001?\u0006QA-Z:u\u0019><G)\u001b:\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\t\u0005=#1\u0016\u0005\b\u0005[[\u0003\u0019AAA\u0003\r!\u0017N]\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"a\u0014\u00034\nU&q\u0017\u0005\u0007\u0005\u001fc\u0003\u0019A0\t\r\tmC\u00061\u0001n\u0011\u001d\u0011I\f\fa\u0001\u0003+\faa\u001c4gg\u0016$\u0018\u0001\u00043p]\u0016\u001cE.Z1oS:<G\u0003CA(\u0005\u007f\u0013\tMa1\t\r\tmS\u00061\u0001n\u0011\u0019\u0011y)\fa\u0001?\"9!QY\u0017A\u0002\u0005U\u0017!C3oI>3gm]3u\u00031!wN\\3EK2,G/\u001b8h)\u0011\tyEa3\t\u000f\t%d\u00061\u0001\u0003lQ!!q\u001aBj!\u0015\t\u0019I!5n\u0013\u0011\t\u0019*!$\t\u000f\tUw\u00061\u0001\u0002\u0002\u00061An\\4ESJ\f\u0001$\\1sWB\u000b'\u000f^5uS>tWK\\2mK\u0006t\u0017M\u00197f)\u0019\tyEa7\u0003^\"9!Q\u001b\u0019A\u0002\u0005\u0005\u0005B\u0002Bpa\u0001\u0007Q.A\u0005qCJ$\u0018\u000e^5p]\u00061\u0012n]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0003r\t\u0015(q\u001d\u0005\u0006uE\u0002\r\u0001\u001f\u0005\u0007\u00057\n\u0004\u0019A7\u0002#1{wm\u00117fC:,'/T1oC\u001e,'\u000f\u0005\u0002zgM\u00191G\u0010#\u0015\u0005\t-\u0018AE5t\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016$BA!\u001d\u0003v\")!(\u000ea\u0001q\u0006)r-\u001a;NCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006LH\u0003CAk\u0005w\u0014ip!\u0001\t\u000bi2\u0004\u0019\u0001=\t\u000f\t}h\u00071\u0001\u0002V\u0006\u0001b-\u001b:ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e\u0005\b\u0007\u00071\u0004\u0019AAk\u0003\rqwn^\u0001\u0011G2,\u0017M\\1cY\u0016|eMZ:fiN$\"b!\u0003\u0004\f\r51qBB\u000b!\u001dy$qJAk\u0003+DQAO\u001cA\u0002aDaAa\u00178\u0001\u0004i\u0007bBB\to\u0001\u000711C\u0001\nY\u0006\u001cHo\u00117fC:\u0004r!a\r\u0002>5\f)\u000eC\u0004\u0004\u0004]\u0002\r!!6")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions;
    private final ReentrantLock kafka$log$LogCleanerManager$$lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static long getMaxCompactionDelay(Log log, long l, long l2) {
        return LogCleanerManager$.MODULE$.getMaxCompactionDelay(log, l, l2);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    public HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions() {
        return this.kafka$log$LogCleanerManager$$uncleanablePartitions;
    }

    public ReentrantLock kafka$log$LogCleanerManager$$lock() {
        return this.kafka$log$LogCleanerManager$$lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            scala.collection.immutable.Map map;
            try {
                map = checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = Predef$.MODULE$.Map().empty();
            }
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().get((Object)tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().put((Object)tp, (Object)state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        return (Option)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                long compactionDelayMs = LogCleanerManager$.MODULE$.getMaxCompactionDelay(log, firstDirtyOffset, now);
                preCleanStats.updateMaxCompactionDelay(compactionDelayMs);
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset, compactionDelayMs > 0L);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                preCleanStats.recordCleanablePartitions(cleanableLogs.size());
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable deletableLogs = (Iterable)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3(this, x0$2)));
            deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                return option;
            });
            return var1_1;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$1)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning((Iterable<TopicPartition>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("The cleaning for partition ").append(topicPartition).append(" is aborted").toString());
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), () -> LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The cleaning for partition ").append(topicPartition).append(" is aborted and paused").toString());
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach(arg_0 -> LogCleanerManager.$anonfun$resumeCleaning$2(this, arg_0)));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogCleaningState state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState = state;
            boolean bl2 = logCleaningState instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint == null) break block2;
                try {
                    Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
                    checkpoint.write((Map<TopicPartition, Object>)existing);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        });
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block5: {
                block4: {
                    try {
                        Option option = this.checkpoints().get((Object)sourceLogDir).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.read().get((Object)topicPartition));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long offset = BoxesRunTime.unboxToLong((Object)some.value());
                            this.updateCheckpoints(sourceLogDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
                            this.updateCheckpoints(destLogDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offset))));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (KafkaStorageException e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                }
                Set logUncleanablePartitions = (Set)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)sourceLogDir.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                if (!logUncleanablePartitions.contains((Object)topicPartition)) break block5;
                logUncleanablePartitions.remove((Object)topicPartition);
                this.markPartitionUncleanable(destLogDir.toString(), topicPartition);
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)this.checkpoints().filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x$5)))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (!this.logs().get(topicPartition).config().compact() || (checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir)) == null || BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        });
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get(topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove(topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        }));
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((GenTraversableOnce)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        });
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Boolean bl;
            Option option = this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)logDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set partitions = (Set)some.value();
                bl = BoxesRunTime.boxToBoolean((boolean)partitions.add((Object)partition));
            } else if (None$.MODULE$.equals(option)) {
                bl = this.kafka$log$LogCleanerManager$$uncleanablePartitions().put((Object)logDir, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
            } else {
                throw new MatchError((Object)option);
            }
            return bl;
        });
    }

    private boolean isUncleanablePartition(Log log, TopicPartition topicPartition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)log.dir().getParent()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition)))));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = !log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var3_2 = false;
                var4_3 = null;
                var5_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var5_4)) break block6;
                var2_5 = $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
            var3_2 = true;
            var4_3 = (Some)var5_4;
            var6_6 = (LogCleaningState)var4_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var6_6)) {
                var2_5 = $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var3_2 && (var7_7 = (LogCleaningState)var4_3.value()) instanceof LogCleaningPaused) {
                var8_8 = (LogCleaningPaused)var7_7;
                count = var8_8.pausedCount();
                var2_5 = $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var3_2) {
                    s = (LogCleaningState)var4_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var5_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$resumeCleaning$2(LogCleanerManager $this, TopicPartition topicPartition) {
        var4_2 = $this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(var4_2)) {
            throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
        }
        if (!(var4_2 instanceof Some)) ** GOTO lbl21
        var5_3 = (Some)var4_2;
        state = (LogCleaningState)var5_3.value();
        var7_5 = false;
        var8_6 = null;
        var9_7 = state;
        if (!(var9_7 instanceof LogCleaningPaused)) ** GOTO lbl-1000
        var7_5 = true;
        var8_6 = (LogCleaningPaused)var9_7;
        count = var8_6.pausedCount();
        if (count == 1) {
            var3_9 = $this.inProgress().remove((Object)topicPartition);
        } else if (var7_5 && (count = var8_6.pausedCount()) > 1) {
            var3_9 = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(count - 1));
        } else {
            throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(var9_7).append(" state.").toString());
lbl21:
            // 1 sources

            throw new MatchError((Object)var4_2);
        }
        var2_11 = var3_9;
        return var2_11;
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, File x$5) {
        String string = x$5.getAbsolutePath();
        String string2 = dir$3;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$lock = new ReentrantLock();
        this.pausedCleaningCond = this.kafka$log$LogCleanerManager$$lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public int value() {
                return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inLock(this.$outer.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$1.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$2(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
            }

            public static final /* synthetic */ int $anonfun$value$2(Set x$1) {
                return x$1.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleanerManager$$anon$1 ), $anonfun$value$2$adapted(scala.collection.mutable.Set ), $anonfun$value$3()}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public long value() {
                return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inLock(this.$outer.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                    long l;
                    Option option = $this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$2.getAbsolutePath());
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Set partitions = (Set)some.value();
                        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.$outer.allCleanerCheckpoints();
                        long now = Time.SYSTEM.milliseconds();
                        l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(this, lastClean, now, tp)), Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    } else {
                        l = 0L;
                    }
                    return l;
                }));
            }

            public static final /* synthetic */ long $anonfun$value$5($anon$2 $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
                long uncleanableBytes;
                Log log = $this.$outer.logs().get(tp);
                Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.cleanableOffsets(log, tp, (scala.collection.immutable.Map<TopicPartition, Object>)lastClean$1, now$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long firstDirtyOffset = tuple2._1$mcJ$sp();
                long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset2 = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset2 = sp3._2$mcJ$sp();
                Tuple2<Object, Object> tuple22 = LogCleaner$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                long l = uncleanableBytes = tuple22._2$mcJ$sp();
                long uncleanableBytes2 = l;
                return uncleanableBytes2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(kafka.log.LogCleanerManager$$anon$2 ), $anonfun$value$5$adapted(kafka.log.LogCleanerManager$$anon$2 scala.collection.immutable.Map long org.apache.kafka.common.TopicPartition )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

