/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class Mx4jLoader$
implements Logging {
    public static Mx4jLoader$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Mx4jLoader$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Mx4jLoader$ mx4jLoader$ = this;
        synchronized (mx4jLoader$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean maybeLoad() {
        VerifiableProperties props = new VerifiableProperties(System.getProperties());
        if (!props.getBoolean("kafka_mx4jenable", false)) {
            return false;
        }
        String address = props.getString("mx4jaddress", "0.0.0.0");
        int port = props.getInt("mx4jport", 8082);
        try {
            this.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Will try to load MX4j now, if it's in the classpath");
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName processorName = new ObjectName("Server:name=XSLTProcessor");
            Class<?> httpAdaptorClass = Class.forName("mx4j.tools.adaptor.http.HttpAdaptor");
            Object httpAdaptor = httpAdaptorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            httpAdaptorClass.getMethod("setHost", String.class).invoke(httpAdaptor, address);
            httpAdaptorClass.getMethod("setPort", Integer.TYPE).invoke(httpAdaptor, BoxesRunTime.boxToInteger((int)port));
            ObjectName httpName = new ObjectName("system:name=http");
            mbs.registerMBean(httpAdaptor, httpName);
            Class<?> xsltProcessorClass = Class.forName("mx4j.tools.adaptor.http.XSLTProcessor");
            Object xsltProcessor = xsltProcessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            httpAdaptorClass.getMethod("setProcessor", Class.forName("mx4j.tools.adaptor.http.ProcessorMBean")).invoke(httpAdaptor, xsltProcessor);
            mbs.registerMBean(xsltProcessor, processorName);
            httpAdaptorClass.getMethod("start", new Class[0]).invoke(httpAdaptor, new Object[0]);
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "mx4j successfully loaded");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Will not load MX4J, mx4j-tools.jar is not in the classpath");
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Could not start register mbean in JMX", (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> e);
        }
        return false;
    }

    private Mx4jLoader$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

