/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static BrokerIdZNode$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new BrokerIdZNode$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    private String RackKey() {
        return this.RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack2) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HostKey()), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PortKey()), (Object)BoxesRunTime.boxToInteger((int)port)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey()), JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.connectionString(), Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey()), (Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey()), (Object)((Object)BoxesRunTime.boxToLong((long)Time.SYSTEM.milliseconds())).toString())}));
        rack2.foreach((Function1 & Serializable & scala.Serializable)rack -> version >= 3 ? jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RackKey()), rack)) : BoxedUnit.UNIT);
        Object object = version >= 4 ? jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey()), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName().value()), (Object)endPoint.securityProtocol().name), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())) : BoxedUnit.UNIT;
        return Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        EndPoint plaintextEndpoint = (EndPoint)broker.endPoints().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerIdZNode$.$anonfun$encode$4(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new EndPoint(null, -1, null, null));
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack());
    }

    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Seq seq;
        int jmxPort;
        int version;
        JsonObject brokerInfo;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            Right right = (Right)either;
            JsonValue js = (JsonValue)right.value();
            brokerInfo = js.asJsonObject();
            version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(String.valueOf(new String(jsonBytes, StandardCharsets.UTF_8))).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint}));
            } else {
                Option securityProtocolMap = brokerInfo.get(this.ListenerSecurityProtocolMapKey()).map((Function1 & Serializable & scala.Serializable)x$3 -> (scala.collection.immutable.Map)((TraversableLike)x$3.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String listenerName = (String)tuple2._1();
                    String securityProtocol = (String)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName(listenerName)), (Object)SecurityProtocol.forName((String)securityProtocol));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom()));
                Seq listeners = (Seq)brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                seq = (Seq)listeners.map((Function1 & Serializable & scala.Serializable)x$4 -> EndPoint$.MODULE$.createEndPoint((String)x$4, (Option<Map<ListenerName, SecurityProtocol>>)securityProtocolMap), Seq$.MODULE$.canBuildFrom());
            }
        } else {
            if (either instanceof Left) {
                Left left = (Left)either;
                JsonProcessingException e = (JsonProcessingException)((Object)left.value());
                throw new KafkaException(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").append(String.valueOf(new String(jsonBytes, StandardCharsets.UTF_8))).toString(), (Throwable)e);
            }
            throw new MatchError(either);
        }
        Seq endpoints = seq;
        Option rack = brokerInfo.get(this.RackKey()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$)));
        BrokerInfo brokerInfo2 = new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack), version, jmxPort);
        return brokerInfo2;
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private BrokerIdZNode$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

