/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.util.ClasspathResourceLoader;
import org.apache.lucene.util.ResourceLoader;

public final class FilesystemResourceLoader
implements ResourceLoader {
    private final Path baseDirectory;
    private final ResourceLoader delegate;

    public FilesystemResourceLoader(Path baseDirectory, ClassLoader delegate) {
        this(baseDirectory, (ResourceLoader)new ClasspathResourceLoader(delegate));
    }

    public FilesystemResourceLoader(Path baseDirectory, ResourceLoader delegate) {
        if (baseDirectory == null) {
            throw new NullPointerException();
        }
        if (!Files.isDirectory(baseDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(baseDirectory + " is not a directory");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate ResourceLoader may not be null");
        }
        this.baseDirectory = baseDirectory;
        this.delegate = delegate;
    }

    public InputStream openResource(String resource) throws IOException {
        try {
            return Files.newInputStream(this.baseDirectory.resolve(resource), new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException fnfe) {
            return this.delegate.openResource(resource);
        }
    }

    public <T> T newInstance(String cname, Class<T> expectedType) {
        return (T)this.delegate.newInstance(cname, expectedType);
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return this.delegate.findClass(cname, expectedType);
    }
}

