/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.util.BytesRef;

public class UnionFieldMetadataBuilder {
    private long dictionaryStartFP = -1L;
    private long minStartBlockFP = Long.MAX_VALUE;
    private long maxEndBlockFP = Long.MIN_VALUE;
    private BytesRef maxLastTerm;

    public UnionFieldMetadataBuilder addFieldMetadata(FieldMetadata fieldMetadata) {
        assert (this.dictionaryStartFP == -1L || this.dictionaryStartFP == fieldMetadata.getDictionaryStartFP());
        this.dictionaryStartFP = fieldMetadata.getDictionaryStartFP();
        this.minStartBlockFP = Math.min(this.minStartBlockFP, fieldMetadata.getFirstBlockStartFP());
        this.maxEndBlockFP = Math.max(this.maxEndBlockFP, fieldMetadata.getLastBlockStartFP());
        if (this.maxLastTerm == null || this.maxLastTerm.compareTo(fieldMetadata.getLastTerm()) < 0) {
            this.maxLastTerm = fieldMetadata.getLastTerm();
        }
        return this;
    }

    public FieldMetadata build() {
        if (this.maxLastTerm == null) {
            throw new IllegalStateException("no field metadata was provided");
        }
        return new FieldMetadata(this.dictionaryStartFP, this.minStartBlockFP, this.maxEndBlockFP, this.maxLastTerm);
    }
}

