/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.search.intervals.ConjunctionIntervalIterator;
import org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.Disjunctions;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.util.PriorityQueue;

class UnorderedIntervalsSource
extends ConjunctionIntervalsSource {
    private final boolean allowOverlaps;

    static IntervalsSource build(List<IntervalsSource> sources, boolean allowOverlaps) {
        if (sources.size() == 1) {
            return sources.get(0);
        }
        return new UnorderedIntervalsSource(UnorderedIntervalsSource.flatten(sources, allowOverlaps), allowOverlaps);
    }

    private static List<IntervalsSource> flatten(List<IntervalsSource> sources, boolean allowOverlaps) {
        ArrayList<IntervalsSource> flattened = new ArrayList<IntervalsSource>();
        for (IntervalsSource s : sources) {
            if (s instanceof UnorderedIntervalsSource && ((UnorderedIntervalsSource)s).allowOverlaps == allowOverlaps) {
                flattened.addAll(((UnorderedIntervalsSource)s).subSources);
                continue;
            }
            flattened.add(s);
        }
        return flattened;
    }

    private UnorderedIntervalsSource(List<IntervalsSource> sources, boolean allowOverlaps) {
        super(sources, true);
        this.allowOverlaps = allowOverlaps;
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        return new UnorderedIntervalIterator(iterators, this.allowOverlaps);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.subSources, ss -> new UnorderedIntervalsSource((List<IntervalsSource>)ss, this.allowOverlaps));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources, this.allowOverlaps);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UnorderedIntervalsSource)) {
            return false;
        }
        UnorderedIntervalsSource o = (UnorderedIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources) && Objects.equals(this.allowOverlaps, o.allowOverlaps);
    }

    @Override
    public String toString() {
        return (this.allowOverlaps ? "UNORDERED(" : "UNORDERED_NO_OVERLAPS(") + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class UnorderedIntervalIterator
    extends ConjunctionIntervalIterator {
        private final PriorityQueue<IntervalIterator> queue;
        private final IntervalIterator[] subIterators;
        private final int[] innerPositions;
        private final boolean allowOverlaps;
        int start = -1;
        int end = -1;
        int firstEnd;
        int queueEnd;

        UnorderedIntervalIterator(List<IntervalIterator> subIterators, boolean allowOverlaps) {
            super(subIterators);
            this.queue = new PriorityQueue<IntervalIterator>(subIterators.size()){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.start() < b.start() || a.start() == b.start() && a.end() >= b.end();
                }
            };
            this.subIterators = new IntervalIterator[subIterators.size()];
            this.innerPositions = new int[subIterators.size() * 2];
            this.allowOverlaps = allowOverlaps;
            for (int i = 0; i < subIterators.size(); ++i) {
                this.subIterators[i] = subIterators.get(i);
            }
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        void updateRightExtreme(IntervalIterator it) {
            int itEnd = it.end();
            if (itEnd > this.queueEnd) {
                this.queueEnd = itEnd;
            }
        }

        @Override
        public int nextInterval() throws IOException {
            IntervalIterator it;
            while (this.queue.size() == this.subIterators.length && ((IntervalIterator)((Object)this.queue.top())).start() == this.start) {
                it = (IntervalIterator)((Object)this.queue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                if (!this.allowOverlaps) {
                    while (this.hasOverlaps(it)) {
                        if (it.nextInterval() != Integer.MAX_VALUE) continue;
                        this.end = Integer.MAX_VALUE;
                        this.start = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                this.queue.add((Object)it);
                this.updateRightExtreme(it);
            }
            if (this.queue.size() < this.subIterators.length) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                this.start = ((IntervalIterator)((Object)this.queue.top())).start();
                this.firstEnd = ((IntervalIterator)((Object)this.queue.top())).end();
                this.end = this.queueEnd;
                if (((IntervalIterator)((Object)this.queue.top())).end() == this.end) {
                    return this.start;
                }
                it = (IntervalIterator)((Object)this.queue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                if (!this.allowOverlaps) {
                    while (this.hasOverlaps(it)) {
                        if (it.nextInterval() != Integer.MAX_VALUE) continue;
                        return this.start;
                    }
                }
                this.queue.add((Object)it);
                this.updateRightExtreme(it);
            } while (this.queue.size() == this.subIterators.length && this.end == this.queueEnd);
            return this.start;
        }

        @Override
        public int gaps() {
            for (int i = 0; i < this.subIterators.length; ++i) {
                if (this.subIterators[i].end() > this.end) {
                    this.innerPositions[i * 2] = this.start;
                    this.innerPositions[i * 2 + 1] = this.firstEnd;
                    continue;
                }
                this.innerPositions[i * 2] = this.subIterators[i].start();
                this.innerPositions[i * 2 + 1] = this.subIterators[i].end();
            }
            Arrays.sort(this.innerPositions);
            int gaps = 0;
            for (int i = 1; i < this.subIterators.length; ++i) {
                gaps += this.innerPositions[i * 2] - this.innerPositions[i * 2 - 1] - 1;
            }
            return gaps;
        }

        @Override
        protected void reset() throws IOException {
            this.end = -1;
            this.start = -1;
            this.queueEnd = -1;
            this.queue.clear();
            block0: for (IntervalIterator it : this.subIterators) {
                if (it.nextInterval() == Integer.MAX_VALUE) break;
                if (!this.allowOverlaps) {
                    while (this.hasOverlaps(it)) {
                        if (it.nextInterval() != Integer.MAX_VALUE) continue;
                        break block0;
                    }
                }
                this.queue.add((Object)it);
                this.updateRightExtreme(it);
            }
        }

        private boolean hasOverlaps(IntervalIterator candidate) {
            for (IntervalIterator it : this.queue) {
                if (it.start() < candidate.start()) {
                    if (it.end() < candidate.start()) continue;
                    return true;
                }
                if (it.start() == candidate.start()) {
                    return true;
                }
                if (it.start() > candidate.end()) continue;
                return true;
            }
            return false;
        }
    }
}

