/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.model.jdbc.AbstractBooleanPrefJDBCDataModel;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQL92BooleanPrefJDBCDataModel
extends AbstractBooleanPrefJDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(SQL92BooleanPrefJDBCDataModel.class);
    private final String verifyPreferenceSQL;

    public SQL92BooleanPrefJDBCDataModel() throws TasteException {
        this("jdbc/taste");
    }

    public SQL92BooleanPrefJDBCDataModel(String dataSourceName) throws TasteException {
        this(AbstractJDBCComponent.lookupDataSource((String)dataSourceName), "taste_preferences", "user_id", "item_id", "timestamp");
    }

    public SQL92BooleanPrefJDBCDataModel(DataSource dataSource) {
        this(dataSource, "taste_preferences", "user_id", "item_id", "timestamp");
    }

    public SQL92BooleanPrefJDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String timestampColumn) {
        super(dataSource, preferenceTable, userIDColumn, itemIDColumn, "NO_SUCH_COLUMN", "SELECT 1 FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT " + timestampColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + " FROM " + preferenceTable + " ORDER BY " + userIDColumn, "SELECT COUNT(DISTINCT " + itemIDColumn + ") FROM " + preferenceTable, "SELECT COUNT(DISTINCT " + userIDColumn + ") FROM " + preferenceTable, "INSERT INTO " + preferenceTable + '(' + userIDColumn + ',' + itemIDColumn + ") VALUES (?,?)", "DELETE FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + " FROM " + preferenceTable + " ORDER BY " + userIDColumn, "SELECT DISTINCT " + itemIDColumn + " FROM " + preferenceTable + " ORDER BY " + itemIDColumn, "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + " FROM " + preferenceTable + " WHERE " + itemIDColumn + "=? ORDER BY " + userIDColumn, "SELECT COUNT(1) FROM " + preferenceTable + " WHERE " + itemIDColumn + "=?", "SELECT COUNT(1) FROM " + preferenceTable + " tp1 JOIN " + preferenceTable + " tp2 " + "USING (" + userIDColumn + ") WHERE tp1." + itemIDColumn + "=? and tp2." + itemIDColumn + "=?", "SELECT 1.0", "SELECT 1.0");
        this.verifyPreferenceSQL = "SELECT 1 FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?";
    }

    protected String getVerifyPreferenceSQL() {
        return this.verifyPreferenceSQL;
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument((!Float.isNaN(value) ? 1 : 0) != 0, (Object)"NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        String setPreferenceSQL = this.getSetPreferenceSQL();
        Connection conn = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        try {
            conn = this.getDataSource().getConnection();
            stmt1 = conn.prepareStatement(this.verifyPreferenceSQL, 1003, 1007);
            this.setLongParameter(stmt1, 1, userID);
            this.setLongParameter(stmt1, 2, itemID);
            ResultSet rs = stmt1.executeQuery();
            if (!rs.first()) {
                stmt2 = conn.prepareStatement(setPreferenceSQL);
                this.setLongParameter(stmt2, 1, userID);
                this.setLongParameter(stmt2, 2, itemID);
                stmt2.setDouble(3, value);
                log.debug("Executing SQL update: {}", (Object)setPreferenceSQL);
                stmt2.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while setting preference", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(stmt1);
                IOUtils.quietClose(stmt2);
                IOUtils.quietClose((Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((Statement)stmt1);
        IOUtils.quietClose((Statement)stmt2);
        IOUtils.quietClose((Connection)conn);
    }
}

